/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.StyleProperties;
import org.openconcerto.openoffice.StyleStyle;
import org.openconcerto.openoffice.StyleStyleDesc;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.text.ParagraphStyle;
import org.openconcerto.openoffice.text.TextStyle;

public class GraphicStyle
extends StyleStyle {
    public static final StyleStyleDesc<GraphicStyle> DESC = new StyleStyleDesc<GraphicStyle>(GraphicStyle.class, XMLVersion.OD, "graphic", "fr", "draw", Arrays.asList("dr3d:cube", "dr3d:extrude", "dr3d:rotate", "dr3d:scene", "dr3d:sphere", "draw:caption", "draw:circle", "draw:connector", "draw:control", "draw:custom-shape", "draw:ellipse", "draw:frame", "draw:g", "draw:line", "draw:measure", "draw:page-thumbnail", "draw:path", "draw:polygon", "draw:polyline", "draw:rect", "draw:regular-polygon", "office:annotation")){

        @Override
        public GraphicStyle create(ODPackage pkg, Element e) {
            return new GraphicStyle(pkg, e);
        }
    };
    public static final StyleStyleDesc<GraphicStyle> DESC_OO = new StyleStyleDesc<GraphicStyle>(GraphicStyle.class, XMLVersion.OOo, "graphics", "fr", "draw", Arrays.asList("draw:text-box", "draw:image", "draw:caption", "draw:circle", "draw:connector", "draw:control", "draw:ellipse", "draw:line", "draw:measure", "draw:page-thumbnail", "draw:path", "draw:polygon", "draw:polyline", "draw:rect")){

        @Override
        public GraphicStyle create(ODPackage pkg, Element e) {
            return new GraphicStyle(pkg, e);
        }
    };
    private TextStyle.StyleTextProperties textProps = null;
    private ParagraphStyle.StyleParagraphProperties pProps = null;
    private StyleGraphicProperties graphProps = null;

    public GraphicStyle(ODPackage pkg, Element tableColElem) {
        super(pkg, tableColElem);
    }

    public final TextStyle.StyleTextProperties getTextProperties() {
        if (this.textProps == null) {
            this.textProps = new TextStyle.StyleTextProperties(this);
        }
        return this.textProps;
    }

    public final ParagraphStyle.StyleParagraphProperties getParagraphProperties() {
        if (this.pProps == null) {
            this.pProps = new ParagraphStyle.StyleParagraphProperties(this);
        }
        return this.pProps;
    }

    public final StyleGraphicProperties getGraphicProperties() {
        if (this.graphProps == null) {
            this.graphProps = new StyleGraphicProperties(this);
        }
        return this.graphProps;
    }

    public static class StyleGraphicProperties
    extends StyleProperties {
        private static Pattern split = Pattern.compile(" ");

        public StyleGraphicProperties(StyleStyle style) {
            super(style, DESC.getFamily());
        }

        public final String getHorizontalPosition() {
            return this.getAttributeValue("horizontal-pos", this.getElement().getNamespace("style"));
        }

        public final String getHorizontalRelation() {
            return this.getAttributeValue("horizontal-rel", this.getElement().getNamespace("style"));
        }

        public final String getVerticalPosition() {
            return this.getAttributeValue("vertical-pos", this.getElement().getNamespace("style"));
        }

        public final String getVerticalRelation() {
            return this.getAttributeValue("vertical-rel", this.getElement().getNamespace("style"));
        }

        public final List<String> getProtected() {
            String val = this.getAttributeValue("protect", this.getElement().getNamespace("style"));
            if (val == null || "none".equals(val)) {
                return Collections.emptyList();
            }
            return Arrays.asList(split.split(val));
        }

        public final boolean isContentPrinted() {
            return StyleGraphicProperties.parseBoolean(this.getAttributeValue("print-content", this.getElement().getNamespace("style")), true);
        }
    }
}

