/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.odtemplate;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.odtemplate.Template;
import org.openconcerto.odtemplate.engine.OGNLDataModel;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODSingleXMLDocument;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.generation.DocumentGenerator;
import org.openconcerto.openoffice.generation.GenerationCommon;
import org.openconcerto.openoffice.generation.ReportGeneration;
import org.openconcerto.utils.ExceptionUtils;

public class TemplateGenerator<R extends ReportGeneration<?>>
extends DocumentGenerator<R> {
    private final File file;

    public TemplateGenerator(R rg, File f) {
        super(rg);
        this.file = f;
    }

    @Override
    public final ODSingleXMLDocument generate() throws IOException, InterruptedException {
        return this.substitute(this.getAllData());
    }

    protected final Map<String, Object> getAllData() throws IOException, InterruptedException {
        HashMap<String, Object> res = new HashMap<String, Object>(((ReportGeneration)this.getRg()).getCommonData());
        res.putAll(this.getData());
        return res;
    }

    protected Map<String, Object> getData() throws InterruptedException {
        return new HashMap<String, Object>();
    }

    private final ODSingleXMLDocument substitute(Map data) throws FileNotFoundException, IOException {
        XMLVersion reportVersion = ((GenerationCommon)((ReportGeneration)this.getRg()).getCommon()).getOOVersion();
        ODPackage pkg = new ODPackage(this.file);
        if (pkg.getVersion() != reportVersion) {
            throw new IllegalArgumentException("version mismatch");
        }
        try {
            this.transform(pkg.toSingle());
            return new Template(pkg).createDocument(new OGNLDataModel(data));
        }
        catch (Exception exn) {
            throw ExceptionUtils.createExn(IOException.class, "generation error in " + this, exn);
        }
    }

    protected void transform(ODSingleXMLDocument single) throws Exception {
    }

    public String toString() {
        return this.getClass() + " with file " + this.file;
    }
}

