/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.laf;

import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.TextField;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class LAFUtils {
    private static LookAndFeel SYSTEM_LAF = null;
    private static final Map<LookAndFeel, UIDefaults> defaults = new HashMap<LookAndFeel, UIDefaults>();
    public static final String Mac_ID = "Aqua";
    public static final String ClassicMac_ID = "Mac";
    public static final String Windows_ID = "Windows";
    public static final String Motif_ID = "Metal";
    public static final String Metal_ID = "Motif";
    public static final String GTK_ID = "GTK";
    public static final String Nimbus_ID = "Nimbus";

    private LAFUtils() {
    }

    public static LookAndFeel getSystemLAF() {
        if (SYSTEM_LAF == null) {
            try {
                SYSTEM_LAF = (LookAndFeel)Class.forName(UIManager.getSystemLookAndFeelClassName(), true, Thread.currentThread().getContextClassLoader()).newInstance();
                SYSTEM_LAF.initialize();
            }
            catch (Exception e) {
                throw new IllegalStateException("could not initialize " + UIManager.getSystemLookAndFeelClassName(), e);
            }
        }
        return SYSTEM_LAF;
    }

    private static UIDefaults getDefaults(LookAndFeel laf) {
        if (!defaults.containsKey(laf)) {
            defaults.put(laf, laf.getDefaults());
        }
        return defaults.get(laf);
    }

    public static Font getFont(String name) {
        return LAFUtils.getFont(name, LAFUtils.getSystemLAF());
    }

    public static Font getFont(String name, LookAndFeel laf) {
        return LAFUtils.getDefaults(laf).getFont(name);
    }

    public static String getUIName(Component comp) {
        String res = comp instanceof JComboBox ? "ComboBox" : (comp instanceof JTextField || comp instanceof TextField ? "TextField" : (comp instanceof JLabel || comp instanceof Label ? "Label" : null));
        return res;
    }
}

