/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.laf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class IScrollBarUI
extends BasicScrollBarUI {
    private static final Color COLOR_DARK = new Color(140, 141, 121);
    private static Color highlightColor;
    private static Color darkShadowColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    protected boolean isRollover = false;
    protected boolean wasRollover = false;
    private boolean freeStanding = false;
    int scrollBarWidth;
    Image h;
    Image b;
    JButton decreaseButton;
    JButton increaseButton;

    @Override
    protected void installDefaults() {
        this.scrollBarWidth = 13;
        super.installDefaults();
        this.scrollbar.setBorder(null);
        this.h = new ImageIcon(this.getClass().getResource("scrollHaut.png")).getImage();
        this.b = new ImageIcon(this.getClass().getResource("scrollBas.png")).getImage();
    }

    public static ComponentUI createUI(JComponent c) {
        return new IScrollBarUI();
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = orientation == 1 ? new JButton(new ImageIcon(this.getClass().getResource("up.png"))) : new JButton(new ImageIcon(this.getClass().getResource("left.png")));
        this.decreaseButton.setBorder(null);
        return this.decreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = orientation == 5 ? new JButton(new ImageIcon(this.getClass().getResource("down.png"))) : new JButton(new ImageIcon(this.getClass().getResource("right.png")));
        this.increaseButton.setBorder(null);
        return this.increaseButton;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.scrollBarWidth * 3 + 10);
        }
        return new Dimension(this.scrollBarWidth * 3 + 10, this.scrollBarWidth);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle trackBounds = this.getTrackBounds();
        g.setColor(new Color(255, 0, 0));
        this.drawFond(g, 0, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
        Rectangle thumbBounds = this.getThumbBounds();
        this.drawThumb(g, thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
    }

    private void drawThumb(Graphics g, int x, int y, int width, int height) {
        g.setColor(new Color(244, 244, 240));
        g.fillRect(++x, ++y, width -= 3, height -= 2);
        g.setColor(COLOR_DARK);
        g.drawRect(x, y, width + 1, height);
        g.setColor(new Color(252, 252, 251));
        g.drawLine(x + 1, y + 1, x + 1, y + height - 5);
        g.setColor(new Color(225, 225, 214));
        g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 5);
        g.setColor(new Color(237, 237, 231));
        g.drawLine(x + width - 2, y + 1, x + width - 2, y + height - 5);
        g.drawImage(this.h, x + width - 8, y + 1, null);
        g.drawImage(this.b, x + width - 8, y + height - 5, null);
        g.setColor(COLOR_DARK);
        if (height > width) {
            int yindex = y + height / 2;
            g.drawLine(x + 4, yindex - 3, x + width - 4, yindex - 3);
            g.drawLine(x + 4, yindex, x + width - 4, yindex);
            g.drawLine(x + 4, yindex + 3, x + width - 4, yindex + 3);
        } else {
            int xindex = x + width / 2;
            g.drawLine(xindex - 3, y + 4, xindex - 3, y + height - 4);
            g.drawLine(xindex, y + 4, xindex, y + height - 4);
            g.drawLine(xindex + 3, y + 4, xindex + 3, y + height - 4);
        }
    }

    private void drawFond(Graphics g, int i, int x, int y, int width, int height) {
        g.setColor(new Color(239, 235, 231));
        g.fillRect(x, y, width, height);
    }

    public boolean isThumbVisible() {
        if (this.scrollbar.getOrientation() == 1) {
            return this.getThumbBounds().height != 0;
        }
        return this.getThumbBounds().width != 0;
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new MyTrackListener();
    }

    protected class MyTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected MyTrackListener() {
            super(IScrollBarUI.this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            IScrollBarUI.this.scrollbar.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            IScrollBarUI.this.scrollbar.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            IScrollBarUI.this.isRollover = false;
            IScrollBarUI.this.wasRollover = false;
            if (IScrollBarUI.this.getThumbBounds().contains(e.getX(), e.getY())) {
                IScrollBarUI.this.isRollover = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            IScrollBarUI.this.isRollover = false;
            if (IScrollBarUI.this.isRollover != IScrollBarUI.this.wasRollover) {
                IScrollBarUI.this.scrollbar.repaint();
                IScrollBarUI.this.wasRollover = IScrollBarUI.this.isRollover;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (IScrollBarUI.this.getThumbBounds().contains(e.getX(), e.getY())) {
                IScrollBarUI.this.isRollover = true;
            }
            super.mouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (IScrollBarUI.this.getThumbBounds().contains(e.getX(), e.getY())) {
                IScrollBarUI.this.isRollover = true;
                if (IScrollBarUI.this.isRollover != IScrollBarUI.this.wasRollover) {
                    IScrollBarUI.this.scrollbar.repaint();
                    IScrollBarUI.this.wasRollover = IScrollBarUI.this.isRollover;
                }
            } else {
                IScrollBarUI.this.isRollover = false;
                if (IScrollBarUI.this.isRollover != IScrollBarUI.this.wasRollover) {
                    IScrollBarUI.this.scrollbar.repaint();
                    IScrollBarUI.this.wasRollover = IScrollBarUI.this.isRollover;
                }
            }
        }
    }
}

