/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ftp.updater;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.openconcerto.ftp.FTPUtils;
import org.openconcerto.ftp.IFtp;
import org.openconcerto.utils.FileUtils;

public class UpdateManager
implements Runnable {
    private Thread thread;
    private String login;
    private String pass;
    private String server;
    private String file;
    private static boolean stop = false;
    private static final int UPDATE_COUNT = 2;
    private static int counter = 2;
    private boolean enabled;

    UpdateManager() {
        block5: {
            Properties props = new Properties();
            File f = new File("Configuration/update.properties");
            if (f.exists()) {
                try {
                    props.load(new FileInputStream("Configuration/update.properties"));
                    this.login = props.getProperty("login");
                    this.pass = props.getProperty("pass");
                    this.server = props.getProperty("ftpserver");
                    this.file = props.getProperty("file");
                    this.enabled = Boolean.parseBoolean(props.getProperty("enabled"));
                    if (!this.enabled) {
                        System.out.println("Mise \u00e0 jour d\u00e9sactiv\u00e9es");
                        break block5;
                    }
                    this.thread = new Thread(this);
                    this.thread.setDaemon(true);
                    this.thread.setPriority(1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("Mise \u00e0 jour d\u00e9sactiv\u00e9es (fichier de configuration manquant)");
            }
        }
    }

    public static synchronized void start() {
        UpdateManager u = new UpdateManager();
        if (u.isStarted()) {
            throw new RuntimeException("UpdateManager already started");
        }
        u.startWatcher();
    }

    public static synchronized void stop() {
        stop = true;
    }

    public static synchronized void forceUpdate() {
        counter = 2;
    }

    private boolean isStarted() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.isAlive();
    }

    private void startWatcher() {
        if (this.enabled) {
            this.thread.start();
        }
    }

    @Override
    public void run() {
        System.err.println("UpdateManager started");
        while (!stop) {
            block32: {
                if (counter >= 2) {
                    counter = 0;
                    IFtp ftp = new IFtp();
                    BufferedReader bReaderRemote = null;
                    try {
                        try {
                            Object[] options;
                            int res;
                            int currentVersion;
                            int newVersion;
                            block30: {
                                ftp.connect(this.server);
                                boolean logged = ftp.login(this.login, this.pass);
                                if (!logged) {
                                    throw new IllegalStateException("Identifiants refus\u00e9s");
                                }
                                bReaderRemote = new BufferedReader(new InputStreamReader(ftp.retrieveFileStream(this.file)));
                                newVersion = Integer.parseInt(bReaderRemote.readLine());
                                BufferedReader bReaderLocal = null;
                                currentVersion = -1;
                                try {
                                    try {
                                        bReaderLocal = new BufferedReader(new FileReader(".version"));
                                        currentVersion = Integer.parseInt(bReaderLocal.readLine());
                                    }
                                    catch (Exception e) {
                                        System.err.println(".version manquant");
                                        if (bReaderLocal != null) {
                                            bReaderLocal.close();
                                        }
                                        break block30;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (bReaderLocal != null) {
                                        bReaderLocal.close();
                                    }
                                    throw throwable;
                                }
                                if (bReaderLocal != null) {
                                    bReaderLocal.close();
                                }
                            }
                            if (newVersion > currentVersion && (res = JOptionPane.showOptionDialog(null, "Une mise \u00e0 jour est disponible. Installer la mise \u00e0 jour:", "Mises \u00e0 jour automatiques", -1, 2, null, options = new Object[]{"Maintenant", "Plus tard"}, options[0])) == 0) {
                                this.update(newVersion);
                            }
                        }
                        catch (Exception e) {
                            Object[] options = new Object[]{"R\u00e9essayer dans 1 minute", "Abandonner"};
                            int res = JOptionPane.showOptionDialog(null, "Impossible de se connecter au serveur de mises \u00e0 jour.\n" + e.getMessage(), "Mises \u00e0 jour automatiques", -1, 2, null, options, options[0]);
                            if (res == 0) {
                                --counter;
                            } else {
                                stop = true;
                            }
                            e.printStackTrace();
                            try {
                                System.err.println("Disconnect start");
                                if (bReaderRemote != null) {
                                    bReaderRemote.close();
                                }
                                ftp.quit();
                                System.err.println("Disconnected start");
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                            break block32;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            System.err.println("Disconnect start");
                            if (bReaderRemote != null) {
                                bReaderRemote.close();
                            }
                            ftp.quit();
                            System.err.println("Disconnected start");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        System.err.println("Disconnect start");
                        if (bReaderRemote != null) {
                            bReaderRemote.close();
                        }
                        ftp.quit();
                        System.err.println("Disconnected start");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!stop) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ++counter;
        }
        System.err.println("UpdateManager stopped");
    }

    private void update(int toVersion) {
        System.out.println("Update application");
        File tempDir = new File("Update");
        if (tempDir.exists()) {
            FileUtils.rmR(tempDir);
        }
        tempDir.mkdir();
        File f = new File("Update/.version");
        try {
            FileOutputStream fOp = new FileOutputStream(f);
            PrintStream out = new PrintStream(fOp);
            out.println(toVersion);
            out.close();
        }
        catch (FileNotFoundException e1) {
            JOptionPane.showMessageDialog(null, "Impossible de cr\u00e9er le .version");
        }
        IFtp ftp = new IFtp();
        try {
            boolean cwdOk;
            ftp.connect(this.server);
            boolean logged = ftp.login(this.login, this.pass);
            if (!logged) {
                JOptionPane.showMessageDialog(null, "Impossible d'acc\u00e9der au serveur FTP pour r\u00e9cup\u00e9rer les fichiers");
                ftp.disconnect();
                return;
            }
            String dir = this.file;
            int i = dir.lastIndexOf(46);
            if (i > 0) {
                dir = dir.substring(0, i);
            }
            if (!(cwdOk = ftp.changeWorkingDirectory(dir))) {
                JOptionPane.showMessageDialog(null, "Impossible d'acc\u00e9der au dossier " + dir + " du serveur FTP");
                ftp.disconnect();
                return;
            }
            FTPUtils.saveR(ftp, tempDir);
            if (tempDir.getAbsolutePath().contains("workspace") && !tempDir.getAbsolutePath().contains("dist")) {
                JOptionPane.showMessageDialog(null, "Mise \u00e0 jour desactiv\u00e9e en version non 'dist'");
                ftp.disconnect();
                return;
            }
            String updaterFilename = "Update" + File.separator + "update.jar";
            if (!new File(updaterFilename).exists()) {
                JOptionPane.showMessageDialog(null, "Le fichier 'Update/update.jar' est manquant.");
                ftp.disconnect();
                return;
            }
            Runtime.getRuntime().exec("java -jar " + updaterFilename);
            ftp.disconnect();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Impossible de r\u00e9cup\u00e9rer les fichiers");
        }
    }
}

