/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.utils.correct;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;

public class CorrectMouvement
extends Changer<DBRoot> {
    public CorrectMouvement(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected void changeImpl(DBRoot societeRoot) throws SQLException {
        SQLTable ecritureT = societeRoot.getTable("ECRITURE");
        SQLField ecritureMvtFF = ecritureT.getField("ID_MOUVEMENT");
        SQLSelect selUnbalanced = new SQLSelect(societeRoot.getBase());
        selUnbalanced.addSelect(ecritureMvtFF);
        selUnbalanced.addGroupBy(ecritureMvtFF);
        selUnbalanced.setHaving(Where.quote(societeRoot.getBase().quote("SUM(%n) != SUM(%n)", ecritureT.getField("DEBIT"), ecritureT.getField("CREDIT")), new Object[0]));
        SQLSelect selUnfixable = new SQLSelect(selUnbalanced);
        selUnfixable.setArchivedPolicy(SQLSelect.ArchiveMode.BOTH);
        String selFixableUnbalanced = "( " + selUnbalanced.asString() + "\nEXCEPT\n" + selUnfixable.asString() + " )";
        UpdateBuilder updateUnbalanced = new UpdateBuilder(ecritureT);
        updateUnbalanced.addTable(selFixableUnbalanced, SQLBase.quoteIdentifier("semiArchivedMvt"));
        updateUnbalanced.setWhere(Where.quote("%i = %f", new SQLName("semiArchivedMvt", "ID_MOUVEMENT"), ecritureMvtFF));
        updateUnbalanced.set(ecritureT.getArchiveField().getName(), "0");
        this.getDS().execute(updateUnbalanced.asString());
        SQLTable saisieKmElemT = societeRoot.getGraph().findReferentTable(ecritureT, "SAISIE_KM_ELEMENT", new String[0]);
        SQLTable saisieKmT = saisieKmElemT.getForeignTable("ID_SAISIE_KM");
        SQLSelect selIdentifiableNonUsed = new SQLSelect(societeRoot.getBase());
        List<String> uniqueFields = Arrays.asList("ID_MOUVEMENT", "DEBIT", "CREDIT");
        selIdentifiableNonUsed.addAllSelect(ecritureT, uniqueFields);
        String quotedID = ecritureT.getKey().getSQLName(ecritureT).quote();
        String uniqueID = this.getSyntax().getSystem() == SQLSystem.POSTGRESQL ? "(array_agg(" + quotedID + "))[1]" : "cast(GROUP_CONCAT(" + quotedID + ") as integer)";
        String uniqueIDAlias = "ID";
        selIdentifiableNonUsed.addRawSelect(uniqueID, "ID");
        selIdentifiableNonUsed.addBackwardJoin("LEFT", null, saisieKmElemT.getField("ID_ECRITURE"), null);
        selIdentifiableNonUsed.setWhere(Where.isNull(saisieKmElemT.getKey()));
        for (String uniqField : uniqueFields) {
            selIdentifiableNonUsed.addGroupBy(ecritureT.getField(uniqField));
        }
        selIdentifiableNonUsed.setHaving(Where.createRaw("count(*) = 1", new FieldRef[0]));
        UpdateBuilder update = new UpdateBuilder(saisieKmElemT);
        update.addTable(saisieKmT.getSQLName().quote(), null);
        update.addTable("( " + selIdentifiableNonUsed.asString() + " )", "e");
        Where joinSaisieKmW = new Where((FieldRef)saisieKmElemT.getField("ID_SAISIE_KM"), "=", saisieKmT.getKey());
        Where joinEcritureW = null;
        for (String uniqField : uniqueFields) {
            SQLTable t = uniqField.equals("ID_MOUVEMENT") ? saisieKmT : saisieKmElemT;
            joinEcritureW = Where.quote("e." + SQLBase.quoteIdentifier(uniqField) + "= %f", t.getField(uniqField)).and(joinEcritureW);
        }
        Where dontOverwrite = new Where((FieldRef)saisieKmElemT.getField("ID_ECRITURE"), Where.NULL_IS_DATA_EQ, (Object)ecritureT.getUndefinedIDNumber());
        Where dontUpdateUndef = new Where((FieldRef)saisieKmElemT.getKey(), Where.NULL_IS_DATA_NEQ, (Object)saisieKmElemT.getUndefinedIDNumber());
        Where unarchived = new Where((FieldRef)saisieKmElemT.getArchiveField(), "=", 0);
        update.setWhere(joinSaisieKmW.and(joinEcritureW).and(dontOverwrite).and(dontUpdateUndef).and(unarchived));
        update.set("ID_ECRITURE", "e." + SQLBase.quoteIdentifier("ID"));
        this.getDS().execute(update.asString());
    }
}

