/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.utils;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.erp.utils.StatusListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.changer.correct.FixSerial;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItemDB;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLCreateRoot;
import org.openconcerto.utils.ExceptionHandler;

public class ActionDB {
    private static final Properties props = new Properties();

    static {
        props.put("jdbc.connection.allowMultiQueries", "true");
    }

    public static void dupliqueDB(String baseDefault, String newBase, StatusListener l) {
        DBSystemRoot sysRoot = Configuration.getInstance().getSystemRoot();
        try {
            ActionDB.log(l, "Cr\u00e9ation du sch\u00e9ma");
            if (!sysRoot.getRootsToMap().contains(baseDefault)) {
                sysRoot.getRootsToMap().add(baseDefault);
                sysRoot.refetch(Collections.singleton(baseDefault));
            }
            DBRoot baseSQLDefault = sysRoot.getRoot(baseDefault);
            ActionDB.log(l, "Traitement des " + baseSQLDefault.getChildrenNames().size() + " tables");
            SQLCreateRoot createRoot = baseSQLDefault.getDefinitionSQL(sysRoot.getServer().getSQLSystem());
            SQLDataSource ds = sysRoot.getDataSource();
            ds.execute(createRoot.asString(newBase, false, true));
            sysRoot.getRootsToMap().add(newBase);
            boolean origVal = Boolean.getBoolean("org.openconcerto.sql.noautoCreateMetadata");
            if (!origVal) {
                System.setProperty("org.openconcerto.sql.noautoCreateMetadata", "true");
            }
            sysRoot.refetch(Collections.singleton(newBase));
            if (!origVal) {
                System.setProperty("org.openconcerto.sql.noautoCreateMetadata", "false");
            }
            DBRoot baseSQLNew = sysRoot.getRoot(newBase);
            Set<SQLTable> newTables = baseSQLNew.getTables();
            int i = 0;
            SQLSyntax syntax = sysRoot.getServer().getSQLSystem().getSyntax();
            ds.execute(syntax.disableFKChecks(baseSQLNew));
            for (SQLTable table : newTables) {
                String tableName = table.getName();
                ActionDB.log(l, "Copie de la table " + tableName + " " + (i + 1) + "/" + newTables.size());
                ActionDB.dumpTable(baseSQLDefault, table);
                ActionDB.log(l, "Table " + tableName + " " + (i + 1) + "/" + newTables.size() + " OK");
                ++i;
            }
            ds.execute(syntax.enableFKChecks(baseSQLNew));
            if (syntax.getSystem() == SQLSystem.POSTGRESQL) {
                ActionDB.log(l, "Maj des s\u00e9quences des tables");
                new FixSerial(sysRoot).changeAll(baseSQLNew);
            }
            ActionDB.log(l, "Duplication termin\u00e9e");
        }
        catch (Throwable e) {
            e.printStackTrace();
            ExceptionHandler.handle("Erreur pendant la cr\u00e9ation de la base!", e);
            ActionDB.log(l, "Erreur pendant la duplication");
        }
    }

    private static void log(StatusListener l, String message) {
        if (l != null) {
            l.statusChanged(message);
        }
    }

    private static void dumpTable(DBRoot source, SQLTable newTable) {
        try {
            SQLRowValues.insertFromTable(newTable, source.getTable(newTable.getName()));
        }
        catch (SQLException e) {
            System.err.println("Unable to dump table " + newTable.getName());
            e.printStackTrace();
        }
    }

    public static void compareDB(int base, int baseDefault) {
        try {
            Set<SQLField> s;
            HashMap<String, SQLField> m;
            if (Configuration.getInstance() == null) {
                Configuration.setInstance(ComptaPropsConfiguration.create());
            }
            Configuration instance = Configuration.getInstance();
            SQLTable tableSociete = Configuration.getInstance().getBase().getTable("SOCIETE_COMMON");
            String baseName = tableSociete.getRow(base).getString("DATABASE_NAME");
            String baseDefaultName = tableSociete.getRow(baseDefault).getString("DATABASE_NAME");
            instance.getBase().getDBSystemRoot().getRootsToMap().clear();
            try {
                HashSet<String> s2 = new HashSet<String>();
                s2.add(baseName);
                s2.add(baseDefaultName);
                instance.getBase().fetchTables(s2);
            }
            catch (SQLException e) {
                throw new IllegalStateException("could not access societe base", e);
            }
            System.err.println("baseName" + baseName);
            System.err.println("baseDefault" + baseDefaultName);
            instance.getSystemRoot().prependToRootPath("Common");
            instance.getSystemRoot().prependToRootPath(baseName);
            instance.getSystemRoot().prependToRootPath(baseDefaultName);
            SQLSchema baseSQL = instance.getBase().getSchema(baseName);
            SQLSchema baseSQLDefault = instance.getBase().getSchema(baseDefaultName);
            DatabaseMetaData dbMetaDataSociete = baseSQL.getBase().getDataSource().getConnection().getMetaData();
            DatabaseMetaData dbMetaDataSocieteDefault = baseSQLDefault.getBase().getDataSource().getConnection().getMetaData();
            HashMap mapTableSociete = new HashMap();
            HashMap mapTableSocieteDefault = new HashMap();
            ResultSet rs = dbMetaDataSociete.getTables("", baseSQL.getName(), "%", null);
            System.err.println("Start");
            while (rs.next()) {
                if (rs.getString("TABLE_TYPE") == null || !rs.getString("TABLE_TYPE").equalsIgnoreCase("TABLE")) continue;
                m = new HashMap<String, SQLField>();
                baseSQL.getTableNames();
                s = baseSQL.getTable(rs.getString("TABLE_NAME")).getFields();
                for (SQLField field : s) {
                    m.put(field.getName(), field);
                }
                mapTableSociete.put(rs.getString("TABLE_NAME"), m);
            }
            rs.close();
            rs = dbMetaDataSocieteDefault.getTables("", baseSQLDefault.getName(), "%", null);
            while (rs.next()) {
                if (rs.getString("TABLE_TYPE") == null || !rs.getString("TABLE_TYPE").equalsIgnoreCase("TABLE")) continue;
                m = new HashMap();
                s = baseSQLDefault.getTable(rs.getString("TABLE_NAME")).getFields();
                for (SQLField field : s) {
                    m.put(field.getName(), field);
                }
                mapTableSocieteDefault.put(rs.getString("TABLE_NAME"), m);
            }
            rs.close();
            System.err.println("Test 1 " + mapTableSociete.keySet().size());
            for (String tableName : mapTableSociete.keySet()) {
                if (!mapTableSocieteDefault.containsKey(tableName)) {
                    System.err.println("!! **** La table " + tableName + " n'est pas dans la base " + baseDefault);
                    continue;
                }
                Map mSoc = (Map)mapTableSociete.get(tableName);
                Map mDef = (Map)mapTableSocieteDefault.get(tableName);
                if (mSoc.keySet().containsAll(mDef.keySet())) {
                    if (mSoc.keySet().size() == mDef.keySet().size()) {
                        System.err.println("Table " + tableName + " --- OK");
                        ActionDB.compareTypeField(mSoc, mDef);
                        continue;
                    }
                    if (mSoc.keySet().size() <= mDef.keySet().size()) continue;
                    for (String fieldName : mDef.keySet()) {
                        mSoc.remove(fieldName);
                    }
                    System.err.println("!! **** Difference Table " + tableName);
                    System.err.println(String.valueOf(tableSociete.getRow(baseDefault).getString("DATABASE_NAME")) + " Set Column " + mSoc);
                    System.err.println(ActionDB.getAlterTable(mSoc, tableSociete.getRow(baseDefault).getString("DATABASE_NAME"), tableName));
                    continue;
                }
                for (String fieldName : mSoc.keySet()) {
                    mDef.remove(fieldName);
                }
                System.err.println("!! **** Difference Table " + tableName);
                System.err.println(String.valueOf(tableSociete.getRow(base).getString("DATABASE_NAME")) + " Set Column " + mDef);
                System.err.println(ActionDB.getAlterTable(mDef, tableSociete.getRow(base).getString("DATABASE_NAME"), tableName));
            }
            System.err.println("Test 2 " + mapTableSocieteDefault.keySet().size());
            for (Object tableName : mapTableSocieteDefault.keySet()) {
                if (mapTableSociete.containsKey(tableName)) continue;
                System.err.println("!! **** La table " + tableName + " n'est pas dans la base " + baseDefault);
            }
            SQLSchema schem = instance.getBase().getSchema("Common");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static String getAlterTable(Map<String, SQLField> m, String baseName, String tableName) {
        StringBuffer buf = new StringBuffer();
        for (String s : m.keySet()) {
            SQLField field = m.get(s);
            buf.append("ALTER TABLE \"" + baseName + "\".\"" + tableName + "\" ADD COLUMN ");
            buf.append("\"" + field.getName() + "\" ");
            buf.append(ActionDB.getType(field));
            buf.append(";\n");
        }
        return buf.toString();
    }

    private static String getType(SQLField field) {
        String columnName = field.getName();
        String columnType = field.getType().getTypeName();
        StringBuffer result = new StringBuffer();
        String nullString = "NULL";
        DBStructureItemDB db = field.getDB();
        Object defaultValueO = field.getDefaultValue();
        String defaultValue = defaultValueO == null ? null : defaultValueO.toString();
        String defaultValueString = "";
        if (defaultValue != null) {
            defaultValueString = " default " + defaultValue;
        }
        int columnSize = field.getType().getSize();
        Integer decimalDigit = (Integer)field.getMetadata("DECIMAL_DIGITS");
        String stringColumnSize = "";
        if (Integer.valueOf(columnSize) > 0) {
            stringColumnSize = " (" + columnSize;
            if (decimalDigit != null && Integer.valueOf(decimalDigit) > 0) {
                stringColumnSize = String.valueOf(stringColumnSize) + ", " + decimalDigit;
            }
            stringColumnSize = String.valueOf(stringColumnSize) + ")";
        }
        if ((columnType.trim().equalsIgnoreCase("character varying") || columnType.trim().equalsIgnoreCase("varchar") || columnType.trim().equalsIgnoreCase("numeric")) && stringColumnSize.length() > 0) {
            result.append(" " + columnType + stringColumnSize + " ");
            result.append(defaultValueString);
        } else {
            result.append(" " + columnType + " ");
            result.append(defaultValueString);
        }
        return result.toString();
    }

    private static void compareTypeField(Map fieldsDefault, Map fields) {
        for (Object o : fieldsDefault.keySet()) {
            SQLField field = (SQLField)fieldsDefault.get(o);
            SQLField fieldDefault = (SQLField)fields.get(o);
            if (field == null || fieldDefault == null || field.getType() == fieldDefault.getType()) continue;
            System.err.println("---------> Type different Table " + field.getTable() + " -- Field " + field.getName());
        }
    }

    private static void updateMultiBase() {
        System.err.println("Start");
        ComptaPropsConfiguration instance = ComptaPropsConfiguration.create();
        Configuration.setInstance(instance);
        SQLBase base = Configuration.getInstance().getBase();
        SQLTable tableBase = base.getTable("SOCIETE_COMMON");
        SQLSelect sel = new SQLSelect(base, false);
        sel.addSelect(tableBase.getField("DATABASE_NAME"));
        List listBasesNX = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
        ActionDB.reOrderCompteID("Default");
        System.err.println("End");
    }

    private static void updateSaisieVC(String databaseName) {
        System.err.println("Update " + databaseName);
        String select = "SELECT MONTANT_TTC, TAUX, ID FROM \"" + databaseName + "\".SAISIE_VENTE_COMPTOIR, \"" + databaseName + "\".TAXE";
        System.err.println("Request " + select);
        List listBaseNX = (List)Configuration.getInstance().getBase().getDataSource().execute(select, new ArrayListHandler());
        int i = 0;
        while (i < listBaseNX.size()) {
            Object[] tmp = (Object[])listBaseNX.get(i);
            PrixTTC p = new PrixTTC(Long.parseLong(tmp[0].toString()));
            long ht = p.calculLongHT(((Float)tmp[1]).doubleValue() / 100.0);
            String updateVC = "UPDATE \"" + databaseName + "\".SAISIE_VENTE_COMPTOIR SET MONTANT_HT = " + ht + " WHERE ID=" + tmp[2];
            Configuration.getInstance().getBase().execute(updateVC);
            ++i;
        }
    }

    public static void setOrdreComptePCE(String databaseName) {
        String select = "SELECT ID, ORDRE FROM \"" + databaseName + "\".COMPTE_PCE ORDER BY NUMERO";
        List listBaseNX = (List)Configuration.getInstance().getBase().getDataSource().execute(select, new ArrayListHandler());
        int i = 0;
        while (i < listBaseNX.size()) {
            Object[] tmp = (Object[])listBaseNX.get(i);
            String update = "UPDATE \"" + databaseName + "\".COMPTE_PCE SET ORDRE=" + (i + 1) + " WHERE ID=" + tmp[0];
            Configuration.getInstance().getBase().execute(update);
            ++i;
        }
    }

    public static void reOrderCompteID(String databaseName) {
        String update;
        int id;
        Object[] tmp;
        String select = "SELECT ID, ORDRE FROM \"" + databaseName + "\".COMPTE_PCE WHERE ID > 1 ORDER BY NUMERO";
        List listBaseNX = (List)Configuration.getInstance().getBase().getDataSource().execute(select, new ArrayListHandler());
        int i = 0;
        while (i < listBaseNX.size()) {
            tmp = (Object[])listBaseNX.get(i);
            id = Integer.valueOf(tmp[0].toString());
            update = "UPDATE \"" + databaseName + "\".COMPTE_PCE SET ID=" + (id + 1000) + " WHERE ID=" + id;
            Configuration.getInstance().getBase().execute(update);
            ++i;
        }
        select = "SELECT ID, ORDRE FROM \"" + databaseName + "\".COMPTE_PCE WHERE ID > 1 ORDER BY NUMERO";
        listBaseNX = (List)Configuration.getInstance().getBase().getDataSource().execute(select, new ArrayListHandler());
        i = 0;
        while (i < listBaseNX.size()) {
            tmp = (Object[])listBaseNX.get(i);
            id = Integer.valueOf(tmp[0].toString());
            update = "UPDATE \"" + databaseName + "\".COMPTE_PCE SET ID=" + (i + 2) + " WHERE ID=" + id;
            Configuration.getInstance().getBase().execute(update);
            ++i;
        }
    }

    public static void setOrder(SQLBase base) {
        Set<String> tableNames = base.getTableNames();
        for (String tableName : tableNames) {
            SQLTable table = base.getTable(tableName);
            SQLField field = table.getOrderField();
            if (field == null) continue;
            base.execute("ALTER TABLE \"" + tableName + "\" ALTER COLUMN \"" + field.getName() + "\" SET DEFAULT 0;");
            base.execute("ALTER TABLE \"" + tableName + "\" ALTER COLUMN \"" + field.getName() + "\" SET NOT NULL;");
        }
    }

    public static void correct(SQLBase base) {
        Set<String> tableNames = base.getTableNames();
        for (String tableName : tableNames) {
            if (!base.getTable(tableName).contains("ORDRE")) continue;
            SQLSelect select = new SQLSelect(base);
            select.addSelect("ORDRE");
            List l = base.getDataSource().execute(select.asString());
            if (l != null && l.size() != 0) continue;
            SQLRowValues rowVals = new SQLRowValues(base.getTable(tableName));
            rowVals.put("ORDRE", 0);
            try {
                rowVals.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addUndefined(SQLBase base) {
        Set<String> tableNames = base.getTableNames();
        for (String tableName : tableNames) {
            SQLTable table = base.getTable(tableName);
            SQLField fieldPrimaryKey = table.getKey();
            if (fieldPrimaryKey == null || fieldPrimaryKey.getType().getJavaType().getSuperclass() == null || fieldPrimaryKey.getType().getJavaType().getSuperclass() != Number.class) continue;
            String patch = "INSERT INTO \"" + tableName + "\"(\"" + fieldPrimaryKey.getName() + "\") VALUES (1)";
            base.execute(patch);
        }
    }

    public static void fixUserCommon(int base) {
        if (Configuration.getInstance() == null) {
            Configuration.setInstance(ComptaPropsConfiguration.create());
        }
        Configuration instance = Configuration.getInstance();
        SQLTable tableSociete = Configuration.getInstance().getBase().getTable("SOCIETE_COMMON");
        String baseName = tableSociete.getRow(base).getString("DATABASE_NAME");
        instance.getBase().getDBSystemRoot().getRootsToMap().clear();
        try {
            HashSet<String> s = new HashSet<String>();
            s.add(baseName);
            instance.getBase().fetchTables(s);
        }
        catch (SQLException e) {
            throw new IllegalStateException("could not access societe base", e);
        }
        System.err.println("baseName" + baseName);
        instance.getSystemRoot().prependToRootPath("Common");
        instance.getSystemRoot().prependToRootPath(baseName);
        SQLSchema baseSQL = instance.getBase().getSchema(baseName);
        try {
            DatabaseMetaData dbMetaDataSociete = baseSQL.getBase().getDataSource().getConnection().getMetaData();
            String[] type = new String[]{"TABLE"};
            ResultSet rs = dbMetaDataSociete.getTables("", baseSQL.getName(), "%", null);
            System.err.println("Start " + rs.getFetchSize());
            boolean i = false;
            while (rs.next()) {
                if (rs.getString("TABLE_TYPE") == null || !rs.getString("TABLE_TYPE").equalsIgnoreCase("TABLE")) continue;
                SQLTable table = baseSQL.getTable(rs.getString("TABLE_NAME"));
                Set<SQLField> s = table.getFields();
                for (SQLField field : s) {
                    Object o;
                    if (!field.getName().equalsIgnoreCase("ID_USER_COMMON_CREATE") && !field.getName().equalsIgnoreCase("ID_USER_COMMON_MODIFY") || (o = field.getDefaultValue()) != null && (!(o instanceof Integer) || (Integer)o != 0)) continue;
                    System.err.println("Bad default on " + field);
                    baseSQL.getBase().execute("ALTER TABLE \"" + field.getTable().getSchema().getName() + "\".\"" + field.getTable().getName() + "\" ALTER COLUMN \"" + field.getName() + "\" SET DEFAULT 1;");
                    baseSQL.getBase().execute("UPDATE \"" + field.getTable().getSchema().getName() + "\".\"" + field.getTable().getName() + "\" SET \"" + field.getName() + "\"=1 WHERE \"" + field.getName() + "\"=0 OR \"" + field.getName() + "\" IS NULL;");
                }
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ActionDB.fixUserCommon(41);
    }
}

