/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.openconcerto.erp.modules.RuntimeModuleFactory;
import org.openconcerto.utils.StreamUtils;

public class ModulePackager {
    public static final String MODULE_PROPERTIES_PATH = "META-INF/openConcertoModule.properties";
    private final List<File> classesDirs;
    private final List<File> jars = new ArrayList<File>();
    private final File propsFile;
    private final Set<String> dirEntries;
    private final Set<String> fileEntries;
    private boolean skipDuplicateFiles;

    public ModulePackager(File propsFile, File classes) {
        this.propsFile = propsFile;
        this.classesDirs = new ArrayList<File>(8);
        this.classesDirs.add(classes);
        this.dirEntries = new HashSet<String>();
        this.fileEntries = new HashSet<String>();
        this.setSkipDuplicateFiles(false);
    }

    public final void setSkipDuplicateFiles(boolean skipDuplicateFiles) {
        this.skipDuplicateFiles = skipDuplicateFiles;
    }

    public final boolean getSkipDuplicateFiles() {
        return this.skipDuplicateFiles;
    }

    public final void addDir(File classesDir) {
        this.classesDirs.add(classesDir);
    }

    public final void addJarsFromDir(File dir) {
        File[] jarFiles;
        if (!dir.exists()) {
            throw new IllegalArgumentException("Directory " + dir.getAbsolutePath() + " not found");
        }
        File[] fileArray = jarFiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile() && f.getName().endsWith(".jar");
            }
        });
        int n = jarFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File jarFile = fileArray[n2];
            this.addJarUnsafe(jarFile);
            ++n2;
        }
    }

    public final void addJar(File jarFile) {
        if (!jarFile.isFile()) {
            throw new IllegalArgumentException("File " + jarFile.getAbsolutePath() + " not found");
        }
        if (!jarFile.getName().endsWith(".jar")) {
            throw new IllegalArgumentException("File " + jarFile.getAbsolutePath() + " is not a jar file");
        }
        this.addJarUnsafe(jarFile);
    }

    private final void addJarUnsafe(File jarFile) {
        this.jars.add(jarFile);
    }

    public final File writeToDir(File dir) throws IOException {
        RuntimeModuleFactory f = new RuntimeModuleFactory(this.propsFile);
        File jarFile = new File(dir, String.valueOf(f.getID()) + "-" + f.getMajorVersion() + "." + f.getMinorVersion() + ".jar");
        JarOutputStream jarStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(jarFile)));
        this.dirEntries.clear();
        this.fileEntries.clear();
        try {
            if (!this.zipExistingFile(jarStream, this.propsFile, MODULE_PROPERTIES_PATH)) {
                throw new IllegalStateException("Missing properties file : " + this.propsFile);
            }
            for (File jarFileToAdd : this.jars) {
                this.zipJarFile(jarStream, jarFileToAdd);
            }
            for (File classesDir : this.classesDirs) {
                this.zipBelow(jarStream, classesDir);
            }
        }
        finally {
            jarStream.close();
            this.dirEntries.clear();
            this.fileEntries.clear();
        }
        return jarFile;
    }

    protected void zipBelow(JarOutputStream jarStream, File f) throws IOException {
        this.zipRec(jarStream, f, "");
    }

    private String getPath(File f) throws IOException {
        String res = f.getAbsolutePath();
        if (f.isDirectory() && !res.endsWith("/")) {
            res = String.valueOf(res) + '/';
        }
        return res;
    }

    private String getEntryName(File f, File base) throws IOException {
        String basePath;
        if (!base.isDirectory()) {
            throw new IllegalArgumentException("Base not a directory : " + base);
        }
        String fPath = this.getPath(f);
        if (!fPath.startsWith(basePath = this.getPath(base))) {
            throw new IllegalArgumentException("Base is not a parent :\n" + base + "\n" + f);
        }
        return fPath.substring(basePath.length()).replace('\\', '/');
    }

    protected void zipRec(JarOutputStream jarStream, File f, File base) throws IOException {
        this.zipRec(jarStream, f, this.getEntryName(f, base));
    }

    protected void zipRec(JarOutputStream jarStream, File f, String entryName) throws IOException {
        if (entryName.length() > 0) {
            this.zipExistingFile(jarStream, f, entryName);
        }
        if (f.isDirectory()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.zipRec(jarStream, child, String.valueOf(entryName) + '/' + child.getName());
                ++n2;
            }
        }
    }

    protected boolean zipExistingFile(JarOutputStream jarStream, File f, File base) throws IOException {
        return this.zipExistingFile(jarStream, f, this.getEntryName(f, base));
    }

    protected boolean zipExistingFile(JarOutputStream jarStream, File f, String entryName) throws IOException {
        if (!f.exists()) {
            return false;
        }
        boolean isDir = f.isDirectory();
        String name = entryName;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (isDir && !name.endsWith("/")) {
            name = String.valueOf(name) + "/";
        }
        JarEntry entry = new JarEntry(name);
        entry.setTime(f.lastModified());
        if (!isDir) {
            entry.setSize(f.length());
        }
        BufferedInputStream in = isDir ? null : new BufferedInputStream(new FileInputStream(f));
        try {
            this.zip(jarStream, entry, in);
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
        return true;
    }

    private void zip(JarOutputStream jarStream, JarEntry entry, InputStream in) throws IOException {
        boolean isDir = entry.isDirectory();
        if (isDir && !this.dirEntries.add(entry.getName())) {
            return;
        }
        if (!isDir && this.getSkipDuplicateFiles() && !this.fileEntries.add(entry.getName())) {
            return;
        }
        jarStream.putNextEntry(entry);
        if (in != null) {
            StreamUtils.copy(in, jarStream);
        }
        jarStream.closeEntry();
    }

    private void zipJarFile(JarOutputStream out, File file) throws IOException {
        JarFile f = new JarFile(file, false, 1);
        try {
            Enumeration<JarEntry> entries = f.entries();
            while (entries.hasMoreElements()) {
                JarEntry e = entries.nextElement();
                if (e.getName().startsWith("META-INF")) continue;
                this.zip(out, new JarEntry(e), f.getInputStream(e));
            }
        }
        finally {
            f.close();
        }
    }
}

