/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.ComponentsContext;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.erp.modules.JarModuleFactory;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleVersion;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBFileCache;
import org.openconcerto.sql.model.DBItemFileCache;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.DirectedEdge;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.DropTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IdentityHashSet;

public class ModuleManager {
    private static final Logger L = Logger.getLogger(ModuleManager.class.getPackage().getName());
    private static final int MIN_VERSION = 0;
    private static final String MODULE_COLNAME = "MODULE_NAME";
    private static final String MODULE_VERSION_COLNAME = "MODULE_VERSION";
    private static final String TABLE_COLNAME = "TABLE";
    private static final String FIELD_COLNAME = "FIELD";
    private static final String ISKEY_COLNAME = "KEY";
    private static final String FWK_MODULE_TABLENAME = "FWK_MODULE_METADATA";
    private static ModuleManager instance = null;
    private final Map<String, ModuleFactory> factories = new HashMap<String, ModuleFactory>();
    private final Map<String, AbstractModule> runningModules = new HashMap<String, AbstractModule>();
    private final Map<String, Collection<SQLElement>> modulesElements;
    private final Map<String, ComponentsContext> modulesComponents;
    private final DirectedGraph<ModuleFactory, DirectedEdge<ModuleFactory>> dependencyGraph = new SimpleDirectedGraph<ModuleFactory, DirectedEdge<ModuleFactory>>(new EdgeFactory<ModuleFactory, DirectedEdge<ModuleFactory>>(){

        @Override
        public DirectedEdge<ModuleFactory> createEdge(ModuleFactory sourceVertex, ModuleFactory targetVertex) {
            return new DirectedEdge<ModuleFactory>(sourceVertex, targetVertex);
        }
    });
    private DBRoot root = null;
    private Configuration conf = null;

    public static synchronized ModuleManager getInstance() {
        if (instance == null) {
            instance = new ModuleManager();
        }
        return instance;
    }

    private static String getMDVariant(ModuleFactory f) {
        return f.getID();
    }

    public ModuleManager() {
        this.modulesElements = new HashMap<String, Collection<SQLElement>>();
        this.modulesComponents = new HashMap<String, ComponentsContext>();
    }

    public final int addFactories(File dir) {
        if (!dir.exists()) {
            L.warning("Module factory directory not found: " + dir.getAbsolutePath());
            return 0;
        }
        File[] jars = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".jar");
            }
        });
        int i = 0;
        if (jars != null) {
            File[] fileArray = jars;
            int n = jars.length;
            int n2 = 0;
            while (n2 < n) {
                File jar = fileArray[n2];
                try {
                    this.addFactory(new JarModuleFactory(jar));
                    ++i;
                }
                catch (Exception e) {
                    L.warning("Couldn't add " + jar);
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        return i;
    }

    public final ModuleFactory addFactoryFromPackage(File jar) throws IOException {
        JarModuleFactory f = new JarModuleFactory(jar);
        this.addFactory(f);
        return f;
    }

    public final String addFactory(ModuleFactory f) {
        return this.addFactory(f, false, false);
    }

    public final String addFactoryAndStart(ModuleFactory f, boolean persistent) {
        return this.addFactory(f, true, persistent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String addFactory(final ModuleFactory f, boolean start, final boolean persistent) {
        Map<String, ModuleFactory> map = this.factories;
        synchronized (map) {
            ModuleFactory prev = this.factories.put(f.getID(), f);
            if (prev != null) {
                L.info("Changing the factory for " + f.getID() + "\nfrom\t" + prev + "\nto\t" + f);
            }
        }
        if (start) {
            this.invoke(new IClosure<ModuleManager>(){

                @Override
                public void executeChecked(ModuleManager input) {
                    try {
                        ModuleManager.this.startModule(f.getID(), persistent);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle(MainFrame.getInstance(), "Unable to start " + f, e);
                    }
                }
            });
        }
        return f.getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, ModuleFactory> getFactories() {
        Map<String, ModuleFactory> map = this.factories;
        synchronized (map) {
            return new HashMap<String, ModuleFactory>(this.factories);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleFactory getFactory(String id) {
        ModuleFactory res;
        Map<String, ModuleFactory> map = this.factories;
        synchronized (map) {
            res = this.factories.get(id);
        }
        if (res == null) {
            throw new IllegalArgumentException("No factory for " + id);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeFactory(String id) {
        Map<String, ModuleFactory> map = this.factories;
        synchronized (map) {
            this.factories.remove(id);
        }
    }

    public final boolean canFactoryCreate(ModuleFactory factory) {
        return this.canFactoryCreate(factory, new LinkedHashMap<ModuleFactory, Boolean>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean canFactoryCreate(ModuleFactory factory, LinkedHashMap<ModuleFactory, Boolean> beenThere) {
        block6: {
            if (beenThere.get(factory) == Boolean.TRUE) {
                return true;
            }
            if (beenThere.get(factory) == Boolean.FALSE) {
                throw new IllegalStateException("Cycle detected : " + beenThere);
            }
            beenThere.put(factory, Boolean.FALSE);
            Map<String, ModuleFactory> map = this.factories;
            synchronized (map) {
                String requiredID;
                ModuleFactory f;
                Iterator<String> iterator = factory.getRequiredIDs().iterator();
                do {
                    if (iterator.hasNext()) continue;
                    break block6;
                } while ((f = this.factories.get(requiredID = iterator.next())) != null && factory.isRequiredFactoryOK(f) && this.canFactoryCreate(f, beenThere));
                return false;
            }
        }
        beenThere.remove(factory);
        beenThere.put(factory, Boolean.TRUE);
        return true;
    }

    public void invoke(final IClosure<ModuleManager> c) {
        MainFrame.invoke(new Runnable(){

            @Override
            public void run() {
                c.executeChecked(ModuleManager.this);
            }
        });
    }

    private void registerRequiredModules() throws Exception {
        ArrayList<String> modulesToStart = new ArrayList<String>();
        try {
            Map<String, ModuleFactory> factories = this.getFactories();
            for (Map.Entry<String, ModuleVersion> e : this.getDBInstalledModules().entrySet()) {
                String moduleID = e.getKey();
                if (!this.areElementsNeeded(moduleID)) continue;
                ModuleFactory moduleFactory = factories.get(moduleID);
                String error = moduleFactory == null ? "Module '" + moduleID + "' non disponible." : (!moduleFactory.getVersion().equals(e.getValue()) ? "Mauvaise version pour '" + moduleID + "'. La version " + moduleFactory.getVersion() + " est disponible mais " + e.getValue() + " est requise." : null);
                if (error != null) {
                    throw new Exception(error);
                }
                modulesToStart.add(moduleID);
            }
        }
        catch (Exception e) {
            throw new Exception("Impossible de d\u00e9terminer les modules requis", e);
        }
        Tuple2<Map<String, AbstractModule>, Set<String>> modules = this.createModules(modulesToStart, false, true);
        if (modules.get1().size() > 0) {
            throw new Exception("Impossible de cr\u00e9er les modules " + modules.get1());
        }
        for (AbstractModule m : modules.get0().values()) {
            this.registerSQLElements(m);
        }
    }

    public final synchronized void setup(DBRoot root, Configuration conf) throws Exception {
        if (root == null || conf == null) {
            throw new NullPointerException();
        }
        if (this.root != null || this.getConf() != null) {
            throw new IllegalStateException("Already setup");
        }
        assert (this.runningModules.isEmpty() && this.modulesComponents.isEmpty()) : "Modules cannot start without root & conf";
        this.root = root;
        this.conf = conf;
        try {
            this.registerRequiredModules();
        }
        catch (Exception e) {
            this.root = null;
            this.conf = null;
            throw e;
        }
        assert (this.runningModules.isEmpty() && this.modulesComponents.isEmpty()) : "registerRequiredModules() should not start modules";
    }

    private Preferences getPrefs() {
        StringBuilder path = new StringBuilder(32);
        for (String item : DBFileCache.getJDBCAncestorNames(this.getRoot(), true)) {
            path.append(StringUtils.getBoundedLengthString(DBItemFileCache.encode(item), 80));
            path.append('/');
        }
        path.setLength(path.length() - 1);
        return Preferences.userNodeForPackage(ModuleManager.class).node(path.toString());
    }

    private Preferences getRunningIDsPrefs() {
        return this.getPrefs().node("toRun");
    }

    protected final Preferences getRequiredIDsPrefs() {
        return new SQLPreferences(this.getRoot()).node("modules/required");
    }

    protected final boolean isModuleInstalledLocally(String id) {
        return this.getLocalVersionFile(id).exists();
    }

    protected final ModuleVersion getModuleVersionInstalledLocally(String id) {
        File versionFile = this.getLocalVersionFile(id);
        if (versionFile.exists()) {
            try {
                return new ModuleVersion(Long.valueOf(FileUtils.read(versionFile)));
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't get installed version of " + id, e);
            }
        }
        return null;
    }

    public final Collection<String> getModulesInstalledLocally() {
        return this.getModulesVersionInstalledLocally().keySet();
    }

    public final Map<String, ModuleVersion> getModulesVersionInstalledLocally() {
        File dir = this.getLocalDirectory();
        if (!dir.isDirectory()) {
            return Collections.emptyMap();
        }
        HashMap<String, ModuleVersion> res = new HashMap<String, ModuleVersion>();
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File d = fileArray[n2];
            String id = d.getName();
            ModuleVersion version = this.getModuleVersionInstalledLocally(id);
            if (version != null) {
                res.put(id, version);
            }
            ++n2;
        }
        return res;
    }

    private void setModuleInstalledLocally(ModuleFactory f, boolean b) {
        try {
            if (b) {
                ModuleVersion vers = f.getVersion();
                if (vers.getMerged() < 0L) {
                    throw new IllegalStateException("Invalid version : " + vers);
                }
                File versionFile = this.getLocalVersionFile(f.getID());
                FileUtils.mkdir_p(versionFile.getParentFile());
                FileUtils.write(String.valueOf(vers.getMerged()), versionFile);
            } else {
                FileUtils.rm_R(this.getLocalDirectory(f.getID()));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't change installed status of " + f, e);
        }
    }

    private SQLTable getInstalledTable(DBRoot r) throws SQLException {
        if (!r.contains(FWK_MODULE_TABLENAME)) {
            SQLCreateTable createTable = new SQLCreateTable(r, FWK_MODULE_TABLENAME);
            createTable.setPlain(true);
            createTable.addColumn("ID", createTable.getSyntax().getPrimaryIDDefinition());
            createTable.addVarCharColumn(MODULE_COLNAME, 128);
            createTable.addColumn(TABLE_COLNAME, "varchar(128) NULL");
            createTable.addColumn(FIELD_COLNAME, "varchar(128) NULL");
            createTable.addColumn(ISKEY_COLNAME, "boolean NULL");
            createTable.addColumn(MODULE_VERSION_COLNAME, "bigint NOT NULL");
            createTable.addUniqueConstraint("uniqModule", Arrays.asList(MODULE_COLNAME, TABLE_COLNAME, FIELD_COLNAME));
            r.createTable(createTable);
        }
        return r.getTable(FWK_MODULE_TABLENAME);
    }

    protected final DBRoot getRoot() {
        return this.root;
    }

    private SQLDataSource getDS() {
        return this.getRoot().getDBSystemRoot().getDataSource();
    }

    protected final Configuration getConf() {
        return this.conf;
    }

    private SQLElementDirectory getDirectory() {
        return this.getConf().getDirectory();
    }

    private final File getLocalDirectory() {
        return new File(this.getConf().getConfDir(this.getRoot()), "modules");
    }

    protected final File getLocalDirectory(String id) {
        return new File(this.getLocalDirectory(), id);
    }

    private final File getLocalVersionFile(String id) {
        return new File(this.getLocalDirectory(id), "version");
    }

    public final ModuleVersion getDBInstalledModuleVersion(String id) throws SQLException {
        return this.getDBInstalledModules(id).get(id);
    }

    public final Map<String, ModuleVersion> getDBInstalledModules() throws SQLException {
        return this.getDBInstalledModules(null);
    }

    private final Map<String, ModuleVersion> getDBInstalledModules(String id) throws SQLException {
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        SQLSelect sel = new SQLSelect(installedTable.getBase()).addSelectStar(installedTable);
        sel.setWhere(Where.isNull(installedTable.getField(TABLE_COLNAME)).and(Where.isNull(installedTable.getField(FIELD_COLNAME))));
        if (id != null) {
            sel.andWhere(new Where((FieldRef)installedTable.getField(MODULE_COLNAME), "=", (Object)id));
        }
        HashMap<String, ModuleVersion> res = new HashMap<String, ModuleVersion>();
        for (SQLRow r : SQLRowListRSH.execute(sel)) {
            res.put(r.getString(MODULE_COLNAME), new ModuleVersion(r.getLong(MODULE_VERSION_COLNAME)));
        }
        return res;
    }

    private void setDBInstalledModule(ModuleFactory f, boolean b) throws SQLException {
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        Where idW = new Where((FieldRef)installedTable.getField(MODULE_COLNAME), "=", (Object)f.getID());
        Where noItemsW = Where.isNull(installedTable.getField(TABLE_COLNAME)).and(Where.isNull(installedTable.getField(FIELD_COLNAME)));
        Where w = idW.and(noItemsW);
        if (b) {
            SQLSelect sel = new SQLSelect(installedTable.getBase());
            sel.addSelect(installedTable.getKey());
            sel.setWhere(w);
            Number id = (Number)installedTable.getDBSystemRoot().getDataSource().executeScalar(sel.asString());
            SQLRowValues vals = new SQLRowValues(installedTable);
            vals.put(MODULE_VERSION_COLNAME, f.getVersion().getMerged());
            if (id != null) {
                vals.setID(id);
                vals.update();
            } else {
                vals.put(MODULE_COLNAME, f.getID());
                vals.put(TABLE_COLNAME, null);
                vals.put(FIELD_COLNAME, null);
                vals.insert();
            }
        } else {
            installedTable.getDBSystemRoot().getDataSource().execute("DELETE FROM " + installedTable.getSQLName().quote() + " WHERE " + w.getClause());
        }
    }

    protected final boolean isModuleInstalledLocallyOrInDB(String id) throws SQLException {
        return this.isModuleInstalledLocally(id) || this.getDBInstalledModuleVersion(id) != null;
    }

    public final Tuple2<Set<String>, Set<SQLName>> getCreatedItems(String id) throws SQLException {
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        SQLSelect sel = new SQLSelect(installedTable.getBase());
        sel.addSelect(installedTable.getKey());
        sel.addSelect(installedTable.getField(TABLE_COLNAME));
        sel.addSelect(installedTable.getField(FIELD_COLNAME));
        sel.setWhere(new Where((FieldRef)installedTable.getField(MODULE_COLNAME), "=", (Object)id).and(Where.isNotNull(installedTable.getField(TABLE_COLNAME))));
        HashSet<String> tables = new HashSet<String>();
        HashSet<SQLName> fields = new HashSet<SQLName>();
        for (SQLRow r : SQLRowListRSH.execute(sel)) {
            String tableName = r.getString(TABLE_COLNAME);
            String fieldName = r.getString(FIELD_COLNAME);
            if (fieldName == null) {
                tables.add(tableName);
                continue;
            }
            fields.add(new SQLName(tableName, fieldName));
        }
        return Tuple2.create(tables, fields);
    }

    private void updateModuleFields(ModuleFactory factory, DBContext ctxt) throws SQLException {
        SQLTable t;
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        Where idW = new Where((FieldRef)installedTable.getField(MODULE_COLNAME), "=", (Object)factory.getID());
        ArrayList<Where> dropWheres = new ArrayList<Where>();
        for (String string : ctxt.getRemovedTables()) {
            dropWheres.add(new Where((FieldRef)installedTable.getField(TABLE_COLNAME), "=", (Object)string));
        }
        for (SQLName sQLName : ctxt.getRemovedFieldsFromExistingTables()) {
            dropWheres.add(new Where((FieldRef)installedTable.getField(TABLE_COLNAME), "=", (Object)sQLName.getItem(0)).and(new Where((FieldRef)installedTable.getField(FIELD_COLNAME), "=", (Object)sQLName.getItem(1))));
        }
        if (dropWheres.size() > 0) {
            installedTable.getDBSystemRoot().getDataSource().execute("DELETE FROM " + installedTable.getSQLName().quote() + " WHERE " + Where.or(dropWheres).and(idW).getClause());
        }
        SQLRowValues vals = new SQLRowValues(installedTable);
        vals.put(MODULE_VERSION_COLNAME, factory.getVersion().getMerged());
        vals.put(MODULE_COLNAME, factory.getID());
        for (String string : ctxt.getAddedTables()) {
            vals.put(TABLE_COLNAME, string).put(FIELD_COLNAME, null).insert();
            t = ctxt.getRoot().findTable(string);
            for (SQLField field : t.getFields()) {
                vals.put(TABLE_COLNAME, string).put(FIELD_COLNAME, field.getName()).put(ISKEY_COLNAME, field.isKey()).insert();
            }
            vals.remove(ISKEY_COLNAME);
        }
        for (SQLName sQLName : ctxt.getAddedFieldsToExistingTables()) {
            SQLField field;
            t = ctxt.getRoot().findTable(sQLName.getItem(0));
            field = t.getField(sQLName.getItem(1));
            vals.put(TABLE_COLNAME, t.getName()).put(FIELD_COLNAME, field.getName()).put(ISKEY_COLNAME, field.isKey()).insert();
        }
        vals.remove(ISKEY_COLNAME);
        this.setDBInstalledModule(factory, true);
    }

    private void removeModuleFields(ModuleFactory f) throws SQLException {
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        Where idW = new Where((FieldRef)installedTable.getField(MODULE_COLNAME), "=", (Object)f.getID());
        installedTable.getDBSystemRoot().getDataSource().execute("DELETE FROM " + installedTable.getSQLName().quote() + " WHERE " + Where.isNotNull(installedTable.getField(TABLE_COLNAME)).and(idW).getClause());
        this.setDBInstalledModule(f, false);
    }

    private final boolean areElementsNeeded(String id) throws SQLException {
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        SQLSelect sel = new SQLSelect(installedTable.getBase());
        sel.addRawSelect("COUNT(*) > 0", null);
        Where idW = new Where((FieldRef)installedTable.getField(MODULE_COLNAME), "=", (Object)id);
        Where tableCreated = Where.isNotNull(installedTable.getField(TABLE_COLNAME)).and(Where.isNull(installedTable.getField(FIELD_COLNAME)));
        Where keyCreated = Where.isNotNull(installedTable.getField(FIELD_COLNAME)).and(new Where((FieldRef)installedTable.getField(ISKEY_COLNAME), "=", (Object)Boolean.TRUE));
        sel.setWhere(idW.and(tableCreated.or(keyCreated)));
        return (Boolean)installedTable.getDBSystemRoot().getDataSource().executeScalar(sel.asString());
    }

    private void install(final AbstractModule module) throws Exception {
        final ModuleFactory factory = module.getFactory();
        final ModuleVersion localVersion = this.getModuleVersionInstalledLocally(factory.getID());
        final ModuleVersion lastInstalledVersion = this.getDBInstalledModuleVersion(factory.getID());
        ModuleVersion moduleVersion = module.getFactory().getVersion();
        if (lastInstalledVersion != null && moduleVersion.compareTo(lastInstalledVersion) < 0) {
            throw new IllegalArgumentException("Module older than the one installed in the DB : " + moduleVersion + " < " + lastInstalledVersion);
        }
        if (localVersion != null && moduleVersion.compareTo(localVersion) < 0) {
            throw new IllegalArgumentException("Module older than the one installed locally : " + moduleVersion + " < " + localVersion);
        }
        if (!moduleVersion.equals(localVersion) || !moduleVersion.equals(lastInstalledVersion)) {
            File backupDir;
            final File localDir = this.getLocalDirectory(factory.getID());
            if (localDir.exists()) {
                backupDir = FileUtils.addSuffix(localDir, ".backup");
                FileUtils.rm_R(backupDir);
                FileUtils.copyDirectory(localDir, backupDir);
            } else {
                backupDir = null;
                FileUtils.mkdir_p(localDir);
            }
            assert (localDir.exists());
            try {
                SQLUtils.executeAtomic(this.getDS(), new ConnectionHandlerNoSetup<Object, IOException>(){

                    @Override
                    public Object handle(SQLDataSource ds) throws SQLException, IOException {
                        Tuple2<Set<String>, Set<SQLName>> alreadyCreatedItems = ModuleManager.this.getCreatedItems(factory.getID());
                        DBContext ctxt = new DBContext(localDir, localVersion, ModuleManager.this.getRoot(), lastInstalledVersion, alreadyCreatedItems.get0(), alreadyCreatedItems.get1());
                        module.install(ctxt);
                        if (!localDir.exists()) {
                            throw new IOException("Modules shouldn't remove their directory");
                        }
                        ctxt.execute();
                        ModuleManager.this.updateModuleFields(factory, ctxt);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                File failed;
                if (this.getRoot().getServer().getSQLSystem() == SQLSystem.MYSQL) {
                    L.warning("MySQL cannot rollback DDL statements");
                }
                if ((failed = FileUtils.addSuffix(localDir, ".failed")).exists() && !FileUtils.rmR(failed)) {
                    L.warning("Couldn't remove " + failed);
                }
                if (!localDir.renameTo(failed)) {
                    L.warning("Couldn't move " + localDir + " to " + failed);
                } else {
                    assert (!localDir.exists());
                    if (backupDir != null && !backupDir.renameTo(localDir)) {
                        L.warning("Couldn't restore " + backupDir + " to " + localDir);
                    }
                }
                throw e;
            }
            assert (localDir.exists());
            if (backupDir != null) {
                FileUtils.rm_R(backupDir);
            }
            this.setModuleInstalledLocally(factory, true);
        }
        assert (moduleVersion.equals(this.getModuleVersionInstalledLocally(factory.getID())) && moduleVersion.equals(this.getDBInstalledModuleVersion(factory.getID())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSQLElements(AbstractModule module) {
        String id = module.getFactory().getID();
        Map<String, Collection<SQLElement>> map = this.modulesElements;
        synchronized (map) {
            if (!this.modulesElements.containsKey(id)) {
                SQLElementDirectory dir = this.getDirectory();
                HashMap<SQLTable, SQLElement> beforeElements = new HashMap<SQLTable, SQLElement>(dir.getElementsMap());
                module.setupElements(dir);
                ArrayList<SQLElement> elements = new ArrayList<SQLElement>();
                IdentityHashSet beforeElementsSet = new IdentityHashSet(beforeElements.values());
                for (SQLElement elem : dir.getElements()) {
                    if (beforeElementsSet.contains(elem)) continue;
                    if (beforeElements.containsKey(elem.getTable())) {
                        L.warning("Trying to replace element for " + elem.getTable() + " with " + elem);
                        dir.addSQLElement((SQLElement)beforeElements.get(elem.getTable()));
                        continue;
                    }
                    elements.add(elem);
                }
                this.modulesElements.put(id, elements);
            }
        }
    }

    private void setupComponents(AbstractModule module) throws SQLException {
        String id = module.getFactory().getID();
        if (!this.modulesComponents.containsKey(id)) {
            SQLElementDirectory dir = this.getDirectory();
            Tuple2<Set<String>, Set<SQLName>> alreadyCreatedItems = this.getCreatedItems(id);
            ComponentsContext ctxt = new ComponentsContext(dir, this.getRoot(), alreadyCreatedItems.get0(), alreadyCreatedItems.get1());
            module.setupComponents(ctxt);
            this.modulesComponents.put(id, ctxt);
        }
    }

    public final void startRequiredModules() throws Exception {
        this.startModules(Arrays.asList(this.getRequiredIDsPrefs().keys()));
    }

    public final void startPreviouslyRunningModules() throws Exception {
        List<String> ids = Arrays.asList(this.getRunningIDsPrefs().keys());
        this.startModules(ids);
    }

    public final boolean startModule(String id) throws Exception {
        return this.startModule(id, true);
    }

    public final boolean startModule(String id, boolean persistent) throws Exception {
        Set<String> res = this.startModules(Collections.singleton(id), persistent);
        return res.isEmpty();
    }

    public final Set<String> startModules(Collection<String> ids, boolean persistent) throws Exception {
        Set<String> res = this.startModules(ids);
        if (persistent) {
            for (String id : ids) {
                assert (this.isModuleRunning(id) == !res.contains(id));
                if (res.contains(id)) continue;
                this.getRunningIDsPrefs().put(id, "");
            }
        }
        return res;
    }

    private final Set<String> startModules(Collection<String> ids) throws Exception {
        return this.createModules(ids, true, false).get1();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Tuple2<Map<String, AbstractModule>, Set<String>> createModules(Collection<String> ids, boolean start, boolean inSetup) throws Exception {
        assert (SwingUtilities.isEventDispatchThread() || inSetup && this.runningModules.isEmpty());
        LinkedHashMap<String, AbstractModule> modules = inSetup ? new LinkedHashMap<String, AbstractModule>(ids.size() * 2) : new LinkedHashMap<String, AbstractModule>(this.runningModules);
        HashSet<String> cannotCreate = new HashSet<String>();
        LinkedHashMap<ModuleFactory, Boolean> map = new LinkedHashMap<ModuleFactory, Boolean>();
        Map<String, ModuleFactory> map2 = this.factories;
        synchronized (map2) {
            for (String id : ids) {
                ModuleFactory f = this.getFactory(id);
                if (this.canFactoryCreate(f, map)) {
                    for (ModuleFactory useableFactory : map.keySet()) {
                        if (modules.containsKey(useableFactory.getID())) continue;
                        modules.put(useableFactory.getID(), useableFactory.createModule(Collections.unmodifiableMap(modules)));
                    }
                    continue;
                }
                cannotCreate.add(id);
            }
        }
        if (!inSetup) {
            modules.keySet().removeAll(this.runningModules.keySet());
        }
        if (start) {
            for (AbstractModule module : modules.values()) {
                this.startModule(module);
            }
        }
        modules.keySet().retainAll(ids);
        return Tuple2.create(modules, cannotCreate);
    }

    private final boolean startModule(AbstractModule module) throws Exception {
        ModuleFactory f = module.getFactory();
        String id = f.getID();
        if (this.isModuleRunning(id)) {
            return false;
        }
        try {
            this.install(module);
        }
        catch (Exception e) {
            throw new Exception("Couldn't install module " + module, e);
        }
        try {
            Set<Object> tablesWithMD;
            String mdVariant = ModuleManager.getMDVariant(module.getFactory());
            InputStream labels = module.getClass().getResourceAsStream("labels.xml");
            if (labels != null) {
                try {
                    tablesWithMD = this.getConf().getTranslator().load(this.getRoot(), mdVariant, labels);
                }
                finally {
                    labels.close();
                }
            } else {
                tablesWithMD = Collections.emptySet();
            }
            this.registerSQLElements(module);
            for (SQLTable tableWithDoc : tablesWithMD) {
                this.getDirectory().getElement(tableWithDoc).addToMDPath(mdVariant);
            }
            this.setupComponents(module);
            module.start();
        }
        catch (Exception e) {
            throw new Exception("Couldn't start module " + module, e);
        }
        this.runningModules.put(id, module);
        boolean added = this.dependencyGraph.addVertex(f);
        assert (added) : "Module was already in graph : " + f;
        for (String requiredID : f.getRequiredIDs()) {
            this.dependencyGraph.addEdge(f, this.runningModules.get(requiredID).getFactory());
        }
        return true;
    }

    public final boolean isModuleRunning(String id) {
        assert (SwingUtilities.isEventDispatchThread());
        return this.runningModules.containsKey(id);
    }

    public final Map<String, AbstractModule> getRunningModules() {
        return Collections.unmodifiableMap(this.runningModules);
    }

    public final void stopModuleRecursively(String id) {
        if (!this.isModuleRunning(id)) {
            return;
        }
        ModuleFactory f = this.runningModules.get(id).getFactory();
        for (DirectedEdge<ModuleFactory> e : new ArrayList<DirectedEdge<ModuleFactory>>(this.dependencyGraph.incomingEdgesOf(f))) {
            this.stopModuleRecursively(e.getSource().getID());
        }
        this.stopModule(id);
    }

    public final void stopModule(String id) {
        this.stopModule(id, true);
    }

    public final void stopModule(String id, boolean persistent) {
        assert (SwingUtilities.isEventDispatchThread());
        if (!this.isModuleRunning(id)) {
            return;
        }
        ModuleFactory f = this.runningModules.get(id).getFactory();
        Set<DirectedEdge<ModuleFactory>> deps = this.dependencyGraph.incomingEdgesOf(f);
        if (deps.size() > 0) {
            throw new IllegalArgumentException("Dependents still running : " + deps);
        }
        this.dependencyGraph.removeVertex(f);
        AbstractModule m = this.runningModules.remove(id);
        m.stop();
        this.tearDownComponents(m);
        String mdVariant = ModuleManager.getMDVariant(f);
        for (SQLElement elem : this.getDirectory().getElements()) {
            elem.removeFromMDPath(mdVariant);
        }
        this.getConf().getTranslator().removeDescFor(null, null, mdVariant, null);
        if (persistent) {
            this.getRunningIDsPrefs().remove(m.getFactory().getID());
        }
        assert (!this.isModuleRunning(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterSQLElements(AbstractModule module) {
        String id = module.getFactory().getID();
        Map<String, Collection<SQLElement>> map = this.modulesElements;
        synchronized (map) {
            if (this.modulesElements.containsKey(id)) {
                Collection<SQLElement> elements = this.modulesElements.remove(id);
                SQLElementDirectory dir = this.getDirectory();
                for (SQLElement elem : elements) {
                    dir.removeSQLElement(elem);
                }
            }
        }
    }

    private void tearDownComponents(AbstractModule module) {
        String id = module.getFactory().getID();
        if (this.modulesComponents.containsKey(id)) {
            ComponentsContext ctxt = this.modulesComponents.remove(id);
            for (Map.Entry<SQLElement, Collection<String>> entry : ctxt.getFields().entrySet()) {
                for (String fieldName : entry.getValue()) {
                    entry.getKey().removeAdditionalField(fieldName);
                }
            }
            for (Map.Entry<SQLElement, Collection<Object>> entry : ctxt.getRowActions().entrySet()) {
                entry.getKey().getRowActions().removeAll(entry.getValue());
            }
            for (JMenuItem jMenuItem : ctxt.getMenuItems()) {
                MainFrame.getInstance().removeMenuItem(jMenuItem);
            }
        }
    }

    private final List<String> getDBDependentModules(String id) throws Exception {
        Set<String> tables = this.getCreatedItems(id).get0();
        if (tables.size() == 0) {
            return Collections.emptyList();
        }
        SQLTable installedTable = this.getInstalledTable(this.getRoot());
        SQLSelect sel = new SQLSelect(installedTable.getBase());
        sel.addSelect(installedTable.getField(MODULE_COLNAME));
        sel.setWhere(new Where((FieldRef)installedTable.getField(MODULE_COLNAME), "!=", (Object)id).and(new Where(installedTable.getField(TABLE_COLNAME), tables)));
        List res = installedTable.getDBSystemRoot().getDataSource().executeCol(sel.asString());
        return res;
    }

    private final Collection<String> getDependentModules(String id) throws Exception {
        HashSet<String> depModules = new HashSet<String>(this.getDBDependentModules(id));
        AbstractModule runningModule = this.runningModules.get(id);
        if (runningModule != null) {
            for (DirectedEdge<ModuleFactory> e : new ArrayList<DirectedEdge<ModuleFactory>>(this.dependencyGraph.incomingEdgesOf(runningModule.getFactory()))) {
                depModules.add(e.getSource().getID());
            }
        }
        return depModules;
    }

    public final List<String> getDependentModulesRecursively(String id) throws Exception {
        ArrayList<String> res = new ArrayList<String>();
        for (String depModule : this.getDependentModules(id)) {
            res.add(depModule);
            res.addAll(this.getDependentModulesRecursively(depModule));
        }
        Collections.reverse(res);
        return res;
    }

    private final LinkedHashSet<String> getAllOrderedDependentModulesRecursively(Set<String> ids) throws Exception {
        LinkedHashSet<String> depModules = new LinkedHashSet<String>();
        for (String id : ids) {
            if (depModules.contains(id)) continue;
            depModules.addAll(this.getDependentModulesRecursively(id));
            depModules.add(id);
        }
        return depModules;
    }

    public final Set<String> getDependentModulesRecursively(Set<String> ids) throws Exception {
        LinkedHashSet<String> res = this.getAllOrderedDependentModulesRecursively(ids);
        res.removeAll(ids);
        return res;
    }

    public final Collection<String> uninstall(Set<String> ids, boolean recurse) throws Exception {
        HashSet<String> res;
        if (!recurse) {
            LinkedHashSet<String> depModules = this.getAllOrderedDependentModulesRecursively(ids);
            Collection<String> depModulesNotRequested = CollectionUtils.substract(depModules, ids);
            if (!depModulesNotRequested.isEmpty()) {
                throw new IllegalStateException("Dependent modules not uninstalled : " + depModulesNotRequested);
            }
            Map<String, ModuleVersion> dbVersions = this.getDBInstalledModules();
            for (String id : depModules) {
                this.uninstallUnsafe(id, dbVersions);
            }
            res = depModules;
        } else {
            res = new HashSet<String>();
            for (String id : ids) {
                if (res.contains(id)) continue;
                res.addAll(this.uninstall(id, recurse));
            }
        }
        assert (recurse && res.containsAll(ids) || !recurse && res.equals(ids));
        return res;
    }

    public final void uninstall(String id) throws Exception {
        this.uninstall(id, false);
    }

    public final Collection<String> uninstall(String id, boolean recurse) throws Exception {
        if (!this.isModuleInstalledLocallyOrInDB(id)) {
            return Collections.emptySet();
        }
        HashSet<String> res = new HashSet<String>();
        Collection<String> depModules = this.getDependentModules(id);
        if (depModules.size() > 0) {
            if (recurse) {
                for (String depModule : depModules) {
                    res.addAll(this.uninstall(depModule, recurse));
                }
            } else {
                throw new IllegalStateException("Dependent modules not uninstalled : " + depModules);
            }
        }
        this.uninstallUnsafe(id, null);
        res.add(id);
        return res;
    }

    private void uninstallUnsafe(final String id, Map<String, ModuleVersion> dbVersions) throws SQLException, Exception {
        AbstractModule module;
        if (dbVersions == null) {
            dbVersions = this.getDBInstalledModules();
        }
        ModuleFactory moduleFactory = this.getFactory(id);
        ModuleVersion localVersion = this.getModuleVersionInstalledLocally(id);
        ModuleVersion dbVersion = dbVersions.get(id);
        if (localVersion != null && !moduleFactory.getVersion().equals(localVersion)) {
            throw new IllegalStateException("Local version not equal : " + localVersion);
        }
        if (dbVersion != null && !moduleFactory.getVersion().equals(dbVersion)) {
            throw new IllegalStateException("DB version not equal : " + dbVersion);
        }
        if (!this.isModuleRunning(id)) {
            module = this.createModules(Collections.singleton(id), false, false).get0().get(id);
        } else {
            module = this.runningModules.get(id);
            this.stopModule(id, true);
        }
        SQLUtils.executeAtomic(this.getDS(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                DBRoot root = ModuleManager.this.getRoot();
                module.uninstall(root);
                ModuleManager.this.unregisterSQLElements(module);
                ModuleManager.this.setModuleInstalledLocally(module.getFactory(), false);
                Tuple2<Set<String>, Set<SQLName>> createdItems = ModuleManager.this.getCreatedItems(id);
                ArrayList<ChangeTable> l = new ArrayList<ChangeTable>();
                Set<String> tableNames = createdItems.get0();
                for (SQLName field : createdItems.get1()) {
                    SQLField f = root.getDesc(field, SQLField.class);
                    if (tableNames.contains(f.getTable().getName())) continue;
                    l.add(new AlterTable(f.getTable()).dropColumnCascade(f.getName()));
                }
                for (String table : tableNames) {
                    l.add(new DropTable(root.getTable(table)));
                }
                if (l.size() > 0) {
                    for (String s : ChangeTable.cat(l, root.getName())) {
                        root.getDBSystemRoot().getDataSource().execute(s);
                    }
                    root.getSchema().updateVersion();
                    root.refetch();
                }
                ModuleManager.this.removeModuleFields(module.getFactory());
                return null;
            }
        });
    }
}

