/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.io.File;
import java.io.IOException;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.modules.JarModuleFactory;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModulePackager;
import org.openconcerto.erp.modules.RuntimeModuleFactory;
import org.openconcerto.utils.FileUtils;

public class ModuleLauncher {
    public static final String MODULE_DIR_PROP = "module.dir";
    public static final String MODULE_PROPS_FILE_PROP = "module.propsFile";

    public static void main(String[] args) throws IOException {
        ModuleFactory factory;
        File moduleDir = new File(System.getProperty(MODULE_DIR_PROP));
        File propsFile = new File(moduleDir, System.getProperty(MODULE_PROPS_FILE_PROP, "module.properties"));
        boolean launchFromPackage = !Boolean.getBoolean("module.fromProject");
        File classes = new File(moduleDir, "bin");
        File distDir = new File(moduleDir, "dist");
        FileUtils.mkdir_p(distDir);
        File jar = new ModulePackager(propsFile, classes).writeToDir(distDir);
        FileUtils.mkdir_p(Gestion.MODULES_DIR);
        FileUtils.copyFile(jar, new File(Gestion.MODULES_DIR, jar.getName()));
        if (launchFromPackage) {
            factory = new JarModuleFactory(jar);
        } else {
            factory = new RuntimeModuleFactory(propsFile);
            try {
                Class.forName(factory.getMainClass());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Module classes are not in the classpath (they should be in " + classes + ")", e);
            }
        }
        Gestion.main(args);
        ModuleManager.getInstance().addFactoryAndStart(factory, false);
    }
}

