/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModuleTableModel;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.IFactory;

public class InstalledModuleTableModel
extends ModuleTableModel {
    private static final int STATE_INDEX = 3;
    private static final int REQUIRED_INDEX = 4;
    private static final int LAST_INDEX = 4;
    private final Preferences prefs = ModuleManager.getInstance().getRequiredIDsPrefs();
    private Set<String> requiredIDs = null;
    private final PreferenceChangeListener pcl = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            Set ids = InstalledModuleTableModel.this.requiredIDs;
            if (evt.getNewValue() == null) {
                ids.remove(evt.getKey());
            } else {
                ids.add(evt.getKey());
            }
            InstalledModuleTableModel.this.fireTableChanged(new TableModelEvent(InstalledModuleTableModel.this, 0, InstalledModuleTableModel.this.getRowCount() - 1, 4));
            if (!$assertionsDisabled && !InstalledModuleTableModel.this.fetchRequiredIDs().equals(ids)) {
                throw new AssertionError();
            }
        }
    };

    public InstalledModuleTableModel(IFactory<? extends Collection<ModuleFactory>> rowSource) {
        super(rowSource);
    }

    protected final Preferences getPrefs() {
        return this.prefs;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        boolean hadListeners = this.hasListeners();
        super.addTableModelListener(l);
        if (!hadListeners && this.hasListeners()) {
            this.getPrefs().addPreferenceChangeListener(this.pcl);
        }
    }

    private final boolean hasListeners() {
        return this.listenerList.getListenerCount() > 0;
    }

    @Override
    public synchronized void removeTableModelListener(TableModelListener l) {
        boolean hadListeners = this.hasListeners();
        super.removeTableModelListener(l);
        if (hadListeners && !this.hasListeners()) {
            this.getPrefs().removePreferenceChangeListener(this.pcl);
        }
    }

    private Set<String> fetchRequiredIDs() {
        try {
            return new HashSet<String>(Arrays.asList(this.getPrefs().keys()));
        }
        catch (BackingStoreException e) {
            ExceptionHandler.handle("Impossible de d\u00e9terminer les modules requis", e);
            return null;
        }
    }

    private boolean isRequiredID(String id) {
        if (this.requiredIDs == null) {
            this.requiredIDs = this.fetchRequiredIDs();
        }
        return this.requiredIDs == null ? false : this.requiredIDs.contains(id);
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 3) {
            return "Etat";
        }
        if (column == 4) {
            return "D\u00e9marrage";
        }
        return super.getColumnName(column);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ModuleFactory f = this.getFactory(rowIndex);
        if (columnIndex == 3) {
            return ModuleManager.getInstance().isModuleRunning(f.getID()) ? "Actif" : "Inactif";
        }
        if (columnIndex == 4) {
            return this.isRequiredID(f.getID()) ? "Obligatoire" : "Facultatif";
        }
        return super.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 3 || columnIndex == 4) {
            return String.class;
        }
        return super.getColumnClass(columnIndex);
    }
}

