/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.HashSet;
import java.util.Set;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModuleTableModel;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.IFactory;
import org.openconcerto.utils.cc.IPredicate;

public class AvailableModuleTableModel
extends ModuleTableModel {
    private static IFactory<Set<ModuleFactory>> getNonInstalled() {
        return new IFactory<Set<ModuleFactory>>(){

            @Override
            public Set<ModuleFactory> createChecked() {
                final ModuleManager mngr = ModuleManager.getInstance();
                return CollectionUtils.select(mngr.getFactories().values(), new IPredicate<ModuleFactory>(){

                    @Override
                    public boolean evaluateChecked(ModuleFactory input) {
                        return !mngr.isModuleInstalledLocally(input.getID());
                    }
                }, new HashSet());
            }
        };
    }

    public AvailableModuleTableModel() {
        super(AvailableModuleTableModel.getNonInstalled());
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 3) {
            return "Description";
        }
        return super.getColumnName(column);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 3) {
            return this.getFactory(rowIndex).getDescription();
        }
        return super.getValueAt(rowIndex, columnIndex);
    }
}

