/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.importer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.Row;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.importer.ArrayTableModel;
import org.openconcerto.erp.importer.Constraint;
import org.openconcerto.erp.importer.NotEmptyConstraint;
import org.openconcerto.erp.importer.ValueConverter;
import org.openconcerto.openoffice.spreadsheet.Sheet;
import org.openconcerto.openoffice.spreadsheet.SpreadSheet;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.utils.text.CSVReader;
import org.openconcerto.utils.text.CharsetHelper;

public class DataImporter {
    private boolean skipFirstLine = true;
    private final SQLTable table;
    private final Map<Integer, ValueConverter> map = new HashMap<Integer, ValueConverter>();
    private final Map<SQLField, List<Integer>> fieldMap = new HashMap<SQLField, List<Integer>>();
    private final Map<Integer, Constraint> constraints = new HashMap<Integer, Constraint>();
    private List<SQLField> uniqueField = new ArrayList<SQLField>();
    private List<SQLRowValues> valuesToUpdate = new ArrayList<SQLRowValues>();
    private List<SQLRowValues> valuesToInsert = new ArrayList<SQLRowValues>();
    private Map<ValueConverter, SQLField> foreignMap = new HashMap<ValueConverter, SQLField>();

    public DataImporter(SQLTable table) {
        this.table = table;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("org.openconcerto.sql.structure.useXML", "true");
        ComptaPropsConfiguration conf = ComptaPropsConfiguration.create();
        conf.setupLogging("Logs");
        Configuration.setInstance(conf);
        try {
            conf.getBase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
        comptaPropsConfiguration.setUpSocieteDataBaseConnexion(39);
        UserManager.getInstance().setCurrentUser(2);
        SQLTable table = Configuration.getInstance().getRoot().findTable("ARTICLE");
        DataImporter importer = new DataImporter(table);
        importer.skipFirstLine = false;
        importer.map(0, table.getField("CODE"));
        importer.map(8, table.getField("ID_FOURNISSEUR"));
        importer.map(4, table.getField("NOM"));
        importer.addContraint(0, new NotEmptyConstraint());
        importer.addUniqueField(table.getField("CODE"));
        ArrayTableModel m = importer.createModelFromXLS(new File("c:/products-en.xls"));
        m.dump(0, 4);
        m = importer.createConvertedModel(m);
        System.out.println("Dump");
        m.dump(0, 4);
        importer.importFromModel(m);
        System.out.println(String.valueOf(importer.getValuesToInsert().size()) + " rows to insert");
        System.out.println(String.valueOf(importer.getValuesToUpdate().size()) + " rows to update");
    }

    public void commit() throws SQLException {
        for (SQLRowValues row : this.valuesToInsert) {
            row.insert();
        }
        for (SQLRowValues row : this.valuesToUpdate) {
            row.update();
        }
    }

    public List<SQLRowValues> getValuesToInsert() {
        return this.valuesToInsert;
    }

    public List<SQLRowValues> getValuesToUpdate() {
        return this.valuesToUpdate;
    }

    public void addUniqueField(SQLField field) {
        if (this.uniqueField.contains(field)) {
            throw new IllegalStateException("Field " + field + " already specified");
        }
        this.uniqueField.add(field);
    }

    public void addContraint(int columnIndex, Constraint c) {
        this.constraints.put(columnIndex, c);
    }

    public void map(int columnIndex, SQLField field) {
        this.map(columnIndex, field, new ValueConverter(field));
    }

    public void map(int columnIndex, ValueConverter converter) {
        this.map(columnIndex, converter.getField(), converter);
    }

    public void map(int columnIndex, SQLField field, SQLField foreignField) {
        ValueConverter converter = new ValueConverter(foreignField);
        this.map(columnIndex, foreignField, converter);
        this.foreignMap.put(converter, field);
    }

    public void map(int columnIndex, SQLField field, ValueConverter converter) {
        Integer value = columnIndex;
        this.map.put(value, converter);
        List<Integer> l = this.fieldMap.get(field);
        if (l == null) {
            l = new ArrayList<Integer>();
            this.fieldMap.put(field, l);
        } else if (!field.getType().getJavaType().equals(String.class)) {
            throw new IllegalArgumentException("Mapping multiple column is only supoprted for String values");
        }
        if (l.contains(value)) {
            throw new IllegalArgumentException("Column " + columnIndex + " already mapped for field " + field.getFullName());
        }
        l.add(value);
    }

    public ArrayTableModel createModelFromODS(File odsFile) throws IOException {
        SpreadSheet spreadSheet = SpreadSheet.createFromFile(odsFile);
        if (spreadSheet.getSheetCount() < 1) {
            return null;
        }
        Sheet sheet = spreadSheet.getSheet(0);
        int rowCount = sheet.getRowCount();
        int columnCount = 0;
        if (rowCount > 0) {
            int maxColumnCount = sheet.getColumnCount();
            int j = 0;
            while (j < maxColumnCount) {
                Object valueAt = sheet.getValueAt(j, 0);
                if (valueAt == null || valueAt.toString().trim().isEmpty()) break;
                ++columnCount;
                ++j;
            }
        }
        int start = 0;
        if (this.skipFirstLine) {
            start = 1;
        }
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>(rowCount - start);
        int i = start;
        while (i < rowCount) {
            ArrayList<Object> row = new ArrayList<Object>();
            int j = 0;
            while (j < columnCount) {
                row.add(sheet.getValueAt(j, i));
                ++j;
            }
            rows.add(row);
            ++i;
        }
        return new ArrayTableModel(rows);
    }

    public ArrayTableModel createModelFromXLS(File xlsFile) throws IOException {
        FileInputStream inputStream = new FileInputStream(xlsFile);
        POIFSFileSystem fileSystem = new POIFSFileSystem(new BufferedInputStream(inputStream));
        HSSFWorkbook workBook = new HSSFWorkbook(fileSystem);
        HSSFSheet sheet = workBook.getSheetAt(0);
        Iterator<Row> rowsIterator = sheet.rowIterator();
        int columnCount = 0;
        int rowCount = 0;
        while (rowsIterator.hasNext()) {
            Row row = rowsIterator.next();
            int i = row.getPhysicalNumberOfCells();
            if (i > columnCount) {
                columnCount = i;
            }
            ++rowCount;
        }
        rowsIterator = sheet.rowIterator();
        int start = 0;
        if (this.skipFirstLine) {
            start = 1;
            rowsIterator.next();
        }
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>(rowCount - start);
        HSSFFormulaEvaluator evaluator = workBook.getCreationHelper().createFormulaEvaluator();
        while (rowsIterator.hasNext()) {
            Row row = rowsIterator.next();
            ArrayList<Object> rowData = new ArrayList<Object>();
            int i = 0;
            while (i < columnCount) {
                Cell cell = row.getCell(i);
                if (cell == null) {
                    rowData.add("");
                } else {
                    CellValue cellValue = evaluator.evaluate(cell);
                    if (cellValue == null) {
                        rowData.add("");
                    } else {
                        switch (cellValue.getCellType()) {
                            case 4: {
                                rowData.add(cellValue.getBooleanValue());
                                break;
                            }
                            case 0: {
                                rowData.add(cellValue.getNumberValue());
                                break;
                            }
                            case 1: {
                                rowData.add(cellValue.getStringValue());
                                break;
                            }
                            case 2: {
                                rowData.add(cell.getCellFormula());
                                break;
                            }
                            case 3: {
                                rowData.add("");
                                break;
                            }
                            default: {
                                rowData.add(cellValue.getStringValue());
                            }
                        }
                    }
                }
                ++i;
            }
            rows.add(rowData);
        }
        ((InputStream)inputStream).close();
        return new ArrayTableModel(rows);
    }

    public ArrayTableModel createModelFromCSV(File csvFile) throws IOException {
        Charset cs = CharsetHelper.guessEncoding(csvFile, 4096, Charset.forName("Cp1252"));
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csvFile), cs));
        String l = r.readLine();
        if (l == null) {
            return null;
        }
        char separator = ',';
        int cCount = 0;
        int scCount = 0;
        int i = 0;
        while (i < l.length()) {
            char c = l.charAt(i);
            if (c == ',') {
                ++cCount;
            } else if (c == ';') {
                ++scCount;
            }
            ++i;
        }
        r.close();
        if (scCount > cCount) {
            separator = ';';
        }
        CSVReader csvReader = new CSVReader(new InputStreamReader((InputStream)new FileInputStream(csvFile), cs), separator);
        List<String[]> lines = csvReader.readAll();
        int rowCount = lines.size();
        int columnCount = lines.get(0).length;
        int start = 0;
        if (this.skipFirstLine) {
            start = 1;
        }
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>(rowCount - start);
        int i2 = start;
        while (i2 < rowCount) {
            ArrayList<String> row = new ArrayList<String>();
            String[] values = lines.get(i2);
            int j = 0;
            while (j < columnCount) {
                row.add(values[j]);
                ++j;
            }
            rows.add(row);
            ++i2;
        }
        csvReader.close();
        return new ArrayTableModel(rows);
    }

    public ArrayTableModel createConvertedModel(ArrayTableModel model) {
        int rowCount = model.getRowCount();
        ArrayList<Integer> colsUsed = new ArrayList<Integer>(this.map.keySet());
        colsUsed.addAll(this.constraints.keySet());
        int columnCount = 1 + Collections.max(colsUsed);
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>(rowCount);
        int i = 0;
        while (i < rowCount) {
            boolean validRow = true;
            ArrayList<Object> row = new ArrayList<Object>();
            int j = 0;
            while (j < columnCount) {
                Constraint constraint;
                Object value = model.getValueAt(i, j);
                ValueConverter converter = this.map.get(j);
                if (converter != null) {
                    value = converter.convertFrom(value);
                }
                if ((constraint = this.constraints.get(j)) != null && !constraint.isValid(value)) {
                    validRow = false;
                    break;
                }
                row.add(value);
                ++j;
            }
            if (validRow) {
                rows.add(row);
            }
            ++i;
        }
        return new ArrayTableModel(rows);
    }

    public void importFromModel(ArrayTableModel model) throws IOException {
        int rowCount = model.getRowCount();
        SQLRowValues vals = new SQLRowValues(this.table);
        for (SQLField field : this.fieldMap.keySet()) {
            if (field.getTable().equals(this.table)) {
                vals.put(field.getName(), null);
                continue;
            }
            Set<SQLField> foreignKeys = this.table.getForeignKeys(field.getTable());
            for (SQLField sqlField : foreignKeys) {
                vals.put(sqlField.getName(), null);
            }
        }
        System.out.println("Fetching values");
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(vals);
        List<SQLRowValues> existingRows = fetcher.fetch();
        System.out.println("Computing cache");
        int existingRowsCount = existingRows.size();
        ValueConverter[] converters = this.map.values().toArray(new ValueConverter[this.map.size()]);
        HashMap cache = new HashMap();
        for (SQLField field : this.uniqueField) {
            HashMap<Object, SQLRowValues> m = new HashMap<Object, SQLRowValues>();
            cache.put(field, m);
            String fieldName = field.getName();
            int j = 0;
            while (j < existingRowsCount) {
                SQLRowValues row = existingRows.get(j);
                m.put(row.getObject(fieldName), row);
                ++j;
            }
        }
        int i = 0;
        while (i < rowCount) {
            SQLRowValues existingRow = null;
            for (SQLField field : this.uniqueField) {
                List<Integer> cols = this.fieldMap.get(field);
                Object objectToInsert = null;
                for (Integer col : cols) {
                    Object v = model.getValueAt(i, col);
                    if (objectToInsert == null) {
                        objectToInsert = v;
                        continue;
                    }
                    if (!(v instanceof String)) continue;
                    objectToInsert = String.valueOf(objectToInsert.toString()) + "\n" + (String)v;
                }
                existingRow = (SQLRowValues)((Map)cache.get(field)).get(objectToInsert);
                if (existingRow != null) break;
            }
            this.updateOrInsert(model, converters, i, existingRow);
            ++i;
        }
    }

    private void updateOrInsert(ArrayTableModel model, ValueConverter[] converters, int i, SQLRowValues existingRow) {
        HashMap<String, Object> newValues = new HashMap<String, Object>();
        if (existingRow != null) {
            newValues.putAll(existingRow.getAbsolutelyAll());
        }
        int j = 0;
        while (j < converters.length) {
            ValueConverter valueConverter = converters[j];
            List<Integer> cols = this.fieldMap.get(valueConverter.getField());
            Object objectToInsert = null;
            for (Integer col : cols) {
                Object v = model.getValueAt(i, col);
                if (objectToInsert == null) {
                    objectToInsert = v;
                    continue;
                }
                if (!(v instanceof String)) continue;
                objectToInsert = String.valueOf(objectToInsert.toString()) + "\n" + (String)v;
            }
            String fieldName = valueConverter.getFieldName();
            if (valueConverter.getField().getTable().equals(this.table)) {
                newValues.put(fieldName, objectToInsert);
            } else {
                SQLField sqlField = this.foreignMap.get(valueConverter);
                Object value = newValues.get(sqlField.getName());
                if (value == null || value instanceof SQLRowValues) {
                    SQLRowValues fRowValues = (SQLRowValues)value;
                    if (fRowValues == null) {
                        fRowValues = new SQLRowValues(valueConverter.getField().getTable());
                        newValues.put(sqlField.getName(), fRowValues);
                    }
                    fRowValues.put(valueConverter.getField().getName(), objectToInsert);
                }
            }
            ++j;
        }
        if (existingRow == null) {
            this.valuesToInsert.add(new SQLRowValues(this.table, newValues));
        } else if (!newValues.equals(existingRow.getAbsolutelyAll())) {
            this.valuesToUpdate.add(new SQLRowValues(this.table, newValues));
        }
    }

    public void setSkipFirstLine(boolean skipFirstLine) {
        this.skipFirstLine = skipFirstLine;
    }

    public ArrayTableModel createModelFrom(File file) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException(String.valueOf(file.getAbsolutePath()) + " does not exist");
        }
        String name = file.getName().toLowerCase();
        if (name.endsWith(".ods")) {
            return this.createModelFromODS(file);
        }
        if (name.endsWith(".csv")) {
            return this.createModelFromCSV(file);
        }
        if (name.endsWith(".xls")) {
            return this.createModelFromXLS(file);
        }
        throw new IllegalArgumentException("File format not supported");
    }
}

