/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jopenchart.Axis;
import org.jopenchart.AxisLabel;
import org.jopenchart.ChartPanel;
import org.jopenchart.barchart.VerticalGroupBarChart;
import org.openconcerto.erp.graph.MargeDataModel;
import org.openconcerto.erp.graph.MargeDayDataModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.preferences.PreferencePanel;

public class GraphMargePanel
extends JPanel
implements ChangeListener,
ItemListener,
ActionListener {
    private final JSpinner s1 = new JSpinner();
    private final JSpinner s2 = new JSpinner();
    private MargeDataModel model1;
    private MargeDataModel model2;
    private MargeDayDataModel model3;
    private MargeDayDataModel model4;
    private List<Color> colors = new ArrayList<Color>();
    private int year;
    private int month;
    private JComboBox combo;
    private JButton buttonLeft;
    private JButton buttonRight;
    private Axis axisX;
    private VerticalGroupBarChart dayChart;
    private VerticalGroupBarChart monthChart;

    public GraphMargePanel() {
        this.colors.add(Color.decode("#4A79A5"));
        this.colors.add(Color.decode("#639ACE"));
        this.year = Calendar.getInstance().get(1);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        JTabbedPane pane = new JTabbedPane();
        pane.add("Par mois", this.createMonthPanel());
        pane.add("Par jour", this.createDayPanel());
        this.add((Component)pane, c);
        ++c.gridy;
        this.add((Component)new JSeparator(0), c);
        this.s1.setValue(this.year - 1);
        this.s2.setValue(this.year);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0, 5, 5));
        p1.add(new JLabel("Ann\u00e9es: "));
        p1.add(this.createColorPanel(this.colors.get(0)));
        p1.add(this.s1);
        p1.add(this.createSpacer());
        p1.add(this.createColorPanel(this.colors.get(1)));
        p1.add(this.s2);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 2;
        c.anchor = 18;
        this.add((Component)p1, c);
        this.s1.addChangeListener(this);
        this.s2.addChangeListener(this);
    }

    private Component createDayPanel() {
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new GridBagLayout());
        Axis axisY = new Axis("y");
        axisY.addLabel(new AxisLabel("0"));
        axisY.addLabel(new AxisLabel("500 \u20ac"));
        axisY.addLabel(new AxisLabel("1000 \u20ac"));
        this.axisX = new Axis("x");
        this.dayChart = new VerticalGroupBarChart();
        this.dayChart.setLeftAxis(axisY);
        this.dayChart.setBarWidth(9);
        this.dayChart.setSpaceBetweenGroups(3);
        this.dayChart.setColors(this.colors);
        this.dayChart.setDimension(new Dimension(800, 400));
        this.updateDayAxis();
        this.model3 = new MargeDayDataModel(this.dayChart, this.year - 1, this.month);
        this.dayChart.addModel(this.model3);
        this.model4 = new MargeDayDataModel(this.dayChart, this.year, this.month);
        this.dayChart.addModel(this.model4);
        ChartPanel panel = new ChartPanel(this.dayChart){

            @Override
            public String getToolTipTextFrom(Number n) {
                if (n == null) {
                    return null;
                }
                MargeDayDataModel m = (MargeDayDataModel)GraphMargePanel.this.dayChart.getHighlight().getModel();
                return String.valueOf(GraphMargePanel.this.axisX.getLabels().get(GraphMargePanel.this.dayChart.getHighlight().getIndexOnModel()).getLabel()) + " " + GraphMargePanel.this.combo.getSelectedItem() + " " + m.getYear() + ": " + n.longValue() + " \u20ac";
            }
        };
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        JPanel p2 = new JPanel(new FlowLayout());
        p2.setOpaque(false);
        p2.add(new JLabel("D\u00e9tail du mois de "));
        this.combo = new JComboBox<String>(new String[]{"janvier", "f\u00e9vrier", "mars", "avril", "mai", "juin", "juillet", "ao\u00fbt", "septembre", "octobre", "novembre", "d\u00e9cembre"});
        p2.add(this.combo);
        this.buttonLeft = this.createButton("fleche_g.png");
        p2.add(this.buttonLeft);
        this.buttonRight = this.createButton("fleche_d.png");
        p2.add(this.buttonRight);
        p.add((Component)p2, c);
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridy;
        p.add((Component)new JSeparator(0), c);
        ++c.gridy;
        p.add((Component)panel, c);
        this.combo.addItemListener(this);
        this.buttonLeft.addActionListener(this);
        this.buttonRight.addActionListener(this);
        return p;
    }

    private void updateDayAxis() {
        int y1 = ((Number)this.s1.getValue()).intValue();
        int y2 = ((Number)this.s2.getValue()).intValue();
        Calendar cal = Calendar.getInstance();
        cal.set(y1, this.month, 1);
        int nbDays1 = cal.getActualMaximum(5);
        cal.set(y2, this.month, 1);
        int nbDays2 = cal.getActualMaximum(5);
        int nbJoursMax = Math.max(nbDays1, nbDays2);
        System.err.println(String.valueOf(nbDays1) + "|" + nbDays2 + " jours :M:" + this.month + " Y:" + y1 + "," + y2);
        this.axisX.removeAllLabels();
        int i = 0;
        while (i < nbJoursMax) {
            this.axisX.addLabel(new AxisLabel(String.valueOf(i + 1), i + 1));
            ++i;
        }
        this.dayChart.setBottomAxis(this.axisX);
        this.dayChart.setLowerRange(0);
        this.dayChart.setHigherRange(0);
    }

    private void updateMonthAxis() {
        System.err.println("GraphMargePanel.updateMonthAxis()");
        this.monthChart.setLowerRange(0);
        this.monthChart.setHigherRange(0);
    }

    private JButton createButton(String name) {
        JButton button = new JButton(new ImageIcon(PreferencePanel.class.getResource(name)));
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setFocusable(false);
        button.setPreferredSize(new Dimension(24, button.getPreferredSize().height));
        return button;
    }

    private JPanel createMonthPanel() {
        JPanel p = new JPanel();
        p.setOpaque(true);
        p.setBackground(Color.WHITE);
        p.setLayout(new GridBagLayout());
        Axis axisY = new Axis("y");
        axisY.addLabel(new AxisLabel("0"));
        axisY.addLabel(new AxisLabel("500 \u20ac"));
        axisY.addLabel(new AxisLabel("1000 \u20ac"));
        final Axis axisX = new Axis("x");
        axisX.addLabel(new AxisLabel("Janvier", 1));
        axisX.addLabel(new AxisLabel("F\u00e9vrier", 2));
        axisX.addLabel(new AxisLabel("Mars", 3));
        axisX.addLabel(new AxisLabel("Avril", 4));
        axisX.addLabel(new AxisLabel("Mai", 5));
        axisX.addLabel(new AxisLabel("Juin", 6));
        axisX.addLabel(new AxisLabel("Juillet", 7));
        axisX.addLabel(new AxisLabel("Ao\u00fbt", 8));
        axisX.addLabel(new AxisLabel("Septembre", 9));
        axisX.addLabel(new AxisLabel("Octobre", 10));
        axisX.addLabel(new AxisLabel("Novembre", 11));
        axisX.addLabel(new AxisLabel("D\u00e9cembre", 12));
        this.monthChart = new VerticalGroupBarChart();
        this.monthChart.setBottomAxis(axisX);
        this.monthChart.setLeftAxis(axisY);
        this.monthChart.setBarWidth(22);
        this.monthChart.setColors(this.colors);
        this.monthChart.setDimension(new Dimension(800, 400));
        this.updateMonthAxis();
        this.model1 = new MargeDataModel(this.monthChart, this.year - 1);
        this.monthChart.addModel(this.model1);
        this.model2 = new MargeDataModel(this.monthChart, this.year);
        this.monthChart.addModel(this.model2);
        ChartPanel panel = new ChartPanel(this.monthChart){

            @Override
            public String getToolTipTextFrom(Number n) {
                if (n == null) {
                    return null;
                }
                MargeDataModel m = (MargeDataModel)GraphMargePanel.this.monthChart.getHighlight().getModel();
                return String.valueOf(axisX.getLabels().get(GraphMargePanel.this.monthChart.getHighlight().getIndexOnModel()).getLabel()) + " " + m.getYear() + ": " + n.longValue() + " \u20ac";
            }
        };
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 1;
        p.add((Component)panel, c);
        panel.setOpaque(false);
        return p;
    }

    private Component createColorPanel(Color color) {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        p.setMinimumSize(new Dimension(40, 16));
        p.setPreferredSize(new Dimension(40, 16));
        p.setOpaque(true);
        p.setBackground(color);
        return p;
    }

    private Component createSpacer() {
        JPanel p = new JPanel();
        p.setMinimumSize(new Dimension(16, 16));
        p.setPreferredSize(new Dimension(16, 16));
        p.setOpaque(false);
        return p;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.s1 || e.getSource() == this.s2) {
            this.updateDayAxis();
            this.updateMonthAxis();
            this.model1.loadYear(this.s1.getValue());
            this.model2.loadYear(this.s2.getValue());
            this.model3.loadYear(this.s1.getValue(), this.month);
            this.model4.loadYear(this.s2.getValue(), this.month);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.combo.getSelectedIndex() != this.month) {
            this.month = this.combo.getSelectedIndex();
            this.updateDayAxis();
            this.model3.loadYear(this.s1.getValue(), this.month);
            this.model4.loadYear(this.s2.getValue(), this.month);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int c = this.combo.getSelectedIndex();
        if (e.getSource() == this.buttonRight) {
            if (++c > 11) {
                c = 0;
            }
            this.combo.setSelectedIndex(c);
        } else if (e.getSource() == this.buttonLeft) {
            if (--c < 0) {
                c = 11;
            }
            this.combo.setSelectedIndex(c);
        }
    }
}

