/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPanel;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.jopenchart.ChartPanel;
import org.jopenchart.Label;
import org.jopenchart.piechart.PieChart;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;

public class GraphArticleVentePanel
extends JPanel {
    public GraphArticleVentePanel() {
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<Number> values = new ArrayList<Number>();
        this.updateDataset(labels, values);
        PieChart chart = new PieChart();
        chart.setDimension(new Dimension(800, 360));
        chart.setData(values);
        for (String label : labels) {
            chart.addLabel(new Label(label));
        }
        ChartPanel p = new ChartPanel(chart);
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.add(p);
    }

    protected void updateDataset(List<String> labels, List<Number> values) {
        int value;
        SQLTable tableVFElement = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE_ELEMENT").getTable();
        SQLSelect sel = new SQLSelect(tableVFElement.getBase());
        String field = "NOM";
        sel.addSelect(tableVFElement.getField(field));
        sel.addSelectFunctionStar("COUNT");
        SQLDataSource dataSource = Configuration.getInstance().getBase().getDataSource();
        List rowsArticle = (List)dataSource.execute(String.valueOf(sel.asString()) + " GROUP BY \"SAISIE_VENTE_FACTURE_ELEMENT\".\"" + field + "\"", new ArrayListHandler());
        Collections.sort(rowsArticle, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                return Integer.parseInt(o2[1].toString()) - Integer.parseInt(o1[1].toString());
            }
        });
        int rowCount = 0;
        for (Object[] objects : rowsArticle) {
            value = Integer.parseInt(objects[1].toString());
            rowCount += value;
        }
        int i = 0;
        while (i < 10 && i < rowsArticle.size()) {
            Object[] o = (Object[])rowsArticle.get(i);
            value = Integer.parseInt(o[1].toString());
            String string = String.valueOf(o[0].toString()) + " (" + (double)Math.round((double)value / (double)rowCount * 10000.0) / 100.0 + "%)";
            values.add(value);
            labels.add(string);
            ++i;
        }
    }
}

