/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.graph;

import java.util.Calendar;
import java.util.Date;
import org.jopenchart.DataModel1D;
import org.jopenchart.barchart.VerticalBarChart;
import org.openconcerto.erp.core.finance.accounting.model.SommeCompte;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.RTInterruptedException;

public class CADataModel
extends DataModel1D {
    private VerticalBarChart chart;
    private Thread thread;
    private int year;

    public CADataModel(VerticalBarChart chart, int year) {
        this.chart = chart;
        this.loadYear(year);
    }

    @Override
    public int getSize() {
        return 12;
    }

    public synchronized void loadYear(Object value) {
        if (!(value instanceof Number)) {
            return;
        }
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.year = ((Number)value).intValue();
        this.thread = new Thread(){

            @Override
            public void run() {
                CADataModel.this.setState(0);
                CADataModel.this.clear();
                CADataModel.this.fireDataModelChanged();
                SommeCompte sommeCompte = new SommeCompte();
                try {
                    int i = 0;
                    while (i < 12) {
                        if (this.isInterrupted()) break;
                        Calendar c = Calendar.getInstance();
                        c.set(CADataModel.this.year, i, 1);
                        Date d1 = new Date(c.getTimeInMillis());
                        c.set(5, c.getActualMaximum(5));
                        Date d2 = new Date(c.getTimeInMillis());
                        Thread.yield();
                        float vCA = 0.0f;
                        SQLElementDirectory directory = Configuration.getInstance().getDirectory();
                        SQLTable tableEcr = directory.getElement("ECRITURE").getTable();
                        SQLTable tableCpt = directory.getElement("COMPTE_PCE").getTable();
                        SQLSelect sel = new SQLSelect(tableEcr.getBase());
                        sel.addSelect(tableEcr.getField("DEBIT"), "SUM");
                        sel.addSelect(tableEcr.getField("CREDIT"), "SUM");
                        Where w = new Where((FieldRef)tableEcr.getField("DATE"), d1, (Object)d2);
                        Where w2 = new Where((FieldRef)tableEcr.getField("ID_COMPTE_PCE"), "=", tableCpt.getKey());
                        Where w3 = new Where((FieldRef)tableCpt.getField("NUMERO"), "LIKE", (Object)"70%");
                        Where w4 = new Where((FieldRef)tableEcr.getField("NOM"), "LIKE", (Object)"Fermeture%");
                        sel.setWhere(w.and(w2).and(w3).and(w4));
                        Object[] o = tableEcr.getBase().getDataSource().executeA1(sel.asString());
                        if (o != null && o[0] != null && o[1] != null && (Long.valueOf(o[0].toString()) != 0L || Long.valueOf(o[1].toString()) != 0L)) {
                            long deb = Long.valueOf(o[0].toString());
                            long cred = Long.valueOf(o[1].toString());
                            long tot = deb - cred;
                            vCA = sommeCompte.soldeCompteDebiteur(700, 708, true, d1, d2) - sommeCompte.soldeCompteDebiteur(709, 709, true, d1, d2);
                            vCA = (float)tot - vCA;
                        } else {
                            vCA = sommeCompte.soldeCompteCrediteur(700, 708, true, d1, d2) - sommeCompte.soldeCompteCrediteur(709, 709, true, d1, d2);
                        }
                        float value = vCA / 100.0f;
                        if (value > CADataModel.this.chart.getHigherRange().floatValue()) {
                            long euros = (long)value;
                            String currencyToString = GestionDevise.currencyToString(euros * 100L, true);
                            CADataModel.this.chart.getLeftAxis().getLabels().get(2).setLabel(String.valueOf(currencyToString.substring(0, currencyToString.length() - 3)) + " \u20ac");
                            currencyToString = GestionDevise.currencyToString(euros * 100L / 2L, true);
                            CADataModel.this.chart.getLeftAxis().getLabels().get(1).setLabel(String.valueOf(currencyToString.substring(0, currencyToString.length() - 3)) + " \u20ac");
                            CADataModel.this.chart.setHigherRange(Float.valueOf(value));
                        }
                        if ((int)value != 0) {
                            CADataModel.this.setValueAt(i, Float.valueOf(value));
                            CADataModel.this.fireDataModelChanged();
                            Thread.sleep(20L);
                        }
                        ++i;
                    }
                    if (!this.isInterrupted()) {
                        CADataModel.this.setState(1);
                        CADataModel.this.fireDataModelChanged();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (RTInterruptedException rTInterruptedException) {
                    // empty catch block
                }
            }
        };
        this.thread.setPriority(1);
        this.thread.start();
    }

    public int getYear() {
        return this.year;
    }
}

