/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationMvtReglementChequeFourn
extends GenerationEcritures {
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLTable tableCheque = base.getTable("CHEQUE_FOURNISSEUR");
    private static final SQLTable tableFourn = base.getTable("FOURNISSEUR");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtReglementChequeFourn(int idMvt, long montant, int idCheque, Date d) {
        try {
            this.idMvt = idMvt;
            System.out.println("g\u00e9n\u00e9ration des ecritures de r\u00e8glement d'un cheque fournisseur");
            SQLRow rowCheque = tableCheque.getRow(idCheque);
            this.date = d;
            SQLRow rowFournisseur = tableFourn.getRow(rowCheque.getInt("ID_FOURNISSEUR"));
            this.nom = "Reglement cheque " + rowFournisseur.getString("NOM");
            this.mEcritures.put("DATE", new java.sql.Date(this.date.getTime()));
            this.mEcritures.put("NOM", this.nom);
            this.mEcritures.put("ID_JOURNAL", 4);
            this.mEcritures.put("ID_MOUVEMENT", new Integer(this.idMvt));
            int idCompteFourn = rowFournisseur.getInt("ID_COMPTE_PCE");
            if (idCompteFourn <= 1 && (idCompteFourn = rowPrefsCompte.getInt("ID_COMPTE_PCE_FOURNISSEUR")) <= 1) {
                try {
                    idCompteFourn = ComptePCESQLElement.getIdComptePceDefault("Fournisseurs");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mEcritures.put("ID_COMPTE_PCE", new Integer(idCompteFourn));
            this.mEcritures.put("DEBIT", new Long(montant));
            this.mEcritures.put("CREDIT", new Long(0L));
            this.ajoutEcriture();
            int idPce = base.getTable("TYPE_REGLEMENT").getRow(2).getInt("ID_COMPTE_PCE_FOURN");
            if (idPce <= 1) {
                try {
                    idPce = ComptePCESQLElement.getIdComptePceDefault("AchatCheque");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mEcritures.put("ID_COMPTE_PCE", new Integer(idPce));
            this.mEcritures.put("DEBIT", new Long(0L));
            this.mEcritures.put("CREDIT", new Long(montant));
            this.ajoutEcriture();
        }
        catch (IllegalArgumentException e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
            e.printStackTrace();
        }
    }
}

