/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.StyleSQLElement;
import org.openconcerto.erp.generationDoc.SheetUtils;
import org.openconcerto.erp.generationDoc.TemplateManager;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.spreadsheet.MutableCell;
import org.openconcerto.openoffice.spreadsheet.Sheet;
import org.openconcerto.openoffice.spreadsheet.SpreadSheet;
import org.openconcerto.openoffice.spreadsheet.Table;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.StreamUtils;

public class OOgenerationListeColumnXML {
    private static Map<Sheet, Map<String, Map<Integer, String>>> cacheStyle = new HashMap<Sheet, Map<String, Map<Integer, String>>>();

    public static File genere(String modele, File pathDest, String fileDest, Map<Integer, List<Map<String, Object>>> liste, Map<Integer, Map<String, Object>> values) {
        return OOgenerationListeColumnXML.genere(modele, pathDest, fileDest, liste, values, new HashMap<Integer, Map<Integer, String>>(), null, null);
    }

    public static File genere(String templateId, File pathDest, String fileDest, Map<Integer, List<Map<String, Object>>> liste, Map<Integer, Map<String, Object>> values, Map<Integer, Map<Integer, String>> mapStyle, List<String> sheetName, SQLRow rowLanguage) {
        cacheStyle.clear();
        SAXBuilder builder = new SAXBuilder();
        try {
            InputStream xmlConfiguration = TemplateManager.getInstance().getTemplateConfiguration(templateId, rowLanguage != null ? rowLanguage.getString("CHEMIN") : null, null);
            Document doc = builder.build(xmlConfiguration);
            Element racine = doc.getRootElement();
            InputStream template = TemplateManager.getInstance().getTemplate(templateId, rowLanguage != null ? rowLanguage.getString("CHEMIN") : null, null);
            SpreadSheet spreadSheet = new ODPackage(template).getSpreadSheet();
            Sheet sheet0 = spreadSheet.getSheet(0);
            if (sheetName != null && sheetName.size() > 0) {
                int i = 1;
                while (i < sheetName.size()) {
                    sheet0.copy(i, sheetName != null ? sheetName.get(i) : "Feuille " + i);
                    ++i;
                }
                spreadSheet.getSheet(0).setName(sheetName.get(0));
            }
            for (Integer i : liste.keySet()) {
                Sheet sheet = spreadSheet.getSheet(i);
                List children = racine.getChildren("element" + i);
                if (children.size() == 0) {
                    children = racine.getChildren("element");
                }
                OOgenerationListeColumnXML.parseElementsXML(children, sheet, values.get(i));
                Element child = racine.getChild("table" + i);
                if (child == null) {
                    child = racine.getChild("table");
                }
                OOgenerationListeColumnXML.parseListeXML(child, liste.get(i), sheet, mapStyle.get(i));
            }
            return OOgenerationListeColumnXML.saveSpreadSheet(spreadSheet, pathDest, fileDest, templateId, rowLanguage);
        }
        catch (JDOMException e) {
            ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration du fichier " + fileDest, e);
        }
        catch (IOException e) {
            ExceptionHandler.handle("Erreur lors de la cr\u00e9ation du fichier " + fileDest, e);
        }
        return null;
    }

    private static void parseElementsXML(List<Element> elts, Sheet sheet, Map<String, Object> values) {
        if (values == null) {
            return;
        }
        for (Element elt : elts) {
            String name = elt.getAttributeValue("ValueName");
            Object result = values.get(name);
            if (result == null) continue;
            boolean controlLine = elt.getAttributeValue("controleMultiline") == null ? true : !elt.getAttributeValue("controleMultiline").equalsIgnoreCase("false");
            boolean replace = elt.getAttributeValue("type").equalsIgnoreCase("Replace");
            String replacePattern = elt.getAttributeValue("replacePattern");
            OOgenerationListeColumnXML.fill(sheet.getCellAt(elt.getAttributeValue("location")), result, sheet, replace, replacePattern, null, false, controlLine);
        }
    }

    private static void parseListeXML(Element tableau, List<Map<String, Object>> liste, Sheet sheet, Map<Integer, String> style) {
        if (liste == null || tableau == null) {
            return;
        }
        String oLastColTmp = tableau.getAttributeValue("lastColumn");
        int lastColumn = -1;
        int endPageLine = Integer.valueOf(tableau.getAttributeValue("endPageLine"));
        if (oLastColTmp != null) {
            lastColumn = sheet.resolveHint((String)new StringBuilder((String)String.valueOf((Object)oLastColTmp.toString())).append((int)1).toString()).x + 1;
        }
        Map<String, Map<Integer, String>> mapStyle = OOgenerationListeColumnXML.searchStyle(sheet, lastColumn, endPageLine);
        OOgenerationListeColumnXML.fillTable(tableau, liste, sheet, mapStyle, false, style);
    }

    private static int fillTable(Element tableau, List<Map<String, Object>> liste, Sheet sheet, Map<String, Map<Integer, String>> mapStyle, boolean test, Map<Integer, String> style) {
        int endPageLine = Integer.valueOf(tableau.getAttributeValue("endPageLine"));
        int endLine = Integer.valueOf(tableau.getAttributeValue("endLine"));
        List listElts = tableau.getChildren("element");
        Object o = null;
        String columnSousTotal = tableau.getAttributeValue("groupSousTotalColumn");
        HashMap mapSousTotal = new HashMap();
        HashMap mapTotal = new HashMap();
        sheet.setColumnCount(liste.size() + 5);
        Integer firstCol = Integer.valueOf(tableau.getAttributeValue("firstLine"));
        int currentCol = firstCol;
        int i = 0;
        while (i < liste.size()) {
            Map<String, Object> mValues = liste.get(i);
            if (currentCol != firstCol) {
                int k = 0;
                while (k < endLine) {
                    MutableCell c1 = sheet.getCellAt(firstCol, k);
                    if (c1.getFormula() != null && c1.getFormula().trim().length() > 0) {
                        String formula = c1.getFormula();
                        MutableCell c2 = sheet.getCellAt(currentCol, k);
                        System.err.println(formula);
                        formula = formula.replaceAll("(" + Table.toStr(c1.getX()) + ")" + "(\\d+)", String.valueOf(Table.toStr(c2.getX())) + "$2");
                        formula = formula.replaceAll(String.valueOf(Table.toStr(c1.getX())) + "\\$", String.valueOf(Table.toStr(c2.getX())) + "\\$");
                        System.err.println(" replace by " + formula);
                        c2.getElement().setAttribute("formula", formula, c2.getElement().getNamespace());
                        c2.setStyleName(c1.getStyleName());
                    }
                    ++k;
                }
            }
            String styleName = null;
            for (Element e : listElts) {
                boolean controlLine;
                MutableCell<SpreadSheet> cell = sheet.getCellAt(currentCol, Integer.valueOf(e.getAttributeValue("location").trim()));
                boolean bl = e.getAttributeValue("controleMultiline") == null ? true : (controlLine = !e.getAttributeValue("controleMultiline").equalsIgnoreCase("false"));
                if (!e.getAttributeValue("type").equalsIgnoreCase("fill") && !e.getAttributeValue("type").equalsIgnoreCase("replace")) continue;
                Object value = OOgenerationListeColumnXML.getElementValue(e, mValues);
                boolean replace = e.getAttributeValue("type").equalsIgnoreCase("replace");
                if (test || cell.isValid()) {
                    if (currentCol != firstCol) {
                        MutableCell c2 = sheet.getCellAt(firstCol, cell.getPoint().y);
                        styleName = c2.getStyleName();
                    }
                    int tmpCelluleAffect = OOgenerationListeColumnXML.fill(cell, value, sheet, replace, null, styleName, test, controlLine);
                    continue;
                }
                System.err.println("Cell not valid at " + cell);
            }
            ++currentCol;
            ++i;
        }
        return 1;
    }

    private static void incrementTotal(String field, Double value, Map<String, Double> map) {
        Double d = map.get(field);
        if (d == null) {
            map.put(field, value);
        } else {
            map.put(field, d + value);
        }
    }

    private static Object getElementValue(Element elt, Map<String, Object> mValues) {
        Object res = "";
        List eltFields = elt.getChildren("field");
        if (eltFields != null) {
            if (eltFields.size() > 1) {
                String result = "";
                Iterator j = eltFields.iterator();
                while (j.hasNext()) {
                    Object o = OOgenerationListeColumnXML.getValueOfComposant((Element)j.next(), mValues);
                    if (o == null) continue;
                    result = String.valueOf(result) + o.toString() + " ";
                }
                res = result;
            } else {
                res = OOgenerationListeColumnXML.getValueOfComposant((Element)eltFields.get(0), mValues);
            }
        }
        return res;
    }

    private static Object getValueOfComposant(Element eltField, Map<String, Object> mValues) {
        String field = eltField.getAttributeValue("name");
        return mValues.get(field);
    }

    private static int fill(String location, Object value, Sheet sheet, boolean replace, String replacePattern, String styleOO, boolean test) {
        return OOgenerationListeColumnXML.fill(sheet.getCellAt(location), value, sheet, replace, replacePattern, styleOO, test, true);
    }

    private static int fill(MutableCell<SpreadSheet> cell, Object value, Sheet sheet, boolean replace, String replacePattern, String styleOO, boolean test, boolean controlLine) {
        int nbCellule = 1;
        if (test || cell.isValid()) {
            if (controlLine && value != null && value.toString().indexOf(10) >= 0) {
                if (!test) {
                    String firstPart = value.toString().substring(0, value.toString().indexOf(10));
                    String secondPart = value.toString().substring(value.toString().indexOf(10) + 1, value.toString().length());
                    secondPart = secondPart.replace('\n', ',');
                    OOgenerationListeColumnXML.setCellValue(cell, firstPart, replace, replacePattern);
                    if (styleOO != null) {
                        cell.setStyleName(styleOO);
                    }
                    Point p = cell.getPoint();
                    try {
                        MutableCell cellSec = sheet.getCellAt(p.x, p.y + 1);
                        OOgenerationListeColumnXML.setCellValue(cellSec, secondPart, replace, replacePattern);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                nbCellule = 2;
            } else if (!test) {
                OOgenerationListeColumnXML.setCellValue(cell, value, replace, replacePattern);
                if (styleOO != null) {
                    cell.setStyleName(styleOO);
                }
            }
        }
        return nbCellule;
    }

    private static void setCellValue(MutableCell cell, Object value, boolean replace, String replacePattern) {
        if (value == null) {
            value = "";
        }
        if (replace) {
            if (replacePattern != null) {
                cell.replaceBy(replacePattern, value.toString());
            } else {
                cell.replaceBy("_", value.toString());
            }
        } else {
            cell.setValue(value);
        }
    }

    private static File saveSpreadSheet(SpreadSheet ssheet, File pathDest, String fileName, String templateId, SQLRow rowLanguage) throws IOException {
        if (ssheet == null || pathDest == null || fileName.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        File fDest = new File(pathDest, String.valueOf(fileName) + ".ods");
        if (!pathDest.exists()) {
            pathDest.mkdirs();
        }
        SheetUtils.convertToOldFile(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete(), fileName, pathDest, fDest);
        try {
            ssheet.saveAs(fDest);
        }
        catch (FileNotFoundException e) {
            final File F = fDest;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        JOptionPane.showMessageDialog(null, "Le fichier " + F.getCanonicalPath() + " n'a pu \u00eatre cr\u00e9\u00e9. \n V\u00e9rifiez qu'il n'est pas d\u00e9j\u00e0 ouvert.");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            e.printStackTrace();
        }
        try {
            File odspOut = new File(pathDest, String.valueOf(fileName) + ".odsp");
            InputStream odspIn = TemplateManager.getInstance().getTemplatePrintConfiguration(templateId, rowLanguage != null ? rowLanguage.getString("CHEMIN") : null, null);
            if (odspIn != null) {
                StreamUtils.copy(odspIn, odspOut);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Le fichier odsp n'existe pas.");
        }
        return fDest;
    }

    private static Map<String, Map<Integer, String>> searchStyle(Sheet sheet, int colEnd, int rowEnd) {
        if (cacheStyle.get(sheet) != null) {
            return cacheStyle.get(sheet);
        }
        Map<String, Map<Integer, String>> mapStyleDef = StyleSQLElement.getMapAllStyle();
        int columnCount = colEnd == -1 ? sheet.getColumnCount() : colEnd + 1;
        System.err.println("End column search : " + columnCount);
        int rowCount = rowEnd > 0 ? rowEnd : sheet.getRowCount();
        System.err.println("End row search : " + rowCount);
        int i = 0;
        while (i < rowCount) {
            int x = 0;
            HashMap<Integer, String> mapCellStyle = new HashMap<Integer, String>();
            String style = "";
            int j = 0;
            while (j < columnCount) {
                block11: {
                    try {
                        if (!sheet.isCellValid(j, i)) break block11;
                        MutableCell c = sheet.getCellAt(j, i);
                        String cellStyle = c.getStyleName();
                        try {
                            if (mapStyleDef.containsKey(c.getValue().toString())) {
                                style = c.getValue().toString();
                            }
                        }
                        catch (IllegalStateException e) {
                            e.printStackTrace();
                        }
                        mapCellStyle.put(x, cellStyle);
                        if (style.trim().length() != 0) {
                            String styleCell;
                            c.clearValue();
                            if (!style.trim().equalsIgnoreCase("Normal") && mapStyleDef.get("Normal") != null && (styleCell = mapStyleDef.get("Normal").get(x)) != null && styleCell.length() != 0) {
                                c.setStyleName(styleCell);
                            }
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.err.println("Index out of bounds Exception");
                    }
                }
                ++x;
                ++j;
            }
            if (style.length() > 0) {
                mapStyleDef.put(style, mapCellStyle);
            }
            ++i;
        }
        cacheStyle.put(sheet, mapStyleDef);
        return mapStyleDef;
    }

    public static void main(String[] args) {
        ComptaPropsConfiguration conf = ComptaPropsConfiguration.create();
        System.err.println("Conf created");
        Configuration.setInstance(conf);
        conf.setUpSocieteDataBaseConnexion(36);
        System.err.println("Connection Set up");
        System.err.println("Start Genere");
        System.err.println("Stop genere");
    }
}

