/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.openconcerto.erp.core.sales.pos.Caisse;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.ui.CaisseMenuPanel;
import org.openconcerto.erp.core.sales.pos.ui.CaissePanel;
import org.openconcerto.erp.core.sales.pos.ui.ListeDesTicketsPanel;
import org.openconcerto.utils.ClassPathLoader;
import org.openconcerto.utils.ExceptionHandler;

public class CaisseFrame
extends JFrame {
    CaissePanel t = new CaissePanel(this);

    CaisseFrame() {
        this.setContentPane(this.t);
        this.setFocusable(true);
    }

    public static void main(String[] args) {
        try {
            System.out.println("Lancement du module de caisse");
            ToolTipManager.sharedInstance().setInitialDelay(0);
            if (System.getProperty("org.openconcerto.sql.deafState") == null) {
                System.setProperty("org.openconcerto.sql.deafState", "true");
            }
            System.setProperty("sun.java2d.pmoffscreen", "false");
            System.setProperty("org.openconcerto.sql.structure.useXML", "true");
            if (Caisse.isUsingJPos()) {
                ClassPathLoader c = ClassPathLoader.getInstance();
                try {
                    String posDirectory = Caisse.getJPosDirectory();
                    if (posDirectory != null && !posDirectory.trim().isEmpty()) {
                        c.addJarFromDirectory(new File(posDirectory.trim()));
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                c.load();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        System.setProperty("awt.useSystemAAFontSettings", "on");
                        System.setProperty("swing.aatext", "true");
                        System.setProperty("org.openconcerto.sql.comboCanModify", "true");
                        Caisse.createConnexion();
                        CaisseFrame f = new CaisseFrame();
                        f.setUndecorated(true);
                        f.setDefaultCloseOperation(3);
                        f.pack();
                        f.setLocation(0, 0);
                        System.out.println("Affichage de l'interface");
                        f.setVisible(true);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle("Erreur d'initialisation de la caisse (main)", e);
                    }
                }
            });
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur d'initialisation de la caisse", e);
        }
    }

    public void showMenu() {
        System.out.println("CaisseFrame.showMenu()");
        this.invalidate();
        this.setContentPane(new CaisseMenuPanel(this));
        this.validate();
        this.repaint();
    }

    public void showCaisse() {
        System.out.println("CaisseFrame.showCaisse()");
        this.invalidate();
        this.setContentPane(this.t);
        this.validate();
        this.repaint();
    }

    public void showTickets(Ticket t) {
        System.out.println("CaisseFrame.showMenu()");
        this.invalidate();
        ListeDesTicketsPanel panel = new ListeDesTicketsPanel(this);
        panel.setSelectedTicket(t);
        this.setContentPane(panel);
        this.validate();
        this.repaint();
    }
}

