/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.customerrelationship.customer.element.RelanceSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.payment.component.EncaisserMontantSQLComponent;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.core.sales.invoice.ui.ListPanelEcheancesClients;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.erp.rights.NXRights;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.IListener;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.EmailComposer;
import org.openconcerto.utils.GestionDevise;

public class ListeDesEcheancesClientsPanel
extends JPanel {
    private ListPanelEcheancesClients panelEcheances;
    private EditFrame editEncaisse = null;
    private EditFrame editRelance = null;
    private JButton relancer;
    private JButton encaisser;
    private SQLRow rowSource;
    SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMMM yyyy", Locale.ENGLISH);

    public ListeDesEcheancesClientsPanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.panelEcheances = new ListPanelEcheancesClients();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        this.add((Component)this.panelEcheances, c);
        IListTotalPanel totalPanel = new IListTotalPanel(this.panelEcheances.getListe(), Arrays.asList(this.panelEcheances.getElement().getTable().getField("MONTANT")));
        c.weighty = 0.0;
        ++c.gridy;
        c.anchor = 13;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)totalPanel, c);
        c.anchor = 17;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.weightx = 0.0;
        final JCheckBox checkRegCompta = new JCheckBox("Voir les r\u00e9gularisations de comptabilit\u00e9");
        if (UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.MENU)) {
            this.add((Component)checkRegCompta, c);
        }
        checkRegCompta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesEcheancesClientsPanel.this.panelEcheances.setShowRegCompta(checkRegCompta.isSelected());
            }
        });
        c.weightx = 1.0;
        c.anchor = 13;
        this.relancer = new JButton("Relancer");
        this.relancer.setHorizontalAlignment(4);
        if (UserManager.getInstance().getCurrentUser().getRights().haveRight(NXRights.GESTION_ENCAISSEMENT.getCode())) {
            ++c.gridx;
            this.add((Component)this.relancer, c);
            this.relancer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListeDesEcheancesClientsPanel.this.relanceClient();
                }
            });
        }
        this.encaisser = new JButton("Encaisser");
        this.encaisser.setHorizontalAlignment(4);
        ++c.gridx;
        c.weightx = 0.0;
        if (UserManager.getInstance().getCurrentUser().getRights().haveRight(NXRights.GESTION_ENCAISSEMENT.getCode())) {
            this.add((Component)this.encaisser, c);
        }
        this.encaisser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int answer;
                List<Integer> selectedIds = ListeDesEcheancesClientsPanel.this.panelEcheances.getListe().getSelection().getSelectedIDs();
                ArrayList<SQLRow> selectedRows = new ArrayList<SQLRow>(selectedIds.size());
                int idCpt = -1;
                int idClient = -1;
                boolean showMessage = false;
                String numeroFact = "";
                for (Integer integer : selectedIds) {
                    SQLRow row = ListeDesEcheancesClientsPanel.this.panelEcheances.getListe().getSource().getPrimaryTable().getRow(integer);
                    selectedRows.add(row);
                    String nom = row.getForeignRow("ID_MOUVEMENT").getForeignRow("ID_PIECE").getString("NOM");
                    numeroFact = String.valueOf(numeroFact) + " " + nom;
                    SQLRow rowClient = row.getForeignRow("ID_CLIENT");
                    int idTmp = rowClient.getInt("ID_COMPTE_PCE");
                    int idCliTmp = rowClient.getID();
                    if (idCpt > -1 && idCpt != idTmp) {
                        JOptionPane.showMessageDialog(null, "Impossible d'effectuer un encaissement sur plusieurs factures ayant des clients avec des comptes diff\u00e9rents.");
                        return;
                    }
                    idCpt = idTmp;
                    if (idClient > -1 && idClient != idCliTmp) {
                        showMessage = true;
                        continue;
                    }
                    idClient = idCliTmp;
                }
                if (showMessage && (answer = JOptionPane.showConfirmDialog(null, "Attention vous avez s\u00e9lectionn\u00e9 des factures ayant des clients diff\u00e9rents. Voulez vous continuer?")) != 0) {
                    return;
                }
                SQLElement encaisseElt = Configuration.getInstance().getDirectory().getElement("ENCAISSER_MONTANT");
                if (ListeDesEcheancesClientsPanel.this.editEncaisse == null) {
                    ListeDesEcheancesClientsPanel.this.editEncaisse = new EditFrame(encaisseElt);
                    ListeDesEcheancesClientsPanel.this.editEncaisse.setIconImages(Gestion.getFrameIcon());
                }
                SQLRowValues rowVals = new SQLRowValues(encaisseElt.getTable());
                rowVals.put("ID_CLIENT", idClient);
                rowVals.put("NOM", numeroFact);
                EncaisserMontantSQLComponent sqlComponent = (EncaisserMontantSQLComponent)ListeDesEcheancesClientsPanel.this.editEncaisse.getSQLComponent();
                sqlComponent.resetValue();
                sqlComponent.select(rowVals);
                sqlComponent.loadEcheancesFromRows(selectedRows);
                ListeDesEcheancesClientsPanel.this.editEncaisse.pack();
                ListeDesEcheancesClientsPanel.this.editEncaisse.setVisible(true);
            }
        });
        ++c.gridx;
        c.weightx = 0.0;
        JButton fermer = new JButton("fermer");
        this.add((Component)fermer, c);
        fermer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame tmpF = (JFrame)SwingUtilities.getRoot(ListeDesEcheancesClientsPanel.this);
                tmpF.setVisible(false);
                tmpF.dispose();
            }
        });
        this.panelEcheances.getJTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mE) {
                SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
                final SQLRow row = ListeDesEcheancesClientsPanel.this.panelEcheances.getListe().getSelectedRow();
                if (mE.getButton() == 1 && ListeDesEcheancesClientsPanel.this.editEncaisse != null) {
                    SQLRowValues rowVals = new SQLRowValues(base.getTable("ENCAISSER_MONTANT"));
                    rowVals.put("ID_ECHEANCE_CLIENT", row.getID());
                    ListeDesEcheancesClientsPanel.this.editEncaisse.getSQLComponent().select(rowVals);
                    ListeDesEcheancesClientsPanel.this.editEncaisse.pack();
                }
                if (mE.getButton() == 3) {
                    JPopupMenu menuDroit = new JPopupMenu();
                    menuDroit.add(new AbstractAction("Voir la source"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MouvementSQLElement.showSource(row.getInt("ID_MOUVEMENT"));
                        }
                    });
                    if (row != null) {
                        menuDroit.add(new AbstractAction("Envoyer un e-mail de relance"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ListeDesEcheancesClientsPanel.this.sendMail(row);
                            }
                        });
                    }
                    if (UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.MENU)) {
                        if (row.getBoolean("REG_COMPTA").booleanValue()) {
                            menuDroit.add(new AbstractAction("Annuler la r\u00e9gularisation en comptabilit\u00e9"){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    int answer = JOptionPane.showConfirmDialog(ListeDesEcheancesClientsPanel.this, "Etes vous s\u00fbr de vouloir annuler la r\u00e9gularisation ?");
                                    if (answer == 0) {
                                        SQLRowValues rowVals = row.createEmptyUpdateRow();
                                        rowVals.put("REG_COMPTA", Boolean.FALSE);
                                        try {
                                            rowVals.commit();
                                        }
                                        catch (SQLException e1) {
                                            e1.printStackTrace();
                                        }
                                    }
                                }
                            });
                        } else {
                            menuDroit.add(new AbstractAction("R\u00e9gularisation en comptabilit\u00e9"){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    int answer;
                                    String price = GestionDevise.currencyToString(row.getLong("MONTANT"));
                                    SQLRow rowClient = row.getForeignRow("ID_CLIENT");
                                    String nomClient = rowClient.getString("NOM");
                                    String piece = "";
                                    SQLRow rowMvt = row.getForeignRow("ID_MOUVEMENT");
                                    if (rowMvt != null) {
                                        SQLRow rowPiece = rowMvt.getForeignRow("ID_PIECE");
                                        piece = rowPiece.getString("NOM");
                                    }
                                    if ((answer = JOptionPane.showConfirmDialog(ListeDesEcheancesClientsPanel.this, "Etes vous s\u00fbr de vouloir r\u00e9gulariser l'\u00e9ch\u00e9ance de " + nomClient + " d'un montant de " + price + "\u20ac avec une saisie au kilometre?\nNom de la pi\u00e9ce : " + piece + ".")) == 0) {
                                        SQLRowValues rowVals = row.createEmptyUpdateRow();
                                        rowVals.put("REG_COMPTA", Boolean.TRUE);
                                        try {
                                            rowVals.commit();
                                        }
                                        catch (SQLException e1) {
                                            e1.printStackTrace();
                                        }
                                    }
                                }
                            });
                        }
                    }
                    menuDroit.show(mE.getComponent(), mE.getX(), mE.getY());
                }
            }
        });
        this.panelEcheances.getListe().addIListener(new IListener(){

            @Override
            public void selectionId(int id, int field) {
                if (id > 1) {
                    SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
                    SQLTable tableEch = base.getTable("ECHEANCE_CLIENT");
                    SQLRow rowEch = tableEch.getRow(id);
                    int idMvtSource = MouvementSQLElement.getSourceId(rowEch.getInt("ID_MOUVEMENT"));
                    SQLRow rowMvtSource = base.getTable("MOUVEMENT").getRow(idMvtSource);
                    if (!rowMvtSource.getString("SOURCE").equalsIgnoreCase("SAISIE_VENTE_FACTURE")) {
                        ListeDesEcheancesClientsPanel.this.relancer.setEnabled(false);
                    } else {
                        ListeDesEcheancesClientsPanel.this.relancer.setEnabled(true);
                    }
                    ListeDesEcheancesClientsPanel.this.encaisser.setEnabled(true);
                } else {
                    ListeDesEcheancesClientsPanel.this.relancer.setEnabled(false);
                    ListeDesEcheancesClientsPanel.this.encaisser.setEnabled(false);
                }
            }
        });
        this.relancer.setEnabled(false);
        this.encaisser.setEnabled(false);
    }

    private void relanceClient() {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLElement relanceElt = Configuration.getInstance().getDirectory().getElement("RELANCE");
        this.rowSource = this.panelEcheances.getListe().getSelectedRow();
        if (this.rowSource != null) {
            int idMvtSource = MouvementSQLElement.getSourceId(this.rowSource.getInt("ID_MOUVEMENT"));
            SQLRow rowMvtSource = base.getTable("MOUVEMENT").getRow(idMvtSource);
            if (!rowMvtSource.getString("SOURCE").equalsIgnoreCase("SAISIE_VENTE_FACTURE")) {
                this.relancer.setEnabled(false);
                return;
            }
            if (this.editRelance == null) {
                this.editRelance = new EditFrame(relanceElt);
                this.editRelance.setIconImages(Gestion.getFrameIcon());
                this.editRelance.addEditPanelListener(new EditPanelListener(){

                    @Override
                    public void cancelled() {
                    }

                    @Override
                    public void modified() {
                    }

                    @Override
                    public void deleted() {
                    }

                    @Override
                    public void inserted(int id) {
                        System.err.println("INSERTED " + id + " -- " + ListeDesEcheancesClientsPanel.this.rowSource.getID());
                        int nbRelance = ListeDesEcheancesClientsPanel.this.rowSource.getInt("NOMBRE_RELANCE");
                        SQLRowValues rowValsEch = new SQLRowValues(ListeDesEcheancesClientsPanel.this.rowSource.getTable());
                        rowValsEch.put("NOMBRE_RELANCE", ++nbRelance);
                        rowValsEch.put("DATE_LAST_RELANCE", new Date());
                        try {
                            rowValsEch.update(ListeDesEcheancesClientsPanel.this.rowSource.getID());
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                });
            }
            SQLRowValues rowVals = new SQLRowValues(relanceElt.getTable());
            rowVals.put("ID_SAISIE_VENTE_FACTURE", rowMvtSource.getInt("IDSOURCE"));
            rowVals.put("MONTANT", this.rowSource.getObject("MONTANT"));
            rowVals.put("ID_CLIENT", this.rowSource.getInt("ID_CLIENT"));
            rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(RelanceSQLElement.class, new Date()));
            this.editRelance.getSQLComponent().select(rowVals);
            this.editRelance.pack();
            this.editRelance.setVisible(true);
        } else {
            Thread.dumpStack();
        }
    }

    private void sendMail(SQLRow row) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLElement relanceElt = Configuration.getInstance().getDirectory().getElement("RELANCE");
        this.rowSource = this.panelEcheances.getListe().getSelectedRow();
        if (this.rowSource != null) {
            int idMvtSource = MouvementSQLElement.getSourceId(this.rowSource.getInt("ID_MOUVEMENT"));
            SQLRow rowMvtSource = base.getTable("MOUVEMENT").getRow(idMvtSource);
            if (!rowMvtSource.getString("SOURCE").equalsIgnoreCase("SAISIE_VENTE_FACTURE")) {
                this.relancer.setEnabled(false);
                return;
            }
            int idFact = rowMvtSource.getInt("IDSOURCE");
            SQLRow rowFacture = base.getTable("SAISIE_VENTE_FACTURE").getRow(idFact);
            Set<SQLField> setContact = null;
            SQLTable tableContact = Configuration.getInstance().getRoot().findTable("CONTACT");
            setContact = row.getTable().getForeignKeys(tableContact);
            Set<SQLField> setClient = null;
            SQLTable tableClient = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("CLIENT");
            setClient = row.getTable().getForeignKeys(tableClient);
            Long lTotal = (Long)rowFacture.getObject("T_TTC");
            Long lRestant = (Long)row.getObject("MONTANT");
            Long lVerse = new Long(lTotal - lRestant);
            Date dFacture = (Date)rowFacture.getObject("DATE");
            SQLRow modeRegRow = rowFacture.getForeignRow("ID_MODE_REGLEMENT");
            Date dateEch = ModeDeReglementSQLElement.calculDate(modeRegRow.getInt("AJOURS"), modeRegRow.getInt("LENJOUR"), dFacture);
            final String text = "Date: " + this.dateFormat.format(new Date()) + "\n" + "Concerning : Late Payment reminder\n" + "\n\n\nTo " + rowFacture.getForeign("ID_CLIENT").getString("NOM") + "," + "\n\n\nIt has come to our attention that the following invoice has not been paid to this day." + "\nInvoice # " + rowFacture.getString("NUMERO") + " from " + this.dateFormat.format(rowFacture.getDate("DATE").getTime()) + " of " + GestionDevise.currencyToString(lRestant, true) + " duedate " + this.dateFormat.format(dateEch) + ".\nWe assume that this is a mere oversight and we would appreciate it if you would settle this invoice as soon as possible. In the event that this has already been accomplished in the meantime, please ignore this notice." + "\n\n\nThanking you in advance.";
            String mail = "";
            for (SQLField field : setContact) {
                if (mail != null && mail.trim().length() != 0) continue;
                mail = row.getForeignRow(field.getName()).getString("EMAIL");
            }
            for (SQLField field : setClient) {
                SQLRow rowCli = row.getForeignRow(field.getName());
                if (mail != null && mail.trim().length() != 0) continue;
                mail = rowCli.getString("MAIL");
            }
            final String adresseMail = mail;
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        EmailComposer.getInstance().compose(adresseMail, "Late Payment reminder", text, new File[0]);
                    }
                    catch (IOException exn) {
                        exn.printStackTrace();
                    }
                    catch (InterruptedException exn) {
                        exn.printStackTrace();
                    }
                }
            };
            t.start();
        }
    }

    public IListPanel getListPanelEcheancesClients() {
        return this.panelEcheances;
    }
}

