/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.element;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.TreePath;
import org.openconcerto.erp.core.common.ui.SQLJavaEditor;
import org.openconcerto.erp.core.humanresources.payroll.component.FormuleTreeNode;
import org.openconcerto.erp.core.humanresources.payroll.component.RubriqueSQLComponent;
import org.openconcerto.erp.core.humanresources.payroll.component.VariableTree;
import org.openconcerto.erp.core.humanresources.payroll.element.SalarieSQLElement;
import org.openconcerto.erp.core.humanresources.payroll.element.VariablePayeSQLElement;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class RubriqueNetSQLElement
extends ConfSQLElement {
    public RubriqueNetSQLElement() {
        super("RUBRIQUE_NET", "une rubrique de net", "rubriques de net");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("BASE");
        l.add("TAUX");
        l.add("MONTANT");
        l.add("BRUT");
        l.add("FRAIS_PERS");
        l.add("IMPOSABLE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        return l;
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_PERIODE_VALIDITE");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new RubriqueSQLComponent(this){
            private SQLJavaEditor formuleBase;
            private SQLJavaEditor formuleTaux;
            private SQLJavaEditor formuleMontant;

            @Override
            protected void addViews(GridBagConstraints c) {
                JPanel panelCalcul = new JPanel();
                panelCalcul.setLayout(new GridBagLayout());
                DefaultGridBagConstraints cPanel = new DefaultGridBagConstraints();
                final VariableTree tree = new VariableTree();
                JScrollPane paneTree = new JScrollPane(tree);
                cPanel.gridheight = 0;
                cPanel.weighty = 1.0;
                cPanel.weightx = 1.0;
                cPanel.fill = 1;
                cPanel.fill = 2;
                cPanel.weighty = 0.0;
                cPanel.weightx = 0.0;
                cPanel.gridheight = 1;
                ++cPanel.gridx;
                Map<String, List<?>> mapTree = VariablePayeSQLElement.getMapTree();
                this.formuleBase = new SQLJavaEditor(mapTree);
                this.formuleBase.setVarAssign("BASE");
                final JRadioButton radioBase = new JRadioButton(this.getLabelFor("BASE"));
                panelCalcul.add((Component)radioBase, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)this.formuleBase, cPanel);
                JSeparator sep1 = new JSeparator();
                cPanel.gridwidth = 0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                panelCalcul.add((Component)sep1, cPanel);
                cPanel.gridwidth = 1;
                cPanel.weightx = 0.0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                this.formuleTaux = new SQLJavaEditor(mapTree);
                this.formuleTaux.setVarAssign("TAUX");
                JRadioButton radioTaux = new JRadioButton(this.getLabelFor("TAUX"));
                panelCalcul.add((Component)radioTaux, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)this.formuleTaux, cPanel);
                JSeparator sep2 = new JSeparator();
                cPanel.gridwidth = 0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                panelCalcul.add((Component)sep2, cPanel);
                cPanel.gridwidth = 1;
                cPanel.weightx = 0.0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                this.formuleMontant = new SQLJavaEditor(mapTree);
                this.formuleMontant.setVarAssign("MONTANT");
                final JRadioButton radioMontant = new JRadioButton(this.getLabelFor("MONTANT"));
                panelCalcul.add((Component)radioMontant, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)this.formuleMontant, cPanel);
                JSeparator sep3 = new JSeparator();
                cPanel.gridwidth = 0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                panelCalcul.add((Component)sep3, cPanel);
                cPanel.gridwidth = 1;
                cPanel.weightx = 0.0;
                ++cPanel.gridy;
                cPanel.gridx = 1;
                JLabel labelSelSal = new JLabel("Salari\u00e9");
                labelSelSal.setHorizontalAlignment(4);
                panelCalcul.add((Component)labelSelSal, cPanel);
                SalarieSQLElement eltSal = new SalarieSQLElement();
                final ElementComboBox selSalarie = new ElementComboBox(false);
                ++cPanel.gridx;
                selSalarie.init(eltSal);
                panelCalcul.add((Component)selSalarie, cPanel);
                ButtonGroup groupRadio = new ButtonGroup();
                groupRadio.add(radioBase);
                groupRadio.add(radioMontant);
                groupRadio.add(radioTaux);
                radioBase.setSelected(true);
                tree.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (e.getClickCount() == 2 && e.getButton() == 1) {
                            TreePath path = tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y);
                            Object obj = path.getLastPathComponent();
                            if (obj == null) {
                                return;
                            }
                            if (obj instanceof FormuleTreeNode) {
                                FormuleTreeNode n = (FormuleTreeNode)obj;
                                if (radioBase.isSelected()) {
                                    int start = formuleBase.getSelectionStart();
                                    String tmp = formuleBase.getText();
                                    formuleBase.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                } else if (radioMontant.isSelected()) {
                                    int start = formuleMontant.getSelectionStart();
                                    String tmp = formuleMontant.getText();
                                    formuleMontant.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                } else {
                                    int start = formuleTaux.getSelectionStart();
                                    String tmp = formuleTaux.getText();
                                    formuleTaux.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                }
                            }
                        }
                    }
                });
                JPanel panelProp = new JPanel();
                panelProp.setLayout(new GridBagLayout());
                cPanel.gridx = 0;
                cPanel.gridy = 0;
                cPanel.weightx = 0.0;
                cPanel.weighty = 0.0;
                cPanel.gridwidth = 1;
                cPanel.gridheight = 1;
                cPanel.fill = 2;
                cPanel.anchor = 18;
                cPanel.insets = new Insets(2, 2, 1, 2);
                this.addView("ID_PERIODE_VALIDITE", "required;notdecorated;noseparator");
                ElementSQLObject eltInfosPaye = (ElementSQLObject)this.getView("ID_PERIODE_VALIDITE");
                cPanel.gridy = 0;
                cPanel.gridx = 0;
                cPanel.gridheight = 0;
                cPanel.weighty = 1.0;
                cPanel.fill = 0;
                JPanel panelPeriodeVal = new JPanel();
                panelPeriodeVal.setBorder(BorderFactory.createTitledBorder("P\u00e9riode de validit\u00e9"));
                panelPeriodeVal.add(eltInfosPaye);
                panelProp.add((Component)panelPeriodeVal, cPanel);
                cPanel.weightx = 0.0;
                cPanel.weighty = 0.0;
                cPanel.gridheight = 1;
                cPanel.fill = 2;
                JLabel labelSelTypeRubrique = new JLabel("Type");
                labelSelTypeRubrique.setHorizontalAlignment(4);
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                cPanel.anchor = 17;
                panelProp.add((Component)labelSelTypeRubrique, cPanel);
                cPanel.anchor = 18;
                ElementComboBox comboSelType = new ElementComboBox(true, 20);
                ++cPanel.gridx;
                panelProp.add((Component)comboSelType, cPanel);
                JLabel labelSelTypeRubriqueImpression = new JLabel("Impression");
                labelSelTypeRubriqueImpression.setHorizontalAlignment(4);
                ++cPanel.gridx;
                cPanel.anchor = 17;
                panelProp.add((Component)labelSelTypeRubriqueImpression, cPanel);
                cPanel.anchor = 18;
                ElementComboBox comboSelTypeImpression = new ElementComboBox(true, 20);
                ++cPanel.gridx;
                c.fill = 0;
                c.weightx = 0.0;
                panelProp.add((Component)comboSelTypeImpression, cPanel);
                cPanel.gridx = 1;
                cPanel.weightx = 1.0;
                ++cPanel.gridy;
                c.fill = 2;
                cPanel.gridwidth = 0;
                JCheckBox checkImpo = new JCheckBox(this.getLabelFor("IMPOSABLE"));
                panelProp.add((Component)checkImpo, cPanel);
                ++cPanel.gridy;
                JCheckBox checkFraisPers = new JCheckBox(this.getLabelFor("FRAIS_PERS"));
                panelProp.add((Component)checkFraisPers, cPanel);
                ++cPanel.gridy;
                JCheckBox checkBrut = new JCheckBox(this.getLabelFor("BRUT"));
                panelProp.add((Component)checkBrut, cPanel);
                JTabbedPane tab = new JTabbedPane();
                tab.add("Calcul", new JSplitPane(1, paneTree, panelCalcul));
                tab.add("Propri\u00e9t\u00e9s", panelProp);
                c.gridwidth = 0;
                c.gridx = 0;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.add((Component)tab, c);
                this.addSQLObject(this.formuleBase, "BASE");
                this.addSQLObject(this.formuleTaux, "TAUX");
                this.addSQLObject(this.formuleMontant, "MONTANT");
                this.addSQLObject(checkBrut, "BRUT");
                this.addSQLObject(checkFraisPers, "FRAIS_PERS");
                this.addSQLObject(checkImpo, "IMPOSABLE");
                this.addRequiredSQLObject(comboSelTypeImpression, "ID_IMPRESSION_RUBRIQUE");
                this.addRequiredSQLObject(comboSelType, "ID_TYPE_RUBRIQUE_NET");
                comboSelType.setButtonsVisible(false);
                comboSelTypeImpression.setButtonsVisible(false);
                selSalarie.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        formuleBase.setSalarieID(selSalarie.getSelectedId());
                        formuleTaux.setSalarieID(selSalarie.getSelectedId());
                        formuleMontant.setSalarieID(selSalarie.getSelectedId());
                    }
                });
            }
        };
    }

    @Override
    protected String createCode() {
        return "humanresources.payroll.category";
    }
}

