/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.payment.ui.GestionChequesRenderer;
import org.openconcerto.erp.model.GestionChequesModel;
import org.openconcerto.erp.rights.ComptaTotalUserRight;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.openoffice.XMLFormatVersion;
import org.openconcerto.openoffice.spreadsheet.SpreadSheet;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.table.ViewTableModel;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.TableModelSelectionAdapter;
import org.openconcerto.utils.TableSorter;

public class ListeDesChequesAEncaisserPanel
extends JPanel {
    private GestionChequesModel model;
    private JLabel labelDepot = new JLabel("S\u00e9lectionner les ch\u00e9ques \u00e0 d\u00e9poser, en date du ");
    private JDate dateDepot = new JDate();
    private JLabel labelMontant = new JLabel("");
    private JTable table;
    private TableSorter s;
    private EditFrame edit = null;
    private final JCheckBox checkImpression = new JCheckBox("Impression du relev\u00e9");
    private final JButton boutonValide = new JButton("Valider le d\u00e9p\u00f4t");

    public ListeDesChequesAEncaisserPanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        SQLTable tableChequeClient = Configuration.getInstance().getDirectory().getElement("CHEQUE_A_ENCAISSER").getTable();
        SQLTable tableClient = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("CLIENT");
        ArrayList<FieldRef> fields = new ArrayList<FieldRef>();
        fields.add(tableChequeClient.getField("ETS"));
        fields.add(tableChequeClient.getField("NUMERO"));
        fields.add(tableChequeClient.getField("DATE"));
        fields.add(tableChequeClient.getField("ID_MOUVEMENT"));
        fields.add(tableChequeClient.getField("DATE_VENTE"));
        fields.add(tableChequeClient.getField("DATE_MIN_DEPOT"));
        fields.add(tableClient.getField("FORME_JURIDIQUE"));
        fields.add(tableClient.getField("NOM"));
        fields.add(tableChequeClient.getField("MONTANT"));
        fields.add(tableChequeClient.getField("ENCAISSE"));
        this.model = new GestionChequesModel(tableChequeClient, fields, tableChequeClient.getField("ENCAISSE"), tableChequeClient.getField("DATE_MIN_DEPOT"));
        this.s = new TableSorter(this.model);
        this.table = new JTable(this.s);
        this.s.setTableHeader(this.table.getTableHeader());
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ListeDesChequesAEncaisserPanel.this.setLabels();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    ListeDesChequesAEncaisserPanel.this.actionDroitTable(e);
                }
            }
        });
        this.model.selectionDecaisseAll();
        this.table.getColumnModel().getColumn(5).setCellRenderer(new GestionChequesRenderer(this.s));
        this.table.getColumnModel().getColumn(8).setCellRenderer(new GestionChequesRenderer(this.s));
        this.add((Component)new JScrollPane(this.table), c);
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridx = 0;
        this.dateDepot.setValue(new Date());
        ++c.gridy;
        c.gridwidth = 1;
        this.add((Component)this.labelDepot, c);
        ++c.gridx;
        c.fill = 0;
        this.add((Component)this.dateDepot, c);
        c.gridwidth = 1;
        ++c.gridx;
        this.add((Component)this.labelMontant, c);
        JPanel panelButton = new JPanel();
        JButton boutonSelectAll = new JButton("S\u00e9lectionner tous les ch\u00e8ques");
        boutonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesChequesAEncaisserPanel.this.model.selectionDecaisseAll();
            }
        });
        JButton printPreview = new JButton("Aper\u00e7u du relev\u00e9");
        printPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesChequesAEncaisserPanel.this.model.printPreview(2);
            }
        });
        panelButton.add(printPreview);
        panelButton.add(boutonSelectAll);
        ++c.gridx;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 13;
        this.add((Component)panelButton, c);
        c.anchor = 17;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.add((Component)this.checkImpression, c);
        JLabelBold labelLib = new JLabelBold("Libell\u00e9 des \u00e9critures");
        ++c.gridx;
        c.gridwidth = 1;
        c.fill = 0;
        this.add((Component)labelLib, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        final JTextField text = new JTextField();
        c.gridwidth = 2;
        this.add((Component)text, c);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.gridx += 2;
        JButton buttonExport = new JButton(new ImageIcon(IListPanel.class.getResource("save.png")));
        buttonExport.setFocusPainted(false);
        buttonExport.setOpaque(false);
        buttonExport.setContentAreaFilled(false);
        buttonExport.setBorderPainted(false);
        buttonExport.setPreferredSize(new Dimension(20, 20));
        buttonExport.setMaximumSize(new Dimension(20, 20));
        this.add((Component)buttonExport, c);
        buttonExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File f = new File(Configuration.getInstance().getWD(), "ChequeAEncaisser.sxc");
                    Object[] options = new Object[]{"Tout", "Selection", "Annuler"};
                    int answer = JOptionPane.showOptionDialog(ListeDesChequesAEncaisserPanel.this, "Exporter l'ensemble ou uniquement la s\u00e9lection de la liste?", "Export de la liste", 1, -1, null, options, "Tout");
                    if (answer == 1) {
                        SpreadSheet.export(ListeDesChequesAEncaisserPanel.this.getExportModel(true), f, XMLFormatVersion.getDefault());
                    } else if (answer == 0) {
                        SpreadSheet.export(ListeDesChequesAEncaisserPanel.this.getExportModel(false), f, XMLFormatVersion.getDefault());
                    } else {
                        return;
                    }
                    int i = JOptionPane.showConfirmDialog(ListeDesChequesAEncaisserPanel.this, "La liste est export\u00e9e au format OpenOffice classeur\n D\u00e9sirez vous l'ouvrir avec OpenOffice?", "Ouvir le fichier", 0);
                    if (i == 0) {
                        OOUtils.open(f);
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.handle(ListeDesChequesAEncaisserPanel.this, "Erreur lors de la sauvegarde", ex);
                }
            }
        });
        JPanel panelButtonValidClose = new JPanel();
        this.checkImpression.setSelected(true);
        this.boutonValide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = text.getText();
                ListeDesChequesAEncaisserPanel.this.model.valideDepot(ListeDesChequesAEncaisserPanel.this.dateDepot.getDate(), 2, ListeDesChequesAEncaisserPanel.this.checkImpression.isSelected(), s);
                text.setText("");
            }
        });
        JButton buttonFermer = new JButton("Fermer");
        panelButtonValidClose.add(this.boutonValide);
        panelButtonValidClose.add(buttonFermer);
        c.gridx += 2;
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.add((Component)panelButtonValidClose, c);
        buttonFermer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFrame frame = (JFrame)SwingUtilities.getRoot(ListeDesChequesAEncaisserPanel.this);
                frame.setVisible(false);
                frame.dispose();
            }
        });
    }

    private TableModel getExportModel(boolean selection) {
        return new TableModelSelectionAdapter(new ViewTableModel(this.table), selection ? this.table.getSelectedRows() : null){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object value = super.getValueAt(rowIndex, columnIndex);
                if (value instanceof Long || value instanceof BigInteger) {
                    return new Double((double)((Number)value).longValue() / 100.0);
                }
                return value;
            }
        };
    }

    public GestionChequesModel getModel() {
        return this.model;
    }

    private void actionDroitTable(MouseEvent mE) {
        JPopupMenu menuDroit = new JPopupMenu();
        final int row = this.table.getSelectedRow();
        final SQLElement chequeElt = Configuration.getInstance().getDirectory().getElement("CHEQUE_A_ENCAISSER");
        AbstractAction actionSource = new AbstractAction("Voir la source"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (row >= 0 && row < ListeDesChequesAEncaisserPanel.this.table.getRowCount()) {
                    SQLRow rowCheque = chequeElt.getTable().getRow(ListeDesChequesAEncaisserPanel.this.model.getIdAtRow(ListeDesChequesAEncaisserPanel.this.s.modelIndex(row)));
                    int idMouvement = rowCheque.getInt("ID_MOUVEMENT");
                    if (idMouvement > 1) {
                        MouvementSQLElement.showSource(idMouvement);
                    } else {
                        if (ListeDesChequesAEncaisserPanel.this.edit == null) {
                            ListeDesChequesAEncaisserPanel.this.edit = new EditFrame(chequeElt, EditFrame.MODIFICATION);
                            ListeDesChequesAEncaisserPanel.this.edit.pack();
                        }
                        ListeDesChequesAEncaisserPanel.this.edit.selectionId(rowCheque.getID());
                        ListeDesChequesAEncaisserPanel.this.edit.setVisible(true);
                    }
                }
            }
        };
        actionSource.setEnabled(row >= 0 && row < this.table.getRowCount());
        menuDroit.add(actionSource);
        menuDroit.add(new AbstractAction("S\u00e9lectionner tout"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesChequesAEncaisserPanel.this.model.selectionDecaisseAll();
            }
        });
        menuDroit.add(new AbstractAction("D\u00e9s\u00e9lectionner tout"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesChequesAEncaisserPanel.this.model.deselectionAll();
            }
        });
        if (UserManager.getInstance().getCurrentUser().getRights().haveRight(ComptaTotalUserRight.TOTAL)) {
            menuDroit.add(new AbstractAction("R\u00e9gularisation en comptabilit\u00e9"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int answer;
                    SQLRow rowCheque = chequeElt.getTable().getRow(ListeDesChequesAEncaisserPanel.this.model.getIdAtRow(ListeDesChequesAEncaisserPanel.this.s.modelIndex(row)));
                    String price = GestionDevise.currencyToString(rowCheque.getLong("MONTANT"));
                    SQLRow rowClient = rowCheque.getForeignRow("ID_CLIENT");
                    String nomClient = rowClient.getString("NOM");
                    String piece = "";
                    SQLRow rowMvt = rowCheque.getForeignRow("ID_MOUVEMENT");
                    if (rowMvt != null) {
                        SQLRow rowPiece = rowMvt.getForeignRow("ID_PIECE");
                        piece = rowPiece.getString("NOM");
                    }
                    if ((answer = JOptionPane.showConfirmDialog(ListeDesChequesAEncaisserPanel.this, "Etes vous s\u00fbr de vouloir r\u00e9gulariser ce cheque de " + nomClient + " d'un montant de " + price + "\u20ac avec une saisie au kilometre?\nNom de la pi\u00e9ce : " + piece + "\nAttention, cette op\u00e9ration est irr\u00e9versible.")) == 0) {
                        SQLRowValues rowVals = rowCheque.asRowValues();
                        rowVals.put("REG_COMPTA", Boolean.TRUE);
                        try {
                            rowVals.commit();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
        }
        menuDroit.show(mE.getComponent(), mE.getX(), mE.getY());
    }

    private void setLabels() {
        int nbChq = this.model.getNbChequeSelected();
        if (nbChq == 0) {
            this.labelDepot.setText("S\u00e9lectionner les ch\u00e9ques \u00e0 d\u00e9poser, en date du ");
            this.labelMontant.setText("");
            this.boutonValide.setVisible(false);
            this.checkImpression.setVisible(false);
        } else {
            long montantTot = this.model.getMontantTotalSelected();
            this.boutonValide.setVisible(true);
            this.checkImpression.setVisible(true);
            if (nbChq == 1) {
                this.labelDepot.setText("D\u00e9pot de " + nbChq + " ch\u00e9que, en date du ");
                this.labelMontant.setText(", pour un montant total de " + GestionDevise.currencyToString(montantTot) + " \u20ac");
            } else {
                this.labelDepot.setText("D\u00e9pot de " + nbChq + " ch\u00e9ques, en date du ");
                this.labelMontant.setText(", pour un montant total de " + GestionDevise.currencyToString(montantTot) + " \u20ac");
            }
        }
    }
}

