/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.ui;

import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.erp.model.GestionChequesModel;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.TableSorter;

public class GestionChequesRenderer
extends DefaultTableCellRenderer {
    private static final Color couleurChequeValide = new Color(255, 128, 64);
    private static final DateFormat dateFormat = DateFormat.getDateInstance(2, Locale.FRENCH);
    private static final NumberFormat numberFormat = new DecimalFormat("0.00");
    private GestionChequesModel model;
    private TableSorter s;

    public GestionChequesRenderer(TableSorter s) {
        this.s = s;
        this.model = (GestionChequesModel)s.getTableModel();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!isSelected) {
            if (value instanceof Double) {
                float f = ((Double)value).floatValue();
                this.setText(numberFormat.format(f));
                this.setHorizontalAlignment(4);
            }
            if (value instanceof Date) {
                if (!this.model.getDateMinimum(this.s.modelIndex(row)).after(new Date())) {
                    this.setForeground(couleurChequeValide);
                } else {
                    this.setForeground(Color.BLACK);
                }
                this.setText(dateFormat.format((Date)value));
            }
        } else {
            if (value instanceof Double) {
                float f = ((Double)value).floatValue();
                this.setText(numberFormat.format(f));
                this.setHorizontalAlignment(4);
            }
            if (value instanceof Date) {
                this.setText(dateFormat.format((Date)value));
            }
        }
        if (value != null && value.getClass() == Long.class) {
            this.setText(GestionDevise.currencyToString((Long)value));
        }
        return this;
    }
}

