/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationReglementAchat;
import org.openconcerto.erp.preferences.ModeReglementDefautPrefPanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.checks.ValidState;

public class ReglerMontantSQLElement
extends ComptaSQLConfElement {
    public ReglerMontantSQLElement() {
        super("REGLER_MONTANT", "un r\u00e8glement \u00e0 un fournisseur", "r\u00e8glements aux fournisseurs");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("ID_ECHEANCE_FOURNISSEUR");
        l.add("ID_MODE_REGLEMENT");
        l.add("MONTANT");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("MONTANT");
        return l;
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_MODE_REGLEMENT");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            SQLElement eltEch;
            Where wRegle;
            private ElementComboBox comboEcheance;
            private DeviseField montant;
            private JDate date;
            private JLabel labelWarning;
            private JLabel labelWarningText;
            {
                this.eltEch = Configuration.getInstance().getDirectory().getElement("ECHEANCE_FOURNISSEUR");
                this.wRegle = new Where((FieldRef)this.eltEch.getTable().getField("REGLE"), "=", (Object)Boolean.FALSE);
                this.comboEcheance = new ElementComboBox(true, 25);
                this.montant = new DeviseField();
                this.labelWarning = new JLabelWarning();
                this.labelWarningText = new JLabel("Le montant n'est pas valide!");
            }

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                this.add((Component)new JLabel("Echeance"), c);
                ++c.gridx;
                c.weightx = 0.0;
                c.gridwidth = 3;
                this.add((Component)this.comboEcheance, c);
                this.date = new JDate(true);
                c.gridx = -1;
                c.weightx = 0.0;
                c.gridwidth = 1;
                this.add((Component)new JLabel("Date"), c);
                c.weightx = 1.0;
                this.add((Component)this.date, c);
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                this.add((Component)new JLabel("Montant r\u00e9gl\u00e9"), c);
                ++c.gridx;
                c.weightx = 0.0;
                this.add((Component)this.montant, c);
                ++c.gridx;
                this.labelWarning.setHorizontalAlignment(4);
                this.add((Component)this.labelWarning, c);
                ++c.gridx;
                c.gridwidth = 0;
                this.add((Component)this.labelWarningText, c);
                this.montant.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.fireValidChange();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.fireValidChange();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.fireValidChange();
                    }
                });
                c.gridwidth = 0;
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 1.0;
                TitledSeparator sep = new TitledSeparator("Mode de r\u00e8glement");
                c.insets = new Insets(10, 2, 1, 2);
                this.add((Component)sep, c);
                c.insets = new Insets(2, 2, 1, 2);
                c.gridx = 0;
                ++c.gridy;
                c.gridwidth = 0;
                this.addView("ID_MODE_REGLEMENT", "required;notdecorated;noseparator");
                final ElementSQLObject eltModeRegl = (ElementSQLObject)this.getView("ID_MODE_REGLEMENT");
                this.add((Component)eltModeRegl, c);
                this.addRequiredSQLObject(this.date, "DATE");
                this.addRequiredSQLObject(this.montant, "MONTANT");
                this.addRequiredSQLObject(this.comboEcheance, "ID_ECHEANCE_FOURNISSEUR");
                this.comboEcheance.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        int idEch = comboEcheance.getSelectedId();
                        if (idEch > 1) {
                            System.err.println("ID_ECH :::: " + idEch);
                            SQLRow echRow = this.getTable().getBase().getTable("ECHEANCE_FOURNISSEUR").getRow(idEch);
                            montant.setText(GestionDevise.currencyToString((Long)echRow.getObject("MONTANT")));
                            int idScr = MouvementSQLElement.getSourceId(echRow.getInt("ID_MOUVEMENT"));
                            SQLTable tableMvt = Configuration.getInstance().getDirectory().getElement("MOUVEMENT").getTable();
                            if (idScr > 1) {
                                SQLRow rowModeRegl;
                                SQLRow rowSource;
                                SQLRow rowMvt = tableMvt.getRow(idScr);
                                String source = rowMvt.getString("SOURCE");
                                int idSource = rowMvt.getInt("IDSOURCE");
                                SQLElement eltSource = Configuration.getInstance().getDirectory().getElement(source);
                                if (eltSource != null && (rowSource = eltSource.getTable().getRow(idSource)) != null && (rowModeRegl = rowSource.getForeignRow("ID_MODE_REGLEMENT")) != null) {
                                    int idTypeRegl = rowModeRegl.getInt("ID_TYPE_REGLEMENT");
                                    SQLTable tableModeRegl = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT").getTable();
                                    SQLRowValues rowVals = new SQLRowValues(tableModeRegl);
                                    rowVals.put("ID_TYPE_REGLEMENT", idTypeRegl);
                                    rowVals.put("COMPTANT", Boolean.TRUE);
                                    rowVals.put("AJOURS", 0);
                                    rowVals.put("LENJOUR", 0);
                                    eltModeRegl.setValue(rowVals);
                                }
                            }
                        } else {
                            montant.setText(String.valueOf("0.00"));
                        }
                    }
                });
                this.comboEcheance.getRequest().setWhere(this.wRegle);
                this.comboEcheance.fillCombo();
            }

            @Override
            public int insert(SQLRow order) {
                int id = super.insert(order);
                System.out.println("G\u00e9n\u00e9ration des ecritures du reglement");
                new GenerationReglementAchat(id);
                SQLTable tableEch = this.getTable().getBase().getTable("ECHEANCE_FOURNISSEUR");
                SQLRow row = ReglerMontantSQLElement.this.getTable().getRow(id);
                int idEchFourn = row.getInt("ID_ECHEANCE_FOURNISSEUR");
                System.out.println("ID ECHEANCE FOURNISSEUR" + idEchFourn);
                if (idEchFourn > 1) {
                    SQLRow rowEch = tableEch.getRow(idEchFourn);
                    System.out.println("Mise \u00e0 jour du montant de l'\u00e9ch\u00e9ance");
                    long montant = (Long)row.getObject("MONTANT");
                    SQLRowValues rowVals = rowEch.createEmptyUpdateRow();
                    if (montant == (Long)rowEch.getObject("MONTANT")) {
                        rowVals.put("REGLE", Boolean.TRUE);
                    } else {
                        rowVals.put("MONTANT", new Long((Long)rowEch.getObject("MONTANT") - montant));
                    }
                    try {
                        rowVals.commit();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                return id;
            }

            @Override
            public synchronized ValidState getValidState() {
                return super.getValidState().and(ValidState.createCached(this.montantIsValidated(), "Le montant est n\u00e9gatif ou sup\u00e9rieur \u00e0 l'\u00e9ch\u00e9ance"));
            }

            @Override
            protected SQLRowValues createDefaults() {
                SQLRowValues vals = new SQLRowValues(this.getTable());
                try {
                    SQLRow r = ModeReglementDefautPrefPanel.getDefaultRow(false);
                    SQLElement eltModeReglement = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
                    if (((SQLRowAccessor)r).getID() > 1) {
                        SQLRowValues rowVals = eltModeReglement.createCopy(((SQLRowAccessor)r).getID());
                        System.err.println(rowVals.getInt("ID_TYPE_REGLEMENT"));
                        vals.put("ID_MODE_REGLEMENT", rowVals);
                    }
                }
                catch (SQLException e) {
                    System.err.println("Impossible de s\u00e9lectionner le mode de r\u00e8glement par d\u00e9faut du client.");
                    e.printStackTrace();
                }
                return vals;
            }

            public boolean montantIsValidated() {
                long montantValue;
                SQLRow echRow = this.comboEcheance.getSelectedRow();
                boolean res = echRow == null ? true : (montantValue = GestionDevise.parseLongCurrency(this.montant.getText().trim())) > 0L && montantValue <= echRow.getLong("MONTANT");
                this.labelWarning.setVisible(!res);
                this.labelWarningText.setVisible(!res);
                return res;
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".regulation";
    }
}

