/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.element;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.payment.component.ModeDeReglementSQLComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.ListSQLRequest;

public class ModeDeReglementSQLElement
extends ComptaSQLConfElement {
    public ModeDeReglementSQLElement() {
        super("MODE_REGLEMENT", "un mode de r\u00e8glement", "modes de r\u00e8glement");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("CODE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("CODE");
        return l;
    }

    @Override
    public synchronized ListSQLRequest createListRequest() {
        return new ListSQLRequest(this.getTable(), this.getListFields()){

            @Override
            protected void customizeToFetch(SQLRowValues graphToFetch) {
                super.customizeToFetch(graphToFetch);
                graphToFetch.put("AJOURS", null);
                graphToFetch.put("LENJOUR", null);
            }
        };
    }

    @Override
    public SQLComponent createComponent() {
        return new ModeDeReglementSQLComponent(this);
    }

    public static final Date calculDate(SQLRowAccessor rowMdr, Date currentDate) {
        return ModeDeReglementSQLElement.calculDate(rowMdr.getInt("AJOURS"), rowMdr.getInt("LENJOUR"), currentDate);
    }

    public static final Date calculDate(int aJ, int nJ, Date currentDate) {
        if (aJ == 0 && nJ == 0) {
            return currentDate;
        }
        Calendar cal = Calendar.getInstance();
        ComptaPropsConfiguration conf = (ComptaPropsConfiguration)Configuration.getInstance();
        cal.setTime(currentDate);
        cal.set(5, cal.get(5) + aJ);
        if (nJ > 0) {
            int maxDay = cal.getActualMaximum(5);
            if (nJ > maxDay) {
                nJ = maxDay;
            }
            if (nJ < cal.get(5)) {
                cal.add(2, 1);
            }
            if (nJ > (maxDay = cal.getActualMaximum(5))) {
                nJ = maxDay;
            }
            cal.set(5, nJ);
        }
        return cal.getTime();
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeFromPackage()) + ".mode";
    }
}

