/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.model.SelectJournauxModel;
import org.openconcerto.erp.core.finance.accounting.report.GrandLivreSheet;
import org.openconcerto.erp.core.finance.accounting.report.JournauxMoisSheet;
import org.openconcerto.erp.core.finance.accounting.report.JournauxSheet;
import org.openconcerto.erp.generationDoc.SpreadSheetGeneratorCompta;
import org.openconcerto.erp.generationDoc.SpreadSheetGeneratorListener;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class ImpressionJournauxPanel
extends JPanel
implements SpreadSheetGeneratorListener {
    private final JDate dateDeb;
    private final JDate dateEnd;
    private JTable tableJrnl;
    private JButton valid;
    private JButton annul;
    private JCheckBox checkImpr;
    private JCheckBox checkVisu;
    private JCheckBox checkCentralMois;
    private JTextField compteDeb;
    private JTextField compteEnd;
    private int mode = GrandLivreSheet.MODEALL;
    private JProgressBar bar = new JProgressBar(0, 3);

    public ImpressionJournauxPanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        SQLRow rowExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON").getRow(rowSociete.getInt("ID_EXERCICE_COMMON"));
        this.dateDeb = new JDate();
        this.dateEnd = new JDate();
        this.tableJrnl = new JTable(new SelectJournauxModel());
        this.add((Component)new JLabel("P\u00e9riode du"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.dateDeb, c);
        String valueDateDeb = DefaultNXProps.getInstance().getStringProperty("JournauxDateDeb");
        if (valueDateDeb.trim().length() > 0) {
            Long l = new Long(valueDateDeb);
            this.dateDeb.setValue(new Date(l));
        } else {
            this.dateDeb.setValue((Date)rowExercice.getObject("DATE_DEB"));
        }
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Au"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.dateEnd, c);
        String valueDateEnd = DefaultNXProps.getInstance().getStringProperty("JournauxDateEnd");
        if (valueDateEnd.trim().length() > 0) {
            Long l = new Long(valueDateEnd);
            this.dateEnd.setValue(new Date(l));
        } else {
            this.dateEnd.setValue((Date)rowExercice.getObject("DATE_FIN"));
        }
        this.compteDeb = new JTextField();
        this.compteEnd = new JTextField();
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Du compte "), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.compteDeb, c);
        this.compteDeb.setText("1");
        this.compteEnd.setText("9");
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Au"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.compteEnd, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        this.add((Component)new TitledSeparator("S\u00e9lection des journaux"), c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        JScrollPane scroll = new JScrollPane(this.tableJrnl);
        Dimension d = this.tableJrnl.getPreferredSize().height > 200 ? new Dimension(scroll.getPreferredSize().width, 200) : new Dimension(scroll.getPreferredSize().width, this.tableJrnl.getPreferredSize().height + 30);
        scroll.setPreferredSize(d);
        this.add((Component)scroll, c);
        this.valid = new JButton("Valider");
        this.annul = new JButton("Fermer");
        this.checkImpr = new JCheckBox("Impression");
        this.checkVisu = new JCheckBox("Visualisation");
        JRadioButton radioAll = new JRadioButton(new AbstractAction("Toutes"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpressionJournauxPanel.this.mode = GrandLivreSheet.MODEALL;
            }
        });
        JRadioButton radioLettree = new JRadioButton(new AbstractAction("Lettr\u00e9es"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpressionJournauxPanel.this.mode = GrandLivreSheet.MODELETTREE;
            }
        });
        JRadioButton radioNonLettree = new JRadioButton(new AbstractAction("Non lettr\u00e9es"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpressionJournauxPanel.this.mode = GrandLivreSheet.MODENONLETTREE;
            }
        });
        JPanel panelMode = new JPanel();
        panelMode.add(radioAll);
        panelMode.add(radioLettree);
        panelMode.add(radioNonLettree);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.weighty = 0.0;
        c.fill = 0;
        ButtonGroup group = new ButtonGroup();
        group.add(radioAll);
        group.add(radioLettree);
        group.add(radioNonLettree);
        radioAll.setSelected(true);
        panelMode.setBorder(BorderFactory.createTitledBorder("Ecritures"));
        this.add((Component)panelMode, c);
        this.checkCentralMois = new JCheckBox("Centralisation par mois");
        c.gridx += 2;
        c.gridwidth = 0;
        this.add((Component)this.checkCentralMois, c);
        c.gridwidth = 0;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        this.bar.setStringPainted(true);
        this.add((Component)this.bar, c);
        c.gridwidth = 2;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.add((Component)this.checkImpr, c);
        this.checkImpr.setSelected(true);
        c.gridx += 2;
        this.add((Component)this.checkVisu, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.anchor = 10;
        this.add((Component)this.valid, c);
        c.gridx += 2;
        this.add((Component)this.annul, c);
        this.checkValidity();
        this.valid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpressionJournauxPanel.this.bar.setString(null);
                ImpressionJournauxPanel.this.bar.setValue(1);
                ImpressionJournauxPanel.this.valid.setEnabled(false);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int[] idS = ((SelectJournauxModel)ImpressionJournauxPanel.this.tableJrnl.getModel()).getSelectedIds(ImpressionJournauxPanel.this.tableJrnl.getSelectedRows());
                        JournauxSheet bSheet = ImpressionJournauxPanel.this.checkCentralMois.isSelected() ? new JournauxMoisSheet(idS, ImpressionJournauxPanel.this.dateDeb.getDate(), ImpressionJournauxPanel.this.dateEnd.getDate(), ImpressionJournauxPanel.this.mode) : new JournauxSheet(idS, ImpressionJournauxPanel.this.dateDeb.getDate(), ImpressionJournauxPanel.this.dateEnd.getDate(), ImpressionJournauxPanel.this.mode, ImpressionJournauxPanel.this.compteDeb.getText().trim(), ImpressionJournauxPanel.this.compteEnd.getText().trim());
                        final SpreadSheetGeneratorCompta generator = new SpreadSheetGeneratorCompta(bSheet, "Journal_" + Calendar.getInstance().getTimeInMillis(), ImpressionJournauxPanel.this.checkImpr.isSelected(), ImpressionJournauxPanel.this.checkVisu.isSelected());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ImpressionJournauxPanel.this.bar.setValue(2);
                                generator.addGenerateListener(ImpressionJournauxPanel.this);
                            }
                        });
                    }
                }).start();
            }
        });
        this.annul.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(ImpressionJournauxPanel.this)).dispose();
            }
        });
        this.dateDeb.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ImpressionJournauxPanel.this.checkValidity();
                ImpressionJournauxPanel.this.storeValue();
            }
        });
        this.dateEnd.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ImpressionJournauxPanel.this.checkValidity();
                ImpressionJournauxPanel.this.storeValue();
            }
        });
        this.tableJrnl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ImpressionJournauxPanel.this.checkValidity();
            }
        });
        this.tableJrnl.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ImpressionJournauxPanel.this.checkValidity();
            }
        });
        SimpleDocumentListener doc = new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                ImpressionJournauxPanel.this.checkValidity();
            }
        };
        this.compteDeb.getDocument().addDocumentListener(doc);
        this.compteDeb.setText("1");
        this.compteEnd.getDocument().addDocumentListener(doc);
        this.compteEnd.setText("8");
    }

    private void checkValidity() {
        Date beginDate = this.dateDeb.getDate();
        Date endDate = this.dateEnd.getDate();
        if (beginDate == null || endDate == null) {
            this.valid.setEnabled(false);
        } else if (beginDate.after(endDate)) {
            this.valid.setEnabled(false);
        } else if (this.tableJrnl.getSelectedRows().length == 0) {
            this.valid.setEnabled(false);
        } else {
            this.valid.setEnabled(true);
        }
        if (this.compteDeb.getText().trim().length() == 0 || this.compteEnd.getText().trim().length() == 0) {
            this.valid.setEnabled(false);
        } else if (this.compteDeb.getText().trim().compareToIgnoreCase(this.compteEnd.getText().trim()) > 0) {
            this.valid.setEnabled(false);
        } else if (beginDate.after(endDate)) {
            this.valid.setEnabled(false);
        }
    }

    private void storeValue() {
        Date dFin;
        Date d = this.dateDeb.getDate();
        if (d != null) {
            DefaultNXProps.getInstance().setProperty("JournauxDateDeb", String.valueOf(d.getTime()));
        }
        if ((dFin = this.dateEnd.getDate()) != null) {
            DefaultNXProps.getInstance().setProperty("JournauxDateEnd", String.valueOf(dFin.getTime()));
        }
        DefaultNXProps.getInstance().store();
    }

    @Override
    public void taskEnd() {
        this.bar.setValue(3);
        this.bar.setString("Termin\u00e9e");
        this.valid.setEnabled(true);
    }
}

