/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.element.MoisSQLElement;
import org.openconcerto.erp.core.finance.accounting.model.EtatChargeModel;
import org.openconcerto.erp.core.finance.accounting.ui.EtatChargeRenderer;
import org.openconcerto.erp.core.humanresources.payroll.element.CaisseCotisationSQLElement;
import org.openconcerto.erp.core.humanresources.payroll.report.EtatChargesPayeSheet;
import org.openconcerto.erp.generationDoc.SpreadSheetGeneratorCompta;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.state.JTableStateManager;

public class EtatChargePanel
extends JPanel {
    private ElementComboBox selMoisDu;
    private ElementComboBox selMoisAu;
    private JTextField textAnnee;
    private EtatChargeModel[] model;
    private static final NumberFormat numberFormat = new DecimalFormat("0.00");
    private static final SQLTable tableCaisse = Configuration.getInstance().getBase().getTable("CAISSE_COTISATION");

    public EtatChargePanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        MoisSQLElement eltMois = new MoisSQLElement();
        this.selMoisDu = new ElementComboBox(false, 15);
        this.selMoisDu.init(eltMois);
        this.selMoisDu.setButtonsVisible(false);
        this.selMoisAu = new ElementComboBox(false, 15);
        this.selMoisAu.init(eltMois);
        this.selMoisAu.setButtonsVisible(false);
        JLabel labelAnnee = new JLabel("Ann\u00e9e");
        this.textAnnee = new JTextField(5);
        JLabel labelMoisDu = new JLabel("De");
        JLabel labelMoisAu = new JLabel("\u00e0");
        JPanel pDate = new JPanel();
        pDate.setBorder(BorderFactory.createTitledBorder("P\u00e9riode"));
        pDate.setOpaque(false);
        pDate.add(labelMoisDu);
        pDate.add(this.selMoisDu);
        this.selMoisDu.setValue(DefaultNXProps.getInstance().getIntProperty("EtatChargeSelMoisDu"));
        pDate.add(labelMoisAu);
        pDate.add(this.selMoisAu);
        int intProperty = DefaultNXProps.getInstance().getIntProperty("EtatChargeSelMoisAu");
        if (intProperty > 1) {
            this.selMoisAu.setValue(intProperty);
        } else {
            int month = Calendar.getInstance().get(2);
            this.selMoisAu.setValue(month + 2);
        }
        pDate.add(labelAnnee);
        pDate.add(this.textAnnee);
        String s = DefaultNXProps.getInstance().getStringProperty("EtatChargeAnnee");
        if (s == null || s.length() == 0) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy");
            s = format.format(new Date());
        }
        this.textAnnee.setText(s);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((Component)pDate, c);
        JTabbedPane tabbedPane = new JTabbedPane();
        List<SQLRow> l = CaisseCotisationSQLElement.getCaisseCotisation();
        this.model = new EtatChargeModel[l.size()];
        int i = 0;
        while (i < l.size()) {
            SQLRow row = l.get(i);
            tabbedPane.add(row.getString("NOM"), this.createTabbedPanel(i, row.getID()));
            ++i;
        }
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        this.add((Component)tabbedPane, c);
        JButton buttonImpression = new JButton("Impression");
        JButton buttonClose = new JButton("Fermer");
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 13;
        this.add((Component)buttonImpression, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)buttonClose, c);
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(EtatChargePanel.this)).dispose();
            }
        });
        buttonImpression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtatChargesPayeSheet bSheet = new EtatChargesPayeSheet(EtatChargePanel.this.selMoisDu.getSelectedId(), EtatChargePanel.this.selMoisAu.getSelectedId(), EtatChargePanel.this.textAnnee.getText());
                new SpreadSheetGeneratorCompta(bSheet, "EtatChargesPaye", false, true);
            }
        });
        this.selMoisAu.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println("Selection Changed");
                EtatChargePanel.this.refreshModel();
                EtatChargePanel.this.storeValue();
            }
        });
        this.selMoisDu.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println("Selection Changed");
                EtatChargePanel.this.refreshModel();
                EtatChargePanel.this.storeValue();
            }
        });
        this.textAnnee.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                EtatChargePanel.this.refreshModel();
                EtatChargePanel.this.storeValue();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EtatChargePanel.this.refreshModel();
                EtatChargePanel.this.storeValue();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EtatChargePanel.this.refreshModel();
                EtatChargePanel.this.storeValue();
            }
        });
    }

    private void storeValue() {
        System.err.println("___STORE VALUES");
        DefaultNXProps.getInstance().setProperty("EtatChargeSelMoisDu", String.valueOf(this.selMoisDu.getSelectedId()));
        DefaultNXProps.getInstance().setProperty("EtatChargeSelMoisAu", String.valueOf(this.selMoisAu.getSelectedId()));
        DefaultNXProps.getInstance().setProperty("EtatChargeAnnee", String.valueOf(this.textAnnee.getText()));
        DefaultNXProps.getInstance().store();
    }

    private JPanel createTabbedPanel(final int i, int idCaisse) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        this.model[i] = new EtatChargeModel(0, 0, 0, idCaisse);
        JTable tableEltLivre = new JTable(this.model[i]);
        JTableStateManager s = new JTableStateManager(tableEltLivre, new File(Configuration.getInstance().getConfDir(), "state-" + this.getClass().getSimpleName() + "_" + idCaisse + ".xml"), true);
        s.loadState();
        tableEltLivre.setDefaultRenderer(String.class, new EtatChargeRenderer());
        tableEltLivre.setDefaultRenderer(Float.class, new EtatChargeRenderer());
        JScrollPane scrollPane = new JScrollPane(tableEltLivre);
        scrollPane.setOpaque(false);
        scrollPane.setBorder(null);
        scrollPane.getViewport().setOpaque(false);
        panel.add((Component)scrollPane, c);
        c.fill = 2;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JPanel panelTotal = new JPanel();
        panelTotal.setOpaque(false);
        JLabel labelCotSal = new JLabel("Cotisations Sal.");
        panelTotal.add(labelCotSal);
        final JTextField textCotS = new JTextField(10);
        panelTotal.add(textCotS);
        textCotS.setEditable(false);
        textCotS.setEnabled(false);
        JLabel labelCotPat = new JLabel("Cotisations Pat");
        panelTotal.add(labelCotPat);
        final JTextField textCotP = new JTextField(10);
        panelTotal.add(textCotP);
        textCotP.setEditable(false);
        textCotP.setEnabled(false);
        ++c.gridy;
        panel.add((Component)panelTotal, c);
        this.model[i].addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                textCotS.setText(numberFormat.format(EtatChargePanel.this.model[i].getTotalCotisationSal()));
                textCotP.setText(numberFormat.format(EtatChargePanel.this.model[i].getTotalCotisationPat()));
            }
        });
        return panel;
    }

    private void refreshModel() {
        int i = 0;
        while (i < this.model.length) {
            if (this.selMoisDu.getSelectedId() <= this.selMoisAu.getSelectedId()) {
                System.err.println("LOAD");
                String yearS = this.textAnnee.getText();
                int yearI = yearS.trim().length() == 0 ? 0 : Integer.parseInt(yearS);
                this.model[i].reload(this.selMoisDu.getSelectedId(), this.selMoisAu.getSelectedId(), yearI);
            }
            ++i;
        }
    }
}

