/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import org.openconcerto.erp.core.finance.accounting.ui.CompteCellRenderer;
import org.openconcerto.utils.GestionDevise;

public class BalanceCellRenderer
extends CompteCellRenderer {
    private int colNumeroCompte;

    public BalanceCellRenderer(int colNumeroCompte) {
        this.colNumeroCompte = colNumeroCompte;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String numeroCompte = table.getValueAt(row, this.colNumeroCompte).toString();
        String numeroCompteSuiv = null;
        if (row < table.getRowCount() - 1) {
            numeroCompteSuiv = table.getValueAt(row + 1, this.colNumeroCompte).toString();
        }
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!isSelected) {
            if (numeroCompte.trim().length() == 1) {
                this.setBackground(couleurCompteClasse);
                this.setForeground(Color.BLACK);
            } else if (numeroCompteSuiv != null && numeroCompte.trim().length() < numeroCompteSuiv.trim().length() && numeroCompte.trim().equalsIgnoreCase(numeroCompteSuiv.trim().substring(0, numeroCompte.length()))) {
                if (numeroCompte.trim().length() == 2) {
                    this.setBackground(couleurCompte2);
                    this.setForeground(Color.BLACK);
                } else if (numeroCompte.trim().length() == 3) {
                    this.setBackground(couleurCompte3);
                    this.setForeground(Color.BLACK);
                } else {
                    this.setBackground(couleurCompteRacine);
                    this.setForeground(Color.BLACK);
                }
            } else {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
            }
        }
        if (value.getClass() == Long.class) {
            this.setText(GestionDevise.currencyToString((Long)value));
        }
        return this;
    }
}

