/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.preferences.DefaultPreferencePanel;

public abstract class AbstractReglementComptePreferencePanel
extends DefaultPreferencePanel {
    private static final SQLBase BASE = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private static final SQLTable TABLE_TYPE_REGLEMENT = BASE.getTable("TYPE_REGLEMENT");
    private final Map<ISQLCompteSelector, SQLRow> map = new HashMap<ISQLCompteSelector, SQLRow>();

    public AbstractReglementComptePreferencePanel() {
        SQLSelect selType = new SQLSelect(BASE);
        selType.addSelectStar(TABLE_TYPE_REGLEMENT);
        selType.addRawOrder(String.valueOf(SQLBase.quoteIdentifier("TYPE_REGLEMENT")) + "." + SQLBase.quoteIdentifier("NOM"));
        List list = (List)BASE.getDataSource().execute(selType.asString(), SQLRowListRSH.createFromSelect(selType, TABLE_TYPE_REGLEMENT));
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.anchor = 17;
        c.gridx = -1;
        int size = list.size();
        ISQLCompteSelector[] selCompte = new ISQLCompteSelector[size];
        int i = 0;
        while (i < size) {
            SQLRow row = (SQLRow)list.get(i);
            ++c.gridy;
            c.weightx = 0.0;
            this.add((Component)new JLabel("Compte " + row.getString("NOM")), c);
            c.weightx = 1.0;
            selCompte[i] = new ISQLCompteSelector();
            selCompte[i].init();
            this.add((Component)selCompte[i], c);
            this.map.put(selCompte[i], row);
            ++i;
        }
        c.weighty = 1.0;
        ++c.gridy;
        this.add((Component)new JPanel(), c);
        this.setValues();
    }

    public abstract String getComptePCEField();

    public abstract String getComptePCETraites();

    public abstract String getComptePCEEspeces();

    public abstract String getComptePCECB();

    public abstract String getComptePCECheque();

    @Override
    public abstract String getTitleName();

    @Override
    public void storeValues() {
        Set<ISQLCompteSelector> set = this.map.keySet();
        for (ISQLCompteSelector key : set) {
            SQLRowValues rowVals = this.map.get(key).createUpdateRow();
            rowVals.put(this.getComptePCEField(), key.getValue());
            try {
                if (rowVals.getInvalid() == null) {
                    rowVals.update();
                    continue;
                }
                JOptionPane.showMessageDialog(null, "Impossible de mettre \u00e0 jour les pr\u00e9f\u00e9rences pour le mode de r\u00e8glement " + rowVals.getString("NOM") + ". La valeur est invalide.");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void restoreToDefaults() {
        try {
            Set<ISQLCompteSelector> set = this.map.keySet();
            for (ISQLCompteSelector key : set) {
                SQLRow row = this.map.get(key);
                String compte = this.getCompteFromId(row.getID());
                int value = ComptePCESQLElement.getId(compte);
                key.setValue(value);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private final String getCompteFromId(int id) throws IllegalArgumentException {
        String compte = null;
        switch (id) {
            case 2: {
                compte = ComptePCESQLElement.getComptePceDefault(this.getComptePCECheque());
                break;
            }
            case 3: {
                compte = ComptePCESQLElement.getComptePceDefault(this.getComptePCECB());
                break;
            }
            case 4: {
                compte = ComptePCESQLElement.getComptePceDefault(this.getComptePCEEspeces());
                break;
            }
            default: {
                compte = ComptePCESQLElement.getComptePceDefault(this.getComptePCETraites());
            }
        }
        return compte;
    }

    private void setValues() {
        try {
            Set<ISQLCompteSelector> set = this.map.keySet();
            for (ISQLCompteSelector key : set) {
                SQLRow row = this.map.get(key);
                int oldValue = row.getInt(this.getComptePCEField());
                String compte = null;
                if (oldValue <= 1) {
                    compte = this.getCompteFromId(row.getID());
                }
                int idCompte = 1;
                idCompte = compte != null ? ComptePCESQLElement.getId(compte) : oldValue;
                key.setValue(idCompte);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }
}

