/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;

public class BalanceAgeeListeSheetXML
extends AbstractListeSheetXml {
    private Date deb;
    private Date fin;
    public static String TEMPLATE_ID = "Balance ag\u00e9e";

    public BalanceAgeeListeSheetXML(Date deb, Date fin) {
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
        this.deb = deb;
        this.fin = fin;
    }

    @Override
    public String getDefaultTemplateId() {
        return "BalanceAgee";
    }

    @Override
    public String getName() {
        return "BalanceAgee" + new Date().getTime();
    }

    @Override
    protected void createListeValues() {
        SQLElement ecr = Configuration.getInstance().getDirectory().getElement("ECRITURE");
        SQLElement cpt = Configuration.getInstance().getDirectory().getElement("COMPTE_PCE");
        SQLElement fact = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        SQLSelect sel = new SQLSelect(ecr.getTable().getBase());
        sel.addSelectStar(ecr.getTable());
        Where w = new Where((FieldRef)cpt.getTable().getField("NUMERO"), "LIKE", (Object)"411%");
        if (this.deb != null) {
            w = w.and(new Where((FieldRef)ecr.getTable().getField("DATE"), ">=", (Object)this.deb));
        }
        if (this.fin != null) {
            w = w.and(new Where((FieldRef)ecr.getTable().getField("DATE"), "<=", (Object)this.fin));
        }
        w = w.and(new Where((FieldRef)ecr.getTable().getField("ID_COMPTE_PCE"), "=", cpt.getTable().getKey()));
        w = w.and(new Where((FieldRef)ecr.getTable().getField("LETTRAGE"), "=", (Object)"").or(new Where((FieldRef)ecr.getTable().getField("LETTRAGE"), "=", (Object)null)));
        sel.setWhere(w);
        sel.addFieldOrder(ecr.getTable().getField("COMPTE_NUMERO"));
        System.err.println(sel.asString());
        ArrayList<Map> valuesTab = new ArrayList<Map>();
        List l = (List)ecr.getTable().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
        Calendar c = Calendar.getInstance();
        HashMap<String, Map<String, String>> vals = new HashMap<String, Map<String, String>>();
        long total30 = 0L;
        long total60 = 0L;
        long total90 = 0L;
        long totalPlus = 0L;
        long totalFull = 0L;
        for (SQLRow sqlRow : l) {
            Map<String, String> m;
            long time;
            long day;
            long date = sqlRow.getDate("DATE").getTimeInMillis();
            SQLRow rowMvt = sqlRow.getForeignRow("ID_MOUVEMENT");
            if (rowMvt.getString("SOURCE").equalsIgnoreCase("SAISIE_VENTE_FACTURE")) {
                SQLRow rowFact = fact.getTable().getRow(rowMvt.getInt("IDSOURCE"));
                date = ModeDeReglementSQLElement.calculDate(rowFact.getForeignRow("ID_MODE_REGLEMENT"), rowFact.getDate("DATE").getTime()).getTime();
            }
            if ((day = (time = c.getTimeInMillis() - date) / 86400000L) < 0L) continue;
            SQLRow rowCpt = sqlRow.getForeignRow("ID_COMPTE_PCE");
            String num = rowCpt.getString("NUMERO");
            if (vals.get(num) == null) {
                m = new HashMap();
                vals.put(num, m);
            } else {
                m = (Map)vals.get(num);
            }
            long value = sqlRow.getLong("DEBIT") - sqlRow.getLong("CREDIT");
            totalFull += value;
            String key = "+90";
            if (day <= 30L) {
                key = "30";
                total30 += value;
            } else if (day <= 60L) {
                key = "60";
                total60 += value;
            } else if (day <= 90L) {
                key = "90";
                total90 += value;
            } else {
                totalPlus += value;
            }
            m.put("NUMERO", num);
            m.put("NOM", rowCpt.getString("NOM"));
            if (m.get(key) == null) {
                m.put(key, (String)((Object)Long.valueOf(value)));
            } else {
                long cred = (Long)m.get(key);
                m.put(key, (String)((Object)Long.valueOf(cred + value)));
            }
            long total = 0L;
            if (m.get("TOTAL") != null) {
                total = (Long)m.get("TOTAL");
            }
            m.put("TOTAL", (String)((Object)Long.valueOf(total + value)));
        }
        for (String k : vals.keySet()) {
            Map e = (Map)vals.get(k);
            Long l1 = (Long)e.get("30");
            Long l2 = (Long)e.get("60");
            Long l3 = (Long)e.get("90");
            Long l4 = (Long)e.get("+90");
            Long l5 = (Long)e.get("TOTAL");
            if (!(l1 != null && l1 != 0L || l2 != null && l2 != 0L || l3 != null && l3 != 0L) && (l4 == null || l4 == 0L)) continue;
            if (l1 != null && l1 != 0L) {
                e.put("30", (double)l1.longValue() / 100.0);
            }
            if (l2 != null && l2 != 0L) {
                e.put("60", (double)l2.longValue() / 100.0);
            }
            if (l3 != null && l3 != 0L) {
                e.put("90", (double)l3.longValue() / 100.0);
            }
            if (l4 != null && l4 != 0L) {
                e.put("+90", (double)l4.longValue() / 100.0);
            }
            if (l5 != null && l5 != 0L) {
                e.put("TOTAL", (double)l5.longValue() / 100.0);
            }
            valuesTab.add(e);
        }
        HashMap<String, Object> totalMap = new HashMap<String, Object>();
        totalMap.put("NOM", "TOTAL");
        totalMap.put("30", (double)total30 / 100.0);
        totalMap.put("60", (double)total60 / 100.0);
        totalMap.put("90", (double)total90 / 100.0);
        totalMap.put("+90", (double)totalPlus / 100.0);
        totalMap.put("TOTAL", (double)totalFull / 100.0);
        valuesTab.add(totalMap);
        this.listAllSheetValues.put(0, valuesTab);
    }
}

