/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.action;

import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.accounting.ui.SuppressionEcrituresPanel;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.utils.Tuple2;

public class ListeDesEcrituresAction
extends CreateFrameAbstractAction {
    public ListeDesEcrituresAction() {
        this.putValue("Name", "Liste des \u00e9critures");
    }

    @Override
    public JFrame createFrame() {
        SQLTableModelSourceOnline src;
        final long time = Calendar.getInstance().getTimeInMillis();
        SQLElement element = Configuration.getInstance().getDirectory().getElement("ECRITURE");
        if (!UserManager.getInstance().getCurrentUser().getRights().haveRight(ComptaUserRight.ACCES_NOT_RESCTRICTED_TO_411)) {
            src = element.getTableSource(true);
            src.getReq().setWhere(new Where((FieldRef)element.getTable().getField("COMPTE_NUMERO"), "LIKE", (Object)"411%"));
        } else {
            src = element.getTableSource();
        }
        final IListFrame frame = new IListFrame(new ListeAddPanel(element, new IListe(src)){

            @Override
            protected GridBagConstraints createConstraints() {
                GridBagConstraints res = super.createConstraints();
                res.gridwidth = 0;
                res.gridy = 1;
                return res;
            }

            @Override
            protected void handleAction(JButton source, ActionEvent evt) {
                if (source == this.buttonEffacer && this.getListe().getSelectedRow() != null) {
                    System.err.println("Archivage des \u00e9critures");
                    PanelFrame frame = new PanelFrame(new SuppressionEcrituresPanel(this.getListe().getSelectedRow().getInt("ID_MOUVEMENT")), "Suppression d'ecritures");
                    frame.pack();
                    frame.setResizable(false);
                    frame.setLocationRelativeTo(null);
                    frame.setVisible(true);
                } else {
                    super.handleAction(source, evt);
                }
            }
        });
        frame.setDefaultCloseOperation(2);
        frame.getPanel().setSearchFullMode(true);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        HashMap<String, Tuple2<Date, Date>> m = new HashMap<String, Tuple2<Date, Date>>();
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        Date d = cal.getTime();
        cal.set(5, cal.getActualMaximum(5));
        Date d2 = cal.getTime();
        m.put("Mois courant", new Tuple2<Date, Date>(d, cal.getTime()));
        cal.set(5, 1);
        cal.add(2, -6);
        m.put("Les 6 derniers mois", new Tuple2<Date, Date>(cal.getTime(), d2));
        JTable table = frame.getPanel().getListe().getJTable();
        frame.getPanel().setCloneVisible(false);
        frame.getPanel().setAddVisible(false);
        frame.getPanel().setModifyVisible(false);
        frame.getPanel().setReloadVisible(true);
        frame.getPanel().getListe().setSQLEditable(false);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    JPopupMenu menuDroit = new JPopupMenu();
                    menuDroit.add(new AbstractAction("Contrepassation"){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            EcritureSQLElement.contrePassationPiece(frame.getPanel().getListe().getSelectedId());
                        }
                    });
                    menuDroit.add(new AbstractAction("Voir la source"){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            SQLRow row = frame.getPanel().getListe().getSelectedRow();
                            MouvementSQLElement.showSource(row.getInt("ID_MOUVEMENT"));
                        }
                    });
                    menuDroit.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
                }
            }
        });
        frame.getPanel().getListe().getModel().invokeLater(new Runnable(){

            @Override
            public void run() {
                int rowCount = frame.getPanel().getListe().getModel().getRowCount() - 1;
                if (rowCount > 0) {
                    frame.getPanel().getListe().getJTable().setRowSelectionInterval(rowCount, rowCount);
                }
                System.err.println("Load ecritures : " + (Calendar.getInstance().getTimeInMillis() - time) + " ms");
            }
        });
        return frame;
    }
}

