/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.common.component.AdresseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.generationDoc.gestcomm.CourrierClientSheet;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.ISQLElementWithCodeSelector;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.utils.ExceptionHandler;

public class CourrierClientSQLElement
extends ComptaSQLConfElement {
    public CourrierClientSQLElement() {
        super("COURRIER_CLIENT", "un courrier", "courriers");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("NOM");
        l.add("DATE");
        l.add("INFOS");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_ADRESSE");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            JUniqueTextField textNumero;
            JDate date;
            SQLTextCombo objet;
            ISQLElementWithCodeSelector selAffaire;
            ElementComboBox comboModele;
            ElementComboBox boxAdresse;
            JCheckBox checkImpression;
            JCheckBox checkVisu;
            JButton buttonShowDoc;
            {
                this.comboModele = new ElementComboBox();
                this.checkImpression = new JCheckBox("Impression");
                this.checkVisu = new JCheckBox("Visualisation");
            }

            @Override
            public void addViews() {
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                this.setLayout(new GridBagLayout());
                c.fill = 0;
                this.add((Component)new JLabel(this.getLabelFor("NUMERO")), c);
                this.textNumero = new JUniqueTextField();
                c.gridx = c.gridx + 1;
                c.weightx = 1.0;
                c.fill = 2;
                this.add((Component)this.textNumero, c);
                c.weightx = 0.0;
                c.gridx = c.gridx + 1;
                c.fill = 0;
                this.add((Component)new JLabel(this.getLabelFor("DATE")), c);
                this.date = new JDate(true);
                c.weightx = 1.0;
                c.gridx = c.gridx + 1;
                c.fill = 2;
                this.add((Component)this.date, c);
                c.gridy = c.gridy + 1;
                c.gridx = 0;
                c.gridwidth = 1;
                c.weightx = 0.0;
                c.fill = 0;
                this.add((Component)new JLabel(this.getLabelFor("NOM")), c);
                c.weightx = 1.0;
                c.gridx = c.gridx + 1;
                c.gridwidth = 0;
                c.fill = 2;
                this.objet = new SQLTextCombo();
                this.add((Component)this.objet, c);
                c.gridy = c.gridy + 1;
                c.gridx = 0;
                c.gridwidth = 1;
                c.weightx = 0.0;
                c.fill = 0;
                this.add((Component)new JLabel(this.getLabelFor("ID_MODELE_COURRIER_CLIENT")), c);
                c.gridx = c.gridx + 1;
                c.weightx = 1.0;
                c.fill = 2;
                this.add((Component)this.comboModele, c);
                c.gridx = 0;
                c.gridy = c.gridy + 1;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.gridwidth = 0;
                c.insets = new Insets(15, 2, 3, 2);
                TitledSeparator sep = new TitledSeparator("Adresse");
                this.add((Component)sep, c);
                c.insets = DefaultGridBagConstraints.getDefaultInsets();
                this.addView("ID_ADRESSE", "required;notdecorated;noseparator");
                final ElementSQLObject eltAdr = (ElementSQLObject)this.getView("ID_ADRESSE");
                this.boxAdresse = new ElementComboBox();
                final SQLElement adresseElt = Configuration.getInstance().getDirectory().getElement("ADRESSE");
                this.boxAdresse.init(adresseElt);
                c.gridwidth = 1;
                c.gridx = 0;
                c.gridy = c.gridy + 1;
                c.weightx = 0.0;
                this.boxAdresse.setAddIconVisible(false);
                this.add((Component)new JLabel("Importer l'adresse"), c);
                c.gridx = c.gridx + 1;
                c.gridwidth = 0;
                c.weightx = 1.0;
                this.add((Component)this.boxAdresse, c);
                this.boxAdresse.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (boxAdresse.getSelectedId() > 1) {
                            SQLRowValues rowVals = adresseElt.getTable().getRow(boxAdresse.getSelectedId()).createUpdateRow();
                            rowVals.clearPrimaryKeys();
                            eltAdr.setValue(rowVals);
                        }
                    }
                });
                c.gridwidth = 0;
                c.gridx = 0;
                c.gridy = c.gridy + 1;
                AdresseSQLComponent adrSqlComp = (AdresseSQLComponent)eltAdr.getSQLChild();
                adrSqlComp.setDestinataireVisible(true);
                this.add((Component)eltAdr, c);
                c.gridx = 0;
                c.gridy = c.gridy + 1;
                c.weighty = 0.0;
                c.fill = 2;
                c.gridwidth = 0;
                c.weightx = 1.0;
                c.insets = new Insets(15, 2, 3, 2);
                this.add((Component)new TitledSeparator(this.getLabelFor("INFOS")), c);
                c.gridy = c.gridy + 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.fill = 1;
                c.gridwidth = 0;
                c.insets = DefaultGridBagConstraints.getDefaultInsets();
                JTextArea textInfos = new JTextArea();
                this.add((Component)textInfos, c);
                JPanel panelCheckBox = new JPanel();
                panelCheckBox.add(this.checkVisu);
                this.checkVisu.setSelected(true);
                panelCheckBox.add(this.checkImpression);
                this.buttonShowDoc = new JButton("Voir le document");
                panelCheckBox.add((Component)this.buttonShowDoc, 2);
                c.gridx = 0;
                c.gridy = c.gridy + 1;
                c.fill = 0;
                c.weighty = 0.0;
                c.weightx = 0.0;
                c.anchor = 17;
                this.add((Component)panelCheckBox, c);
                this.buttonShowDoc.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CourrierClientSheet s = new CourrierClientSheet(this.getTable().getRow(this.getSelectedID()));
                        s.showDocument();
                    }
                });
                this.addRequiredSQLObject(this.objet, "NOM");
                this.addRequiredSQLObject(this.textNumero, "NUMERO");
                this.addRequiredSQLObject(this.comboModele, "ID_MODELE_COURRIER_CLIENT");
                this.addRequiredSQLObject(this.date, "DATE");
            }

            private void setWhereComboAdresse(SQLRow rowAff) {
                System.err.println("Set Where Adresse " + rowAff);
                if (rowAff != null) {
                    SQLElement adresseElt = Configuration.getInstance().getDirectory().getElement("ADRESSE");
                    SQLRow rowCli = rowAff.getForeignRow("ID_CLIENT");
                    Where w = new Where((FieldRef)adresseElt.getTable().getKey(), "=", rowAff.getInt("ID_ADRESSE_COURRIER_1"));
                    w = w.or(new Where((FieldRef)adresseElt.getTable().getKey(), "=", rowAff.getInt("ID_ADRESSE_COURRIER_2")));
                    w = w.or(new Where((FieldRef)adresseElt.getTable().getKey(), "=", rowAff.getInt("ID_ADRESSE_COURRIER_3")));
                    if (rowCli != null) {
                        SQLRow rowAdresse = rowCli.getForeignRow("ID_ADRESSE");
                        w = w.or(new Where((FieldRef)adresseElt.getTable().getKey(), "=", rowAdresse.getID()));
                        this.boxAdresse.getRequest().setWhere(w);
                        this.boxAdresse.fillCombo();
                        return;
                    }
                }
                this.boxAdresse.getRequest().setWhere(null);
                this.boxAdresse.fillCombo();
            }

            @Override
            protected SQLRowValues createDefaults() {
                SQLRowValues rowVals = new SQLRowValues(this.getTable());
                rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(CourrierClientSQLElement.class));
                return rowVals;
            }

            @Override
            public int insert(SQLRow order) {
                if (this.textNumero.checkValidation()) {
                    if (NumerotationAutoSQLElement.getNextNumero(CourrierClientSQLElement.class).equalsIgnoreCase(this.textNumero.getText().trim())) {
                        SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
                        SQLRowValues rowVals = new SQLRowValues(tableNum);
                        int val = tableNum.getRow(2).getInt("COURRIER_START");
                        rowVals.put("COURRIER_START", new Integer(++val));
                        try {
                            rowVals.update(2);
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    int id = super.insert(order);
                    CourrierClientSheet s = new CourrierClientSheet(this.getTable().getRow(id));
                    String printer = PrinterNXProps.getInstance().getStringProperty("CourrierClientPrinter");
                    s.generate(this.checkImpression.isSelected(), this.checkVisu.isSelected(), printer);
                    return id;
                }
                ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de courrier existant.");
                Component root = SwingUtilities.getRoot(this);
                if (root instanceof EditFrame) {
                    EditFrame frame = (EditFrame)root;
                    frame.getPanel().setAlwaysVisible(true);
                }
                return this.getSelectedID();
            }

            @Override
            public void select(SQLRowAccessor r) {
                if (r != null) {
                    this.textNumero.setIdSelected(r.getID());
                }
                super.select(r);
            }

            @Override
            public void update() {
                if (!this.textNumero.checkValidation()) {
                    ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de courrier existant.");
                    Component root = SwingUtilities.getRoot(this);
                    if (root instanceof EditFrame) {
                        EditFrame frame = (EditFrame)root;
                        frame.getPanel().setAlwaysVisible(true);
                    }
                }
                super.update();
                if (this.checkVisu.isSelected()) {
                    CourrierClientSheet s = new CourrierClientSheet(this.getTable().getRow(this.getSelectedID()));
                    s.showDocument();
                }
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(super.createCodeFromPackage()) + ".mail";
    }
}

