/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.element;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.customerrelationship.customer.element.ClientNormalSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.ListSQLRequest;

public class ClientNormalSQLElement
extends ComptaSQLConfElement {
    protected boolean showMdr = true;

    public ClientNormalSQLElement() {
        super("CLIENT", "un client", "clients");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        if (this.getTable().getFieldsName().contains("LOCALISATION")) {
            l.add("LOCALISATION");
        }
        l.add("RESPONSABLE");
        l.add("ID_ADRESSE");
        l.add("TEL");
        l.add("FAX");
        l.add("MAIL");
        l.add("NUMERO_TVA");
        l.add("SIRET");
        l.add("ID_COMPTE_PCE");
        l.add("ID_MODE_REGLEMENT");
        l.add("INFOS");
        return l;
    }

    @Override
    public synchronized ListSQLRequest createListRequest() {
        return new ListSQLRequest(this.getTable(), this.getListFields()){

            @Override
            protected void customizeToFetch(SQLRowValues graphToFetch) {
                super.customizeToFetch(graphToFetch);
                graphToFetch.grow("ID_MODE_REGLEMENT").put("AJOURS", null).put("LENJOUR", null);
            }
        };
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        if (this.getTable().getFieldsName().contains("LOCALISATION")) {
            l.add("LOCALISATION");
        } else {
            l.add("CODE");
        }
        return l;
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_ADRESSE");
        l.add("ID_ADRESSE_L");
        l.add("ID_ADRESSE_F");
        l.add("ID_MODE_REGLEMENT");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new ClientNormalSQLComponent(this);
    }
}

