/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.action;

import java.awt.Font;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JTable;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.sales.invoice.ui.EcheanceRenderer;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.map.model.Ville;
import org.openconcerto.ql.LabelCreator;
import org.openconcerto.ql.QLPrinter;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.utils.cc.IClosure;

public class ListeDesClientsAction
extends CreateFrameAbstractAction {
    private static SQLTable tableModeReglement = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT").getTable();

    public ListeDesClientsAction() {
        this.putValue("Name", "Liste des clients");
    }

    protected SQLTableModelSource getTableSource() {
        SQLTable tableClient = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("CLIENT");
        return Configuration.getInstance().getDirectory().getElement(tableClient).getTableSource(true);
    }

    @Override
    public JFrame createFrame() {
        SQLTable tableClient = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("CLIENT");
        ListeAddPanel panel = new ListeAddPanel(Configuration.getInstance().getDirectory().getElement(tableClient), new IListe(this.getTableSource()));
        IListFrame frame = new IListFrame(panel);
        EcheanceRenderer rend = EcheanceRenderer.getInstance();
        JTable jTable = frame.getPanel().getListe().getJTable();
        int i = 0;
        while (i < jTable.getColumnCount()) {
            int realColIndex = frame.getPanel().getListe().getJTable().getColumnModel().getColumn(i).getModelIndex();
            Set<SQLField> fields = frame.getPanel().getListe().getSource().getColumn(realColIndex).getFields();
            if (fields.contains(tableModeReglement.getField("AJOURS"))) {
                jTable.getColumnModel().getColumn(i).setCellRenderer(rend);
            }
            ++i;
        }
        final String property = PrinterNXProps.getInstance().getProperty("QLPrinter");
        if (property != null && property.trim().length() > 0) {
            panel.getListe().addRowAction(RowAction.createAction("Imprimer l'\u00e9tiquette client", null, new IClosure<List<SQLRowAccessor>>(){

                @Override
                public void executeChecked(List<SQLRowAccessor> input) {
                    String[] s;
                    SQLRowAccessor row = input.get(0);
                    LabelCreator c = new LabelCreator(720);
                    c.setLeftMargin(10);
                    c.setTopMargin(10);
                    c.setDefaultFont(new Font("Verdana", 0, 50));
                    c.addLineBold(row.getString("NOM"));
                    SQLRowAccessor foreignRow = row.getForeign("ID_ADRESSE");
                    String string = foreignRow.getString("RUE");
                    String[] stringArray = s = string.split("\n");
                    int n = s.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string2 = stringArray[n2];
                        System.err.println(string2);
                        c.addLineNormal(string2);
                        ++n2;
                    }
                    Ville v = Ville.getVilleFromVilleEtCode(foreignRow.getString("VILLE"));
                    c.addLineNormal(String.valueOf(v.getCodepostal()) + " " + v.getName());
                    System.err.println("\"" + property + "\"");
                    QLPrinter prt = new QLPrinter(property);
                    try {
                        prt.print(c.getImage());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }));
        }
        panel.setSearchFullMode(true);
        panel.setSelectRowOnAdd(false);
        return frame;
    }
}

