/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util.i18n;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public final class I18nUtils {
    private static final SameLanguageControl INSTANCE = new SameLanguageControl();
    public static final String RSRC_BASENAME = I18nUtils.class.getPackage().getName() + ".Resources";
    public static final String TRUE_KEY = "true_key";
    public static final String FALSE_KEY = "false_key";
    public static final String YES_KEY = "yes_key";
    public static final String NO_KEY = "no_key";

    public static ResourceBundle.Control getSameLanguageControl() {
        return INSTANCE;
    }

    public static final String getBooleanKey(boolean bl) {
        return bl ? TRUE_KEY : FALSE_KEY;
    }

    public static final String getYesNoKey(boolean bl) {
        return bl ? YES_KEY : NO_KEY;
    }

    private static final class SameLanguageControl
    extends ResourceBundle.Control {
        private SameLanguageControl() {
        }

        @Override
        public List<Locale> getCandidateLocales(String string, Locale locale) {
            List<Locale> list = super.getCandidateLocales(string, locale);
            assert (list.get(list.size() - 1) == Locale.ROOT);
            list = list.subList(0, list.size() - 1);
            assert (list.isEmpty() || list.get(list.size() - 1).getLanguage().equals(locale.getLanguage()));
            return list;
        }

        @Override
        public Locale getFallbackLocale(String string, Locale locale) {
            if (string == null) {
                throw new NullPointerException();
            }
            return null;
        }
    }
}

