/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util.convertor;

import java.util.ArrayList;
import java.util.List;
import org.jopendocument.util.ReflectUtils;
import org.jopendocument.util.convertor.DateTSConvertor;
import org.jopendocument.util.convertor.DateToTimeConvertor;
import org.jopendocument.util.convertor.NumberConvertor;
import org.jopendocument.util.convertor.ReverseConvertor;
import org.jopendocument.util.convertor.StringClobConvertor;
import org.jopendocument.util.convertor.ValueConvertor;

public final class ValueConvertorFactory {
    private static final ValueConvertor IdentityConvertor = new ValueConvertor(){

        public Object convert(Object object) {
            return object;
        }

        public Object unconvert(Object object) {
            return object;
        }
    };
    private static final List<ValueConvertor<?, ?>> convs = new ArrayList();

    public static final <T> ValueConvertor<T, T> getIdentityConvertor() {
        return IdentityConvertor;
    }

    public static final <T, U> ValueConvertor<T, U> find(Class<T> clazz, Class<U> clazz2) {
        if (clazz == clazz2) {
            return ValueConvertorFactory.getIdentityConvertor();
        }
        for (ValueConvertor<?, ?> valueConvertor : convs) {
            List<Class<?>> list = ReflectUtils.getTypeArguments(valueConvertor, ValueConvertor.class);
            if (list.size() != 2) {
                throw new IllegalStateException(valueConvertor + " don't specify type arguments");
            }
            if (list.get(0).equals(clazz) && list.get(1).equals(clazz2)) {
                return valueConvertor;
            }
            if (!list.get(0).equals(clazz2) || !list.get(1).equals(clazz)) continue;
            return new ReverseConvertor(valueConvertor);
        }
        if (Number.class.isAssignableFrom(clazz) && Number.class.isAssignableFrom(clazz2)) {
            return NumberConvertor.create(clazz.asSubclass(Number.class), clazz2.asSubclass(Number.class), true);
        }
        return null;
    }

    static {
        convs.add(new DateTSConvertor());
        convs.add(new DateToTimeConvertor());
        convs.add(StringClobConvertor.INSTANCE);
        convs.add(NumberConvertor.INT_TO_LONG);
        convs.add(NumberConvertor.SHORT_TO_INT);
    }
}

