/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util.convertor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.TestCase;
import org.jopendocument.util.NumberUtils;
import org.jopendocument.util.convertor.NumberConvertor;

public class NumberConvertorTest
extends TestCase {
    private static final List<Class<? extends Number>> numberClasses;
    private static final Map<Class<? extends Number>, Number> fives;
    private static final Map<Class<? extends Number>, Number> minValues;
    private static final Map<Class<? extends Number>, Number> maxValues;

    private static void fillValues() throws IllegalAccessException, NoSuchFieldException {
        for (Class clazz : new Class[]{Byte.class, Short.class, Integer.class, Long.class}) {
            minValues.put(clazz.asSubclass(Number.class), (Number)clazz.getField("MIN_VALUE").get(null));
            maxValues.put(clazz.asSubclass(Number.class), (Number)clazz.getField("MAX_VALUE").get(null));
        }
        minValues.put(AtomicInteger.class, new AtomicInteger((Integer)minValues.get(Integer.class)));
        minValues.put(AtomicLong.class, new AtomicLong((Long)minValues.get(Long.class)));
        maxValues.put(AtomicInteger.class, new AtomicInteger((Integer)maxValues.get(Integer.class)));
        maxValues.put(AtomicLong.class, new AtomicLong((Long)maxValues.get(Long.class)));
        maxValues.put(Float.class, Float.valueOf(Float.MAX_VALUE));
        minValues.put(Float.class, Float.valueOf(-3.4028235E38f));
        maxValues.put(Double.class, Double.MAX_VALUE);
        minValues.put(Double.class, -1.7976931348623157E308);
    }

    public static Map<Class<? extends Number>, Number> getMinValues() throws IllegalAccessException, NoSuchFieldException {
        if (minValues.isEmpty()) {
            NumberConvertorTest.fillValues();
        }
        return minValues;
    }

    public static Map<Class<? extends Number>, Number> getMaxValues() throws IllegalAccessException, NoSuchFieldException {
        if (maxValues.isEmpty()) {
            NumberConvertorTest.fillValues();
        }
        return maxValues;
    }

    public static boolean isFloat(Number number) {
        return number instanceof Float || number instanceof Double;
    }

    public void testConvert() throws Exception {
        for (Class<? extends Number> clazz : numberClasses) {
            Number number = fives.get(clazz);
            assert (number.getClass() == clazz);
            for (Number number2 : fives.values()) {
                Number number3 = NumberConvertor.convert(number2, clazz);
                NumberConvertorTest.assertTrue((boolean)NumberUtils.areEqual(number, number3));
                NumberConvertorTest.assertTrue((boolean)NumberUtils.areEqual(number2, NumberConvertor.convert(number3, number2.getClass())));
                this.assertConvertExactAndBack(number2, clazz, number);
            }
            this.assertConvertExactAtLimits(NumberConvertorTest.getMinValues().get(clazz), clazz);
            this.assertConvertExactAtLimits(NumberConvertorTest.getMaxValues().get(clazz), clazz);
        }
    }

    private void assertConvertExactAndBack(Number number, Class<? extends Number> clazz, Number number2) {
        Number number3 = this.assertConvertExact(number, clazz, number2, false);
        if (number3 != null) {
            this.assertConvertExact(number3, number.getClass(), number, false);
        }
    }

    private Number assertConvertExact(Number number, Class<? extends Number> clazz, Number number2, boolean bl) {
        if (NumberConvertorTest.isFloat(number) && !NumberConvertorTest.isFloat(number2) && !(number2 instanceof BigDecimal)) {
            block8: {
                try {
                    NumberConvertor.convertExact(number, clazz);
                    if (bl) {
                        NumberConvertorTest.fail((String)("Should have thrown a OverflowException from " + number.getClass() + " to " + clazz));
                    } else {
                        NumberConvertorTest.fail((String)("Should have thrown a RoundingException from " + number.getClass() + " to " + clazz));
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (bl && runtimeException instanceof NumberConvertor.OverflowException || !bl && runtimeException instanceof NumberConvertor.RoundingException) break block8;
                    throw runtimeException;
                }
            }
            return null;
        }
        if (bl) {
            try {
                NumberConvertor.convertExact(number, clazz);
                NumberConvertorTest.fail((String)"Should have thrown an OverflowException");
            }
            catch (NumberConvertor.OverflowException overflowException) {
                // empty catch block
            }
            return null;
        }
        Number number3 = NumberConvertor.convertExact(number, clazz);
        NumberConvertorTest.assertEquals(clazz, number3.getClass());
        NumberConvertorTest.assertTrue((boolean)NumberUtils.areEqual(number2, number3));
        return number3;
    }

    private void assertConvertExactAtLimits(Number number, Class<? extends Number> clazz) {
        if (number != null) {
            NumberConvertorTest.assertEquals(clazz, number.getClass());
            BigDecimal bigDecimal = NumberConvertor.toBigDecimal(number);
            this.assertConvertExactAndBack(bigDecimal, clazz, number);
            BigDecimal bigDecimal2 = NumberConvertorTest.isFloat(number) ? bigDecimal.multiply(BigDecimal.valueOf(2L)) : (bigDecimal.signum() > 0 ? bigDecimal.add(BigDecimal.ONE) : bigDecimal.subtract(BigDecimal.ONE));
            this.assertBeyondLimit(bigDecimal, bigDecimal2);
            this.assertConvertExact(bigDecimal2, clazz, number, true);
            if (clazz != Double.class) {
                this.assertBeyondLimit(bigDecimal, BigDecimal.valueOf(bigDecimal2.doubleValue()));
                this.assertConvertExact(bigDecimal2.doubleValue(), clazz, number, true);
            }
        }
    }

    private void assertBeyondLimit(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        NumberConvertorTest.assertEquals((int)bigDecimal.signum(), (int)bigDecimal2.signum());
        NumberConvertorTest.assertTrue((bigDecimal2.abs().compareTo(bigDecimal.abs()) > 0 ? 1 : 0) != 0);
    }

    static {
        fives = new HashMap<Class<? extends Number>, Number>();
        minValues = new HashMap<Class<? extends Number>, Number>();
        maxValues = new HashMap<Class<? extends Number>, Number>();
        numberClasses = new ArrayList<Class<? extends Number>>();
        numberClasses.add(Byte.class);
        numberClasses.add(Short.class);
        numberClasses.add(AtomicInteger.class);
        numberClasses.add(Integer.class);
        numberClasses.add(AtomicLong.class);
        numberClasses.add(Long.class);
        numberClasses.add(BigInteger.class);
        numberClasses.add(Float.class);
        numberClasses.add(Double.class);
        numberClasses.add(BigDecimal.class);
        fives.put(Byte.class, (byte)5);
        fives.put(Short.class, (short)5);
        fives.put(Integer.class, 5);
        fives.put(AtomicInteger.class, new AtomicInteger(5));
        fives.put(Long.class, 5L);
        fives.put(AtomicLong.class, new AtomicLong(5L));
        fives.put(BigInteger.class, BigInteger.valueOf(5L));
        fives.put(BigDecimal.class, BigDecimal.valueOf(5L));
        fives.put(Float.class, Float.valueOf(5.0f));
        fives.put(Double.class, 5.0);
    }
}

