/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util.cc;

import org.apache.commons.collections.Predicate;

public abstract class IPredicate<E>
implements Predicate {
    private static final IPredicate<Object> truePred = new IPredicate<Object>(){

        @Override
        public boolean evaluateChecked(Object object) {
            return true;
        }
    };
    private static final IPredicate<Object> falsePred = new IPredicate<Object>(){

        @Override
        public boolean evaluateChecked(Object object) {
            return false;
        }
    };
    private static final IPredicate<Object> NotNullPred = new IPredicate<Object>(){

        @Override
        public boolean evaluateChecked(Object object) {
            return object != null;
        }
    };

    public static final <N> IPredicate<N> truePredicate() {
        return truePred;
    }

    public static final <N> IPredicate<N> falsePredicate() {
        return falsePred;
    }

    public static final <N> IPredicate<N> notNullPredicate() {
        return NotNullPred;
    }

    @Override
    public boolean evaluate(Object object) {
        return this.evaluateChecked(object);
    }

    public abstract boolean evaluateChecked(E var1);

    public final <F extends E> IPredicate<F> cast() {
        return new IPredicate<F>(){

            @Override
            public boolean evaluateChecked(F f) {
                return IPredicate.this.evaluateChecked(f);
            }
        };
    }

    public final IPredicate<E> not() {
        if (this == truePred) {
            return IPredicate.falsePredicate();
        }
        if (this == falsePred) {
            return IPredicate.truePredicate();
        }
        return new IPredicate<E>(){

            @Override
            public boolean evaluateChecked(E e) {
                return !IPredicate.this.evaluateChecked(e);
            }
        };
    }

    public final IPredicate<E> and(final IPredicate<? super E> iPredicate) {
        if (iPredicate == this || iPredicate == truePred) {
            return this;
        }
        if (this == truePred) {
            return iPredicate.cast();
        }
        if (iPredicate == falsePred || this == falsePred) {
            return IPredicate.falsePredicate();
        }
        return new IPredicate<E>(){

            @Override
            public boolean evaluateChecked(E e) {
                return IPredicate.this.evaluateChecked(e) && iPredicate.evaluateChecked(e);
            }
        };
    }

    public final IPredicate<E> or(final IPredicate<? super E> iPredicate) {
        if (iPredicate == this || iPredicate == falsePred) {
            return this;
        }
        if (this == falsePred) {
            return iPredicate.cast();
        }
        if (iPredicate == truePred || this == truePred) {
            return IPredicate.truePredicate();
        }
        return new IPredicate<E>(){

            @Override
            public boolean evaluateChecked(E e) {
                return IPredicate.this.evaluateChecked(e) || iPredicate.evaluateChecked(e);
            }
        };
    }
}

