/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import javax.xml.validation.Schema;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jopendocument.util.CollectionMap;
import org.jopendocument.util.ExceptionUtils;
import org.jopendocument.util.JDOMUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class Validator {
    private final Document doc;

    protected Validator(Document document) {
        this.doc = document;
    }

    protected final Document getDoc() {
        return this.doc;
    }

    public abstract String isValid();

    public abstract CollectionMap<String, String> validateCompletely();

    private static final class RecordingErrorHandler
    implements ErrorHandler {
        private final CollectionMap<String, String> res;

        private RecordingErrorHandler() {
            this(new CollectionMap<String, String>());
        }

        private RecordingErrorHandler(CollectionMap<String, String> collectionMap) {
            this.res = collectionMap;
        }

        public final CollectionMap<String, String> getMap() {
            return this.res;
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.addExn("WARNING", sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.addExn("FATAL", sAXParseException);
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            this.addExn("ERROR", sAXParseException);
        }

        private void addExn(String string, SAXParseException sAXParseException) {
            this.res.put((Object)(string + " " + sAXParseException.getMessage()), (Object)RecordingErrorHandler.getDesc(sAXParseException));
        }

        static String getDesc(SAXParseException sAXParseException) {
            String string = sAXParseException.getSystemId() == null ? "" : " of document " + sAXParseException.getSystemId();
            return "on line " + sAXParseException.getLineNumber() + ":" + sAXParseException.getColumnNumber() + string;
        }
    }

    public static final class DTDValidator
    extends Validator {
        private final SAXBuilder b;

        public DTDValidator(Document document) {
            this(document, new SAXBuilder());
        }

        public DTDValidator(Document document, SAXBuilder sAXBuilder) {
            super(document);
            this.b = sAXBuilder;
        }

        @Override
        public String isValid() {
            try {
                JDOMUtils.validateDTD(this.getDoc(), this.b, null);
                return null;
            }
            catch (JDOMException jDOMException) {
                return ExceptionUtils.getStackTrace(jDOMException);
            }
        }

        @Override
        public CollectionMap<String, String> validateCompletely() {
            try {
                RecordingErrorHandler recordingErrorHandler = new RecordingErrorHandler();
                JDOMUtils.validateDTD(this.getDoc(), this.b, recordingErrorHandler);
                return recordingErrorHandler.getMap();
            }
            catch (JDOMException jDOMException) {
                throw new IllegalStateException("Unable to read the document", jDOMException);
            }
        }
    }

    public static final class JAXPValidator
    extends Validator {
        private final Schema schema;

        public JAXPValidator(Document document, Schema schema) {
            super(document);
            this.schema = schema;
        }

        @Override
        public String isValid() {
            SAXException sAXException = JDOMUtils.validate(this.getDoc(), this.schema, null);
            if (sAXException == null) {
                return null;
            }
            if (sAXException instanceof SAXParseException) {
                return sAXException.getLocalizedMessage() + " " + RecordingErrorHandler.getDesc((SAXParseException)sAXException);
            }
            return sAXException.getLocalizedMessage();
        }

        @Override
        public CollectionMap<String, String> validateCompletely() {
            RecordingErrorHandler recordingErrorHandler = new RecordingErrorHandler();
            SAXException sAXException = JDOMUtils.validate(this.getDoc(), this.schema, recordingErrorHandler);
            assert (sAXException == null) : "Exception thrown despite the error handler";
            return recordingErrorHandler.getMap();
        }
    }
}

