/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jopendocument.util.MessageDigestUtils;

public class StringUtils {
    public static final Charset UTF8 = Charset.forName("UTF8");
    public static final Charset UTF16 = Charset.forName("UTF-16");
    public static final Charset ASCII = Charset.forName("ASCII");
    public static final Charset ISO8859_1 = Charset.forName("ISO8859_1");
    public static final Charset Cp1252 = Charset.forName("Cp1252");
    public static final Charset Cp850 = Charset.forName("Cp850");
    private static final Pattern quotePatrn = Pattern.compile("([\\\\]*)\"");
    private static final Pattern endSlashPatrn = Pattern.compile("([\\\\]*)\\z");

    public static String firstUpThenLow(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (string.length() == 1) {
            return string.toUpperCase();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }

    public static String firstUp(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (string.length() == 1) {
            return string.toUpperCase();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static final int getLeastMaximum() {
        return Shortener.ORDERED[Shortener.ORDERED.length - 1].getMinStringLength();
    }

    private static final Shortener getShortener(int n) {
        for (Shortener shortener : Shortener.ORDERED) {
            if (n < shortener.getMinStringLength()) continue;
            return shortener;
        }
        return null;
    }

    public static final String getBoundedLengthString(String string, int n) throws IllegalArgumentException {
        if (n < StringUtils.getLeastMaximum()) {
            throw new IllegalArgumentException("Maximum too low : " + n + "<" + StringUtils.getLeastMaximum());
        }
        String string2 = string.length() <= n ? string : StringUtils.getShortener(n).shorten(string, n);
        return string2;
    }

    public static final List<String> fastSplit(String string, char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        char[] cArray = string.toCharArray();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != c) continue;
            arrayList.add(new String(cArray, n2, i - n2));
            n2 = i + 1;
        }
        if (n2 < n) {
            arrayList.add(new String(cArray, n2, n - n2));
        }
        return arrayList;
    }

    public static String splitString(String string, int n) {
        if (string == null) {
            return string;
        }
        if (string.trim().length() < n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c;
            if (stringBuffer.length() == n) {
                c = stringBuffer.lastIndexOf(" ");
                if (stringBuffer2.length() > 0 && stringBuffer2.charAt(stringBuffer2.length() - 1) != '\n') {
                    stringBuffer2.append("\n");
                }
                if (c > '\u0000') {
                    stringBuffer2.append(stringBuffer.substring(0, c).toString().trim());
                    stringBuffer = new StringBuffer(stringBuffer.substring(c, stringBuffer.length()));
                } else {
                    stringBuffer2.append(stringBuffer.toString().trim());
                    stringBuffer = new StringBuffer();
                }
                stringBuffer2.append("\n");
            }
            if ((c = (char)string.charAt(i)) == '\n') {
                stringBuffer.append(c);
                stringBuffer2.append(stringBuffer);
                stringBuffer = new StringBuffer();
                continue;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer2.length() > 0 && stringBuffer2.charAt(stringBuffer2.length() - 1) != '\n') {
            stringBuffer2.append("\n");
        }
        stringBuffer2.append(stringBuffer.toString().trim());
        return stringBuffer2.toString();
    }

    public static String doubleQuote(String string) {
        if (string.length() > 0) {
            string = quotePatrn.matcher(string).replaceAll("$1$1\\\\\"");
            string = endSlashPatrn.matcher(string).replaceAll("$1$1");
        }
        return '\"' + string + '\"';
    }

    public static String rightAlign(String string, int n) {
        String string2 = string;
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            string2 = ' ' + string2;
        }
        return string2;
    }

    public static String leftAlign(String string, int n) {
        String string2 = string;
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            string2 = string2 + ' ';
        }
        return string2;
    }

    public static final class Escaper {
        private final char esc;
        private final Map<Character, Character> substitution;
        private final Map<Character, Character> inv;

        public Escaper(char c, char c2) {
            this.esc = c;
            this.substitution = new LinkedHashMap<Character, Character>();
            this.inv = new HashMap<Character, Character>();
            this.add(c, c2);
        }

        public Escaper add(char c, char c2) {
            if (this.inv.containsKey(Character.valueOf(c2))) {
                throw new IllegalArgumentException(c2 + " already replaces " + this.inv.get(Character.valueOf(c2)));
            }
            this.substitution.put(Character.valueOf(c), Character.valueOf(c2));
            this.inv.put(Character.valueOf(c2), Character.valueOf(c));
            return this;
        }

        public final Set<Character> getEscapedChars() {
            HashSet<Character> hashSet = new HashSet<Character>(this.substitution.keySet());
            hashSet.remove(Character.valueOf(this.esc));
            return hashSet;
        }

        public final String escape(String string) {
            String string2 = string;
            for (Character c : this.substitution.keySet()) {
                string2 = string2.replace(c + "", this.getEscaped(c));
            }
            return string2;
        }

        private String getEscaped(Character c) {
            return this.esc + "" + this.substitution.get(c);
        }

        public final String unescape(String string) {
            String string2 = string;
            ArrayList<Character> arrayList = new ArrayList<Character>(this.substitution.keySet());
            Collections.reverse(arrayList);
            for (Character c : arrayList) {
                string2 = string2.replaceAll(this.getEscaped(c), c + "");
            }
            return string2;
        }

        public boolean equals(Object object) {
            if (object instanceof Escaper) {
                Escaper escaper = (Escaper)object;
                return this.esc == escaper.esc && ((Object)this.substitution).equals(escaper.substitution);
            }
            return false;
        }

        public int hashCode() {
            return this.esc + ((Object)this.substitution).hashCode();
        }
    }

    public static abstract class Shortener {
        private final int hashSize;
        private final int hashPartSize;
        private final String prefix;
        private final String suffix;
        private final int minStringLength;
        public static final Shortener Ellipsis = new Shortener(1, "", "", 1){

            @Override
            protected String shorten(String string) {
                return "\u2026";
            }
        };
        public static final Shortener JavaHashCode = new Shortener(8, "#", "#", 3){

            @Override
            protected String shorten(String string) {
                return MessageDigestUtils.asHex(MessageDigestUtils.int2bytes(string.hashCode()));
            }
        };
        public static final Shortener MD5 = new Shortener(32, "#", "#", 11){

            @Override
            protected String shorten(String string) {
                return MessageDigestUtils.getHashString(MessageDigestUtils.getMD5(), string.getBytes(UTF8));
            }
        };
        static final Shortener[] ORDERED = new Shortener[]{MD5, JavaHashCode, Ellipsis};

        protected Shortener(int n, String string, String string2, int n2) {
            this.hashSize = n;
            this.prefix = string;
            this.suffix = string2;
            this.hashPartSize = this.hashSize + this.prefix.length() + this.suffix.length();
            if (n2 < 1) {
                throw new IllegalArgumentException("minCharsBeforeAndAfter must be at least 1: " + n2);
            }
            this.minStringLength = this.hashPartSize + n2 * 2;
        }

        public final int getMinStringLength() {
            return this.minStringLength;
        }

        public final String getBoundedLengthString(String string, int n) {
            if (n < this.getMinStringLength()) {
                throw new IllegalArgumentException("Maximum too low : " + n + "<" + this.getMinStringLength());
            }
            if (string.length() <= n) {
                return string;
            }
            return this.shorten(string, n);
        }

        final String shorten(String string, int n) {
            assert (string.length() >= this.getMinStringLength());
            int n2 = string.length() - n + this.hashPartSize;
            int n3 = string.length() / 2 - n2 / 2;
            String string2 = string.substring(n3, n3 + n2);
            String string3 = this.shorten(string2);
            assert (this.hashSize == string3.length());
            String string4 = string.substring(0, n3) + this.prefix + string3 + this.suffix + string.substring(n3 + n2);
            assert (string4.length() == n);
            return string4;
        }

        protected abstract String shorten(String var1);
    }
}

