/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class StreamUtils {
    public static final OutputStream NULL_OS = new OutputStream(){

        @Override
        public void write(int n) throws IOException {
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
        }
    };
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        StreamUtils.copy(inputStream, outputStream, 524288);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            StreamUtils.copy(inputStream, bufferedOutputStream);
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    public static void writeln(String string, OutputStream outputStream) throws IOException {
        StreamUtils.write(string + "\n", outputStream);
    }

    public static void write(String string, OutputStream outputStream) throws IOException {
        StreamUtils.write(string, outputStream, UTF8);
    }

    public static void write(String string, OutputStream outputStream, Charset charset) throws IOException {
        outputStream.write(string.getBytes(charset));
    }
}

