/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jopendocument.util.DecimalUtils;
import org.jopendocument.util.convertor.NumberConvertor;

public class NumberUtils {
    static final int MAX_LONG_LENGTH = String.valueOf(Long.MAX_VALUE).length();

    public static final <N extends Number> boolean areEqual(N n, N n2) {
        if (n == null && n2 == null) {
            return true;
        }
        if (n == null || n2 == null) {
            return false;
        }
        Class<?> clazz = n.getClass();
        if (clazz != n2.getClass()) {
            return false;
        }
        if (clazz == AtomicInteger.class || clazz == AtomicLong.class) {
            return n.longValue() == n2.longValue();
        }
        if (clazz == BigDecimal.class) {
            return ((BigDecimal)n).compareTo((BigDecimal)n2) == 0;
        }
        return n.equals(n2);
    }

    public static final boolean areNumericallyEqual(Number number, Number number2) {
        if (number == null && number2 == null) {
            return true;
        }
        if (number == null || number2 == null) {
            return false;
        }
        return NumberUtils.compare(number, number2) == 0;
    }

    public static final int compare(Number number, Number number2) {
        Class<? extends Number> clazz = NumberUtils.getWiderClass(number, number2);
        if (clazz == AtomicInteger.class) {
            clazz = Integer.class;
        } else if (clazz == AtomicLong.class) {
            clazz = Long.class;
        }
        return NumberUtils.compare(number, number2, clazz);
    }

    private static final <N extends Number> int compare(Number number, Number number2, Class<N> clazz) {
        N n = NumberConvertor.convertExact(number, clazz);
        N n2 = NumberConvertor.convertExact(number2, clazz);
        Comparable comparable = (Comparable)n;
        return comparable.compareTo(n2);
    }

    public static final Class<? extends Number> getWiderClass(Number number, Number number2) {
        boolean bl;
        Class<?> clazz;
        Class<?> clazz2 = number.getClass();
        if (clazz2 == (clazz = number2.getClass())) {
            return clazz2;
        }
        if (clazz2 == BigDecimal.class || clazz == BigDecimal.class) {
            return BigDecimal.class;
        }
        boolean bl2 = clazz2 == Float.class || clazz2 == Double.class;
        boolean bl3 = bl = clazz == Float.class || clazz == Double.class;
        if (bl2 && bl) {
            return Double.class;
        }
        if (bl2 || bl) {
            if (clazz2 == BigInteger.class || clazz == BigInteger.class) {
                return BigDecimal.class;
            }
            return Double.class;
        }
        if (clazz2 == BigInteger.class || clazz == BigInteger.class) {
            return BigInteger.class;
        }
        if (clazz2 == Long.class || clazz == Long.class || clazz2 == AtomicLong.class || clazz == AtomicLong.class) {
            return Long.class;
        }
        if (clazz2 == Integer.class || clazz == Integer.class || clazz2 == AtomicInteger.class || clazz == AtomicInteger.class) {
            return Integer.class;
        }
        if (clazz2 == Short.class || clazz == Short.class) {
            return Short.class;
        }
        if (clazz2 == Byte.class || clazz == Byte.class) {
            return Byte.class;
        }
        throw new IllegalStateException("Unknown classes " + clazz2 + " / " + clazz);
    }

    public static final boolean hasFractionalPart(Number number) {
        if (number instanceof Integer || number instanceof Long || number instanceof Short || number instanceof Byte || number instanceof BigInteger || number instanceof AtomicLong || number instanceof AtomicInteger) {
            return false;
        }
        BigDecimal bigDecimal = number instanceof BigDecimal ? (BigDecimal)number : (number instanceof Double || number instanceof Float ? new BigDecimal(number.doubleValue()) : new BigDecimal(number.toString()));
        return DecimalUtils.decimalDigits(bigDecimal) > 0;
    }

    public static final int intDigits(long l) {
        int n;
        long l2 = Math.abs(l);
        long l3 = 10L;
        for (n = 1; l2 >= l3 && n < MAX_LONG_LENGTH; l3 = 10L * l3, ++n) {
        }
        return n;
    }

    public static final int intDigits(Number number) {
        if (number instanceof Integer || number instanceof Long || number instanceof Short || number instanceof Byte || number instanceof AtomicLong || number instanceof AtomicInteger) {
            return NumberUtils.intDigits(number.longValue());
        }
        BigDecimal bigDecimal = number instanceof BigDecimal ? (BigDecimal)number : (number instanceof BigInteger ? new BigDecimal((BigInteger)number) : (number instanceof Double || number instanceof Float ? new BigDecimal(number.doubleValue()) : new BigDecimal(number.toString())));
        return DecimalUtils.intDigits(bigDecimal);
    }

    public static Number divide(Number number, double d) {
        if (d == 1.0) {
            return number;
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).divide(new BigDecimal(d), DecimalUtils.HIGH_PRECISION);
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number).divide(new BigDecimal(d), DecimalUtils.HIGH_PRECISION);
        }
        return number.doubleValue() / d;
    }
}

