/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jopendocument.util.StreamUtils;

public class MessageDigestUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String asHex(byte[] byArray) {
        return MessageDigestUtils.toString(byArray, HEX_CHARS);
    }

    public static String toString(byte[] byArray, char[] cArray) {
        char[] cArray2 = new char[byArray.length * 2];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            cArray2[n++] = cArray[byArray[i] >>> 4 & 0xF];
            cArray2[n++] = cArray[byArray[i] & 0xF];
        }
        return new String(cArray2);
    }

    public static byte[] fromHex(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(2 * i, 2 * i + 2), 16);
        }
        return byArray;
    }

    public static byte[] int2bytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public static int bytes2int(byte[] byArray) {
        return byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static String getHashString(MessageDigest messageDigest) {
        return MessageDigestUtils.asHex(messageDigest.digest());
    }

    public static String getHashString(String string, byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        return MessageDigestUtils.getHashString(messageDigest, byArray);
    }

    public static String getHashString(MessageDigest messageDigest, byte[] byArray) {
        messageDigest.update(byArray);
        return MessageDigestUtils.getHashString(messageDigest);
    }

    public static String getHashString(MessageDigest messageDigest, InputStream inputStream) throws IOException {
        DigestOutputStream digestOutputStream = new DigestOutputStream(StreamUtils.NULL_OS, messageDigest);
        StreamUtils.copy(inputStream, digestOutputStream);
        digestOutputStream.close();
        return MessageDigestUtils.getHashString(messageDigest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            String string = MessageDigestUtils.getHashString(MessageDigestUtils.getMD5(), fileInputStream);
            return string;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public static MessageDigest getMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("MD5 is part of the standard vm", noSuchAlgorithmException);
        }
    }

    private MessageDigestUtils() {
    }
}

