/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jopendocument.util.cc.IPredicate;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public final class JDOMUtils {
    public static final XMLOutputter OUTPUTTER;
    private static final SAXBuilder BUILDER;

    public static Element parseElementString(String string, Namespace[] namespaceArray) throws JDOMException {
        return (Element)JDOMUtils.parseString(string.trim(), namespaceArray).get(0);
    }

    public static List parseString(String string, Namespace[] namespaceArray) throws JDOMException {
        String string2 = "<dummy";
        for (int i = 0; i < namespaceArray.length; ++i) {
            Namespace namespace = namespaceArray[i];
            string2 = string2 + " xmlns:" + namespace.getPrefix() + "=\"" + namespace.getURI() + "\"";
        }
        string = string2 + ">" + string + "</dummy>";
        return JDOMUtils.parseStringDocument(string).getRootElement().removeContent();
    }

    public static Element parseString(String string) throws JDOMException {
        return JDOMUtils.parseElementString(string, new Namespace[0]);
    }

    public static synchronized Document parseStringDocument(String string) throws JDOMException {
        return JDOMUtils.parseStringDocument(string, BUILDER);
    }

    public static Document parseStringDocument(String string, SAXBuilder sAXBuilder) throws JDOMException {
        Document document = null;
        try {
            document = sAXBuilder.build(new StringReader(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return document;
    }

    public static String output(Element element) {
        return OUTPUTTER.outputString(element);
    }

    public static String output(Document document) {
        return OUTPUTTER.outputString(document);
    }

    public static Element getAncestor(Element element, final String string, final Namespace namespace) {
        return JDOMUtils.getAncestor(element, new IPredicate<Element>(){

            @Override
            public boolean evaluateChecked(Element element) {
                return element.getName().equals(string) && element.getNamespace().equals(namespace);
            }
        });
    }

    public static Element getAncestor(Element element, IPredicate<Element> iPredicate) {
        for (Element element2 = element; element2 != null; element2 = element2.getParentElement()) {
            if (!iPredicate.evaluateChecked(element2)) continue;
            return element2;
        }
        return null;
    }

    public static void addNamespaces(Element element, Collection<Namespace> collection) {
        if (collection instanceof RandomAccess && collection instanceof List) {
            List list = (List)collection;
            int n = collection.size() - 1;
            for (int i = 0; i < n; ++i) {
                Namespace namespace = (Namespace)list.get(i);
                if (element.getNamespace(namespace.getPrefix()) != null) continue;
                element.addNamespaceDeclaration(namespace);
            }
        } else {
            for (Namespace namespace : collection) {
                if (element.getNamespace(namespace.getPrefix()) != null) continue;
                element.addNamespaceDeclaration(namespace);
            }
        }
    }

    public static void addNamespaces(Element element, Namespace ... namespaceArray) {
        for (Namespace namespace : namespaceArray) {
            if (element.getNamespace(namespace.getPrefix()) != null) continue;
            element.addNamespaceDeclaration(namespace);
        }
    }

    public Element mkElem(Element element, String string) {
        String[] stringArray = string.split("/");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String[] stringArray2 = string2.split(":");
            Element element2 = stringArray2.length == 1 ? new Element(string2) : new Element(stringArray2[1], element.getNamespace(stringArray2[0]));
            element.addContent(element2);
            element = element2;
        }
        return element;
    }

    public static void insertAfter(Element element, Collection<? extends Content> collection) {
        JDOMUtils.insertSiblings(element, collection, true);
    }

    public static void insertBefore(Element element, Collection<? extends Content> collection) {
        JDOMUtils.insertSiblings(element, collection, false);
    }

    public static void insertSiblings(Element element, Collection<? extends Content> collection, boolean bl) {
        Element element2 = element.getParentElement();
        int n = element2.indexOf(element);
        element2.addContent(bl ? n + 1 : n, collection);
    }

    public static boolean equals(Element element, Element element2) {
        if (element == null && element2 == null) {
            return true;
        }
        if (element == null || element2 == null) {
            return false;
        }
        return element.getName().equals(element2.getName()) && element.getNamespace().equals(element2.getNamespace());
    }

    static SAXException validate(Document document, Schema schema, ErrorHandler errorHandler) {
        ByteArrayInputStream byteArrayInputStream;
        try {
            byteArrayInputStream = new ByteArrayInputStream(JDOMUtils.output(document).getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("unicode not found ", unsupportedEncodingException);
        }
        Validator validator = schema.newValidator();
        if (errorHandler != null) {
            validator.setErrorHandler(errorHandler);
        }
        try {
            validator.validate(new StreamSource(byteArrayInputStream));
            return null;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unable to read the document", iOException);
        }
        catch (SAXException sAXException) {
            return sAXException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void validateDTD(Document document, SAXBuilder sAXBuilder, ErrorHandler errorHandler) throws JDOMException {
        ErrorHandler errorHandler2 = sAXBuilder.getErrorHandler();
        boolean bl = sAXBuilder.getValidation();
        try {
            sAXBuilder.setErrorHandler(errorHandler);
            sAXBuilder.setValidation(true);
            JDOMUtils.parseStringDocument(JDOMUtils.output(document), sAXBuilder);
        }
        finally {
            sAXBuilder.setErrorHandler(errorHandler2);
            sAXBuilder.setValidation(bl);
        }
    }

    static {
        Format format = Format.getRawFormat();
        format.setLineSeparator("\n");
        OUTPUTTER = new XMLOutputter(format);
        BUILDER = new SAXBuilder();
        BUILDER.setValidation(false);
    }
}

