/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.util.Comparator;
import java.util.List;
import org.jopendocument.util.NumberUtils;
import org.jopendocument.util.cc.ITransformer;

public class CompareUtils {
    public static final int compareIntNumbers(Number number, Number number2) {
        return CompareUtils.compareLong(number.longValue(), number2.longValue());
    }

    public static final int compareInt(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        if (n == n2) {
            return 0;
        }
        return 1;
    }

    public static final int compareLong(long l, long l2) {
        if (l < l2) {
            return -1;
        }
        if (l == l2) {
            return 0;
        }
        return 1;
    }

    public static final int compare(Object object, Object object2) throws ClassCastException {
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        if (object instanceof Number && object2 instanceof Number) {
            return NumberUtils.compare((Number)object, (Number)object2);
        }
        int n = ((Comparable)object).compareTo(object2);
        return n;
    }

    public static final <T> Comparator<T> createComparator(final List<? extends Comparator<T>> list) {
        return new Comparator<T>(){

            public String toString() {
                return "CompareUtils comparator with " + list;
            }

            @Override
            public int compare(T t, T t2) {
                int n = 0;
                for (int i = 0; i < list.size() && n == 0; ++i) {
                    Comparator comparator = (Comparator)list.get(i);
                    n = comparator.compare(t, t2);
                }
                return n;
            }
        };
    }

    public static final boolean equals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static final <T> boolean equalsWithCompareTo(Comparable<T> comparable, T t) {
        if (comparable == null && t == null) {
            return true;
        }
        if (comparable == null || t == null) {
            return false;
        }
        return comparable.compareTo(t) == 0;
    }

    public static final <T> boolean equals(List<T> list, List<T> list2, Equalizer<? super T> equalizer) {
        return CompareUtils.compare(list, list2, equalizer, null) == null;
    }

    public static final <T> String compare(List<T> list, List<T> list2, Equalizer<? super T> equalizer, ITransformer<? super T, String> iTransformer) {
        int n = list.size();
        if (n != list2.size()) {
            return "unequal size";
        }
        for (int i = 0; i < n; ++i) {
            T t;
            T t2 = list.get(i);
            if (equalizer.equals(t2, t = list2.get(i))) continue;
            String string = iTransformer == null ? String.valueOf(t2) : iTransformer.transformChecked(t2);
            String string2 = iTransformer == null ? String.valueOf(t) : iTransformer.transformChecked(t);
            return "unequal at " + i + ": " + string + " != " + string2;
        }
        return null;
    }

    public static interface Equalizer<T> {
        public boolean equals(T var1, T var2);
    }
}

