/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.renderer.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.model.office.OfficeBody;
import org.jopendocument.renderer.text.TextPage;

public class TextRenderer
extends JPanel {
    private double resizeFactor;
    private OfficeBody body;
    private static boolean debug = false;
    private TextPage currentPage;
    private boolean paintMaxResolution;
    private OpenDocument od;
    private int currentPageIndex;
    private int printWidthPixel;
    private int printHeightPixel;
    private int nbPages;

    public TextRenderer(OpenDocument openDocument) {
        this.body = openDocument.getBody();
        this.setBackground(Color.WHITE);
        this.currentPageIndex = 0;
        this.currentPage = (TextPage)openDocument.getPrintedPage(this.currentPageIndex);
        this.setResizeFactor(360.0);
        this.od = openDocument;
    }

    public void setCurrentPage(int n) {
        this.currentPageIndex = n;
        this.currentPage = (TextPage)this.od.getPrintedPage(n);
        this.updateSize();
        this.repaint();
    }

    private void updateSize() {
        this.setSize(this.getPageWidthInPixel(), this.getPageHeightInPixel());
    }

    public double getPageHeight() {
        return (double)this.getPageHeightInPixel() * this.resizeFactor;
    }

    public int getPageHeightInPixel() {
        int n = 0;
        return n;
    }

    public double getPageWidth() {
        return (double)this.getPageWidthInPixel() * this.resizeFactor;
    }

    public int getPageWidthInPixel() {
        int n = 0;
        return n;
    }

    public synchronized void setResizeFactor(double d) {
        this.resizeFactor = d;
        this.updateSize();
        this.repaint();
    }

    public int getPrintWidthInPixel() {
        return this.printWidthPixel;
    }

    public int getPrintHeightInPixel() {
        return this.printHeightPixel;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.currentPage.render(graphics2D);
    }

    public void printRendererInformation() {
        System.out.println("==== Text Renderer ===");
        System.out.println("Rendering file: " + this.od.getZipFile().getName());
        System.out.println("Max image quality: " + this.paintMaxResolution);
        System.out.println("Current page: " + (this.currentPageIndex + 1) + "  / " + this.getPrintedPagesNumber());
        System.out.println("Width: " + (long)this.getPageWidthInPixel() + " micrometers (" + this.getPageWidthInPixel() / 10000 + " cms)");
        System.out.println("Height: " + (long)this.getPageHeightInPixel() + " micrometers (" + this.getPageHeightInPixel() / 10000 + " cms)");
        System.out.println("Size in pixels: " + this.getPrintWidthInPixel() + "x" + this.getPrintHeightInPixel());
        System.out.println("Resize factor " + this.resizeFactor);
        System.out.println();
    }

    private int getPrintedPagesNumber() {
        return this.nbPages;
    }

    public void setDebug(boolean bl) {
        debug = true;
    }
}

