/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.model.style;

import java.awt.Color;
import org.jopendocument.util.Tuple3;
import org.jopendocument.util.ValueHelper;

public class StyleTableCellProperties {
    private String backgroundColor;
    private String border;
    private Color borderColorBottom;
    private Color borderColorLeft;
    private Color borderColorRight;
    private Color borderColorTop;
    private String borderTypeBottom;
    private String borderTypeLeft;
    private String borderTypeRight;
    private String borderTypeTop;
    private int borderWidthBottom;
    private int borderWidthLeft;
    private int borderWidthRight;
    private int borderWidthTop;
    private boolean hasBottomBorder;
    private boolean hasLeftBorder;
    private boolean hasRightBorder;
    private boolean hasTopBorder;
    private String padding;
    private String repeatContent;
    private String textAlignSource;
    private String verticalAlign;
    private String wrapOption;
    private boolean backgroundImage;

    private static Tuple3<Integer, String, Color> parseBorder(String string) {
        if (string == null || "none".equals(string)) {
            return null;
        }
        String[] stringArray = string.split(" ");
        String string2 = stringArray[0];
        if (string2.equals("thin")) {
            string2 = "0.002cm";
        } else if (string2.equals("medium")) {
            string2 = "0.035cm";
        } else if (string2.equals("thick")) {
            string2 = "0.088cm";
        }
        int n = ValueHelper.getLength(string2);
        String string3 = stringArray[1];
        Color color = stringArray.length >= 3 ? ValueHelper.getColor(stringArray[2]) : Color.BLACK;
        return Tuple3.create(n, string3, color);
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getBorder() {
        return this.border;
    }

    public final Color getBorderColorBottom() {
        return this.borderColorBottom;
    }

    public final Color getBorderColorLeft() {
        return this.borderColorLeft;
    }

    public final Color getBorderColorRight() {
        return this.borderColorRight;
    }

    public final Color getBorderColorTop() {
        return this.borderColorTop;
    }

    public final String getBorderTypeBottom() {
        return this.borderTypeBottom;
    }

    public final String getBorderTypeLeft() {
        return this.borderTypeLeft;
    }

    public final String getBorderTypeRight() {
        return this.borderTypeRight;
    }

    public final String getBorderTypeTop() {
        return this.borderTypeTop;
    }

    public final int getBorderWidthBottom() {
        return this.borderWidthBottom;
    }

    public final int getBorderWidthLeft() {
        return this.borderWidthLeft;
    }

    public final int getBorderWidthRight() {
        return this.borderWidthRight;
    }

    public final int getBorderWidthTop() {
        return this.borderWidthTop;
    }

    public String getPadding() {
        return this.padding;
    }

    public String getRepeatContent() {
        return this.repeatContent;
    }

    public String getTextAlignSource() {
        return this.textAlignSource;
    }

    public String getVerticalAlign() {
        return this.verticalAlign;
    }

    public String getWrapOption() {
        return this.wrapOption;
    }

    public final boolean hasBottomBorder() {
        return this.hasBottomBorder;
    }

    public final boolean hasLeftBorder() {
        return this.hasLeftBorder;
    }

    public final boolean hasRightBorder() {
        return this.hasRightBorder;
    }

    public final boolean hasTopBorder() {
        return this.hasTopBorder;
    }

    public void setBackgroundColor(String string) {
        this.backgroundColor = string;
    }

    public void setBorder(String string) {
        if (string != null) {
            this.setBorderLeft(string);
            this.setBorderTop(string);
            this.setBorderRight(string);
            this.setBorderBottom(string);
        }
    }

    public void setBorderBottom(String string) {
        Tuple3<Integer, String, Color> tuple3 = StyleTableCellProperties.parseBorder(string);
        if (tuple3 == null) {
            return;
        }
        this.hasBottomBorder = true;
        this.borderWidthBottom = (Integer)tuple3.get0();
        this.borderTypeBottom = (String)tuple3.get1();
        this.borderColorBottom = tuple3.get2();
    }

    public void setBorderLeft(String string) {
        Tuple3<Integer, String, Color> tuple3 = StyleTableCellProperties.parseBorder(string);
        if (tuple3 == null) {
            return;
        }
        this.hasLeftBorder = true;
        this.borderWidthLeft = (Integer)tuple3.get0();
        this.borderTypeLeft = (String)tuple3.get1();
        this.borderColorLeft = tuple3.get2();
    }

    public void setBorderRight(String string) {
        Tuple3<Integer, String, Color> tuple3 = StyleTableCellProperties.parseBorder(string);
        if (tuple3 == null) {
            return;
        }
        this.hasRightBorder = true;
        this.borderWidthRight = (Integer)tuple3.get0();
        this.borderTypeRight = (String)tuple3.get1();
        this.borderColorRight = tuple3.get2();
    }

    public void setBorderTop(String string) {
        Tuple3<Integer, String, Color> tuple3 = StyleTableCellProperties.parseBorder(string);
        if (tuple3 == null) {
            return;
        }
        this.hasTopBorder = true;
        this.borderWidthTop = (Integer)tuple3.get0();
        this.borderTypeTop = (String)tuple3.get1();
        this.borderColorTop = tuple3.get2();
    }

    public void setPadding(String string) {
        this.padding = string;
    }

    public void setRepeatContent(String string) {
        this.repeatContent = string;
    }

    public void setTextAlignSource(String string) {
        this.textAlignSource = string;
    }

    public void setVerticalAlign(String string) {
        this.verticalAlign = string;
    }

    public void setWrapOption(String string) {
        this.wrapOption = string;
    }

    public String toString() {
        return "StyleTableCellProperties: border: L:" + this.borderTypeLeft + " R:" + this.borderTypeRight + " T:" + this.borderTypeTop + " B:" + this.borderTypeTop;
    }

    public void setBackgroundImage(boolean bl) {
        this.backgroundImage = bl;
    }
}

