/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.model;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import org.jopendocument.io.SaxContentUnmarshaller;
import org.jopendocument.io.SaxStylesUnmarshaller;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.model.Page;
import org.jopendocument.model.office.OfficeAutomaticStyles;
import org.jopendocument.model.office.OfficeBody;
import org.jopendocument.model.office.OfficeMasterStyles;
import org.jopendocument.model.office.OfficeStyles;
import org.jopendocument.model.office.OfficeText;
import org.jopendocument.model.style.StyleDefaultStyle;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.text.TextH;
import org.jopendocument.renderer.text.HeaderRenderBlock;
import org.jopendocument.renderer.text.TextPage;
import org.jopendocument.util.ImageUtils;
import org.jopendocument.util.StreamUtils;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TextDocument
extends OpenDocument {
    private static final int MAX_IN_MEMORY_HQ_IMAGE = 10;
    private OfficeAutomaticStyles autoStyles;
    private OfficeBody body;
    private final Map<String, Image> images = new HashMap<String, Image>();
    private final Map<String, Image> imagesHQ = new HashMap<String, Image>();
    private OfficeMasterStyles masterStyles;
    private List<TextPage> pages;
    private OfficeStyles styles;
    private ZipFile zipFile;

    public TextDocument() {
    }

    public TextDocument(File file) {
        this.loadFrom(file);
    }

    @Override
    public OfficeAutomaticStyles getAutomaticStyles() {
        return this.autoStyles;
    }

    @Override
    public OfficeBody getBody() {
        return this.body;
    }

    @Override
    public Image getImage(String string) {
        Object object;
        Object object2;
        Image image = this.images.get(string);
        if (image != null) {
            return image;
        }
        ZipEntry zipEntry = this.zipFile.getEntry(string);
        byte[] byArray = null;
        try {
            int n;
            object2 = this.zipFile.getInputStream(zipEntry);
            object = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[4096];
            while ((n = ((InputStream)object2).read(byArray2, 0, 4096)) != -1) {
                ((ByteArrayOutputStream)object).write(byArray2, 0, n);
            }
            ((ByteArrayOutputStream)object).close();
            byArray = ((ByteArrayOutputStream)object).toByteArray();
            ((InputStream)object2).read(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object2 = new ImageIcon(byArray);
        object = ((ImageIcon)object2).getImage();
        if (((ImageIcon)object2).getImageLoadStatus() != 8) {
            throw new IllegalStateException("Unable to load:'" + string + "'");
        }
        this.images.put(string, (Image)object);
        return object;
    }

    @Override
    public Image getImage(String string, int n, int n2) {
        String string2 = n + "," + n2;
        Image image = this.imagesHQ.get(string2);
        if (image != null) {
            return image;
        }
        image = ImageUtils.createQualityResizedImage(this.getImage(string), n, n2);
        if (this.imagesHQ.size() > 10) {
            this.imagesHQ.clear();
        }
        this.imagesHQ.put(string2, image);
        return image;
    }

    @Override
    public OfficeMasterStyles getMasterStyles() {
        return this.masterStyles;
    }

    @Override
    public Page getPrintedPage(int n) {
        if (this.pages == null) {
            this.computePages();
        }
        return this.pages.get(n);
    }

    private void computePages() {
        this.pages = new ArrayList<TextPage>();
        TextPage textPage = new TextPage();
        this.pages.add(textPage);
        OfficeText officeText = this.getBody().getText();
        System.err.println("--- Dump ----- " + officeText.getElementCount() + " elements");
        int n = officeText.getElementCount();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            Object object = officeText.getElementAt(i);
            System.err.println(i + ":" + object);
            if (!(object instanceof TextH)) continue;
            HeaderRenderBlock headerRenderBlock = new HeaderRenderBlock((TextH)object, n3, n2);
            headerRenderBlock.setX(n4);
            headerRenderBlock.setY(n5);
            textPage.add(headerRenderBlock);
            n2 -= headerRenderBlock.getHeight();
            n5 += headerRenderBlock.getHeight();
        }
    }

    @Override
    public int getPrintedPageCount() {
        return this.pages.size();
    }

    @Override
    public OfficeStyles getStyles() {
        return this.styles;
    }

    @Override
    public ZipFile getZipFile() {
        return this.zipFile;
    }

    @Override
    public void importAutoStylesFrom(OfficeAutomaticStyles officeAutomaticStyles) {
        for (StyleStyle styleStyle : officeAutomaticStyles.getStyles()) {
            this.autoStyles.addStyle(styleStyle);
        }
    }

    @Override
    public void init(OfficeBody officeBody, OfficeAutomaticStyles officeAutomaticStyles, OfficeStyles officeStyles, OfficeAutomaticStyles officeAutomaticStyles2, OfficeMasterStyles officeMasterStyles) {
        if (officeBody == null) {
            throw new IllegalArgumentException("OfficeBody cannot be null");
        }
        if (officeAutomaticStyles == null) {
            throw new IllegalArgumentException("OfficeAutomaticStyles cannot be null");
        }
        if (officeStyles == null) {
            throw new IllegalArgumentException("OfficeStyles cannot be null");
        }
        if (officeAutomaticStyles2 == null) {
            throw new IllegalArgumentException("OfficeAutomaticStyles cannot be null");
        }
        if (officeMasterStyles == null) {
            throw new IllegalArgumentException("OfficeMasterStyles cannot be null");
        }
        this.body = officeBody;
        this.body.setDocument(this);
        this.styles = officeStyles;
        this.autoStyles = officeAutomaticStyles2;
        this.importAutoStylesFrom(officeAutomaticStyles);
        StyleDefaultStyle styleDefaultStyle = officeStyles.getDefaultCellStyle();
        if (styleDefaultStyle == null) {
            styleDefaultStyle = new StyleDefaultStyle();
            styleDefaultStyle.setStyleFamily("table-cell");
        }
        StyleStyle styleStyle = new StyleStyle();
        styleStyle.setStyleName("Default");
        styleStyle.setTextProperties(styleDefaultStyle.getStyleTextProperties());
        styleStyle.setStyleProperties(styleDefaultStyle.getStyleProperties());
        this.autoStyles.addStyle(styleStyle);
        this.masterStyles = officeMasterStyles;
    }

    @Override
    public void loadFrom(File file) {
        SaxContentUnmarshaller saxContentUnmarshaller = new SaxContentUnmarshaller(this);
        SaxStylesUnmarshaller saxStylesUnmarshaller = new SaxStylesUnmarshaller(this);
        try {
            Object object;
            this.zipFile = new ZipFile(file);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(saxStylesUnmarshaller);
            ZipEntry zipEntry = this.zipFile.getEntry("styles.xml");
            if (zipEntry != null) {
                object = new InputSource(new InputStreamReader(this.zipFile.getInputStream(zipEntry), "UTF-8"));
                xMLReader.parse((InputSource)object);
            }
            xMLReader.setContentHandler(saxContentUnmarshaller);
            object = this.zipFile.getEntry("content.xml");
            InputSource inputSource = new InputSource(new InputStreamReader(this.zipFile.getInputStream((ZipEntry)object), "UTF-8"));
            xMLReader.parse(inputSource);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.init(saxContentUnmarshaller.getBody(), saxContentUnmarshaller.getAutomaticstyles(), saxStylesUnmarshaller.getStyles(), saxStylesUnmarshaller.getAutomaticStyles(), saxStylesUnmarshaller.getMasterStyles());
    }

    @Override
    public void loadFrom(String string) {
        this.loadFrom(new File(string));
    }

    @Override
    public void loadFrom(URL uRL) throws IOException {
        if (!uRL.getPath().toLowerCase().endsWith(".odt")) {
            throw new IllegalArgumentException("This class is only for ODT files");
        }
        File file = File.createTempFile("jOpenDocument", ".odt");
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        StreamUtils.copy(uRL.openStream(), fileOutputStream);
        fileOutputStream.close();
        this.loadFrom(file);
    }

    @Override
    public void preloadImage(String string) {
        this.getImage(string);
    }

    @Override
    public void setAutomaticStyles(OfficeAutomaticStyles officeAutomaticStyles) {
        this.autoStyles = officeAutomaticStyles;
    }

    @Override
    public void setMasterStyles(OfficeMasterStyles officeMasterStyles) {
        this.masterStyles = officeMasterStyles;
    }

    public void dumpPages() {
        OfficeText officeText = this.getBody().getText();
        System.err.println("--- Dump ----- " + officeText.getElementCount() + " elements");
        int n = officeText.getElementCount();
        for (int i = 0; i < n; ++i) {
            System.err.println(i + ":" + officeText.getElementAt(i));
        }
    }
}

