/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.util.Tuple2;

public class StyleResolver {
    private final Map<Tuple2<String, String>, StyleStyle> styles = new HashMap<Tuple2<String, String>, StyleStyle>();

    public void add(StyleStyle styleStyle) {
        if (this.styles.containsKey(styleStyle.getStyleName())) {
            throw new IllegalArgumentException("Style: " + styleStyle + " already in the style resolver : " + this.styles.get(styleStyle.getStyleName()));
        }
        this.styles.put(Tuple2.create(styleStyle.getStyleName(), styleStyle.getStyleFamily()), styleStyle);
    }

    public StyleStyle getStyle(String string, String string2) {
        return this.styles.get(Tuple2.create(string, string2));
    }

    public void dump() {
        Collection<StyleStyle> collection = this.styles.values();
        System.err.println("StyleResolver: " + collection.size() + " styles");
        for (StyleStyle styleStyle : collection) {
            System.err.println(styleStyle);
        }
    }
}

