/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.link;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jopendocument.link.Component;
import org.jopendocument.link.OOInstallation;
import org.jopendocument.util.CollectionUtils;
import org.jopendocument.util.protocol.Helper;

public abstract class OOConnexion {
    private static final Map<OOInstallation, ClassLoader> loaders = new WeakHashMap<OOInstallation, ClassLoader>(2);
    private static final String OO_VERSION = "3";

    private static final URL[] getURLs(OOInstallation oOInstallation) {
        List<URL> list = oOInstallation.getURLs(CollectionUtils.createSet("ridl.jar", "jurt.jar", "juh.jar", "unoil.jar"));
        URL uRL = OOConnexion.class.getResource("OO3-link.jar");
        if (uRL == null) {
            throw new IllegalStateException("Missing OO3-link.jar");
        }
        list.add(Helper.toJarJar(uRL));
        return list.toArray(new URL[list.size()]);
    }

    private static final ClassLoader getLoader(OOInstallation oOInstallation) {
        ClassLoader classLoader = loaders.get(oOInstallation);
        if (classLoader == null) {
            classLoader = new URLClassLoader(OOConnexion.getURLs(oOInstallation), OOConnexion.class.getClassLoader());
            loaders.put(oOInstallation, classLoader);
        }
        return classLoader;
    }

    public static OOConnexion create() throws IllegalStateException {
        OOInstallation oOInstallation;
        try {
            oOInstallation = OOInstallation.getInstance();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Couldn't find default OO installation", iOException);
        }
        return OOConnexion.create(oOInstallation);
    }

    public static OOConnexion create(OOInstallation oOInstallation) throws IllegalStateException {
        if (oOInstallation == null) {
            return null;
        }
        try {
            Class<?> clazz = OOConnexion.getLoader(oOInstallation).loadClass("org.jopendocument.link3.OOConnexion");
            return (OOConnexion)clazz.getConstructor(OOInstallation.class).newInstance(oOInstallation);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Couldn't create OOCOnnexion", exception);
        }
    }

    protected abstract Component loadDocumentFromURLAsync(String var1, boolean var2);

    public final Component loadDocument(File file, boolean bl) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        return this.loadDocumentFromURLAsync(this.convertToUrl(file.getAbsolutePath()), bl);
    }

    protected abstract String convertToUrl(String var1) throws MalformedURLException;

    public abstract void closeConnexion();

    public abstract boolean isClosed();

    static {
        Helper.register();
    }
}

